/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.internal;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.internal.shaded.jctools.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.io.opentelemetry.internal.shaded.jctools.queues.MpscArrayQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public final class JcTools {
    private static final AtomicBoolean queueCreationWarningLogged = new AtomicBoolean();
    private static final e logger = e.a(JcTools.class.getName());

    public static <T> Queue<T> newFixedSizeQueue(int n2) {
        try {
            return new MpscArrayQueue(n2);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError linkageError) {
            if (!queueCreationWarningLogged.getAndSet(true)) {
                logger.a(e.a.c, "Cannot create high-performance queue, reverting to ArrayBlockingQueue ({0})", (Object)Objects.toString(linkageError, "unknown cause"));
            }
            return new ArrayBlockingQueue(n2);
        }
    }

    public static long capacity(Queue<?> queue) {
        if (queue instanceof MessagePassingQueue) {
            return ((MessagePassingQueue)((Object)queue)).capacity();
        }
        return (long)((ArrayBlockingQueue)queue).remainingCapacity() + (long)queue.size();
    }

    public static <T> void drain(Queue<T> queue, int n2, Consumer<T> consumer) {
        if (queue instanceof MessagePassingQueue) {
            ((MessagePassingQueue)((Object)queue)).drain(consumer::accept, n2);
        } else {
            JcTools.drainNonJcQueue(queue, n2, consumer);
        }
    }

    private static <T> void drainNonJcQueue(Queue<T> queue, int n2, Consumer<T> consumer) {
        T t2;
        int n3 = 0;
        while (n3++ < n2 && (t2 = queue.poll()) != null) {
            consumer.accept(t2);
        }
    }

    private JcTools() {
    }
}

