/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.agent.l.a;
import com.contrastsecurity.thirdparty.jregex.LAEntry;
import com.contrastsecurity.thirdparty.jregex.MatchIterator;
import com.contrastsecurity.thirdparty.jregex.MatchResult;
import com.contrastsecurity.thirdparty.jregex.MemReg;
import com.contrastsecurity.thirdparty.jregex.Pattern;
import com.contrastsecurity.thirdparty.jregex.SearchEntry;
import com.contrastsecurity.thirdparty.jregex.Term;
import com.contrastsecurity.thirdparty.jregex.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Matcher
implements MatchResult {
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_LASTMATCH = 2;
    public static final int ANCHOR_END = 4;
    public static final int ACCEPT_INCOMPLETE = 8;
    private static Term startAnchor = new Term(18);
    private static Term lastMatchAnchor = new Term(23);
    private Pattern re;
    private int[] counters;
    private MemReg[] memregs;
    private LAEntry[] lookaheads;
    private int counterCount;
    private int memregCount;
    private int lookaheadCount;
    private char[] data;
    private int offset;
    private int end;
    private int wOffset;
    private int wEnd;
    private boolean shared;
    private SearchEntry top;
    private SearchEntry first;
    private SearchEntry defaultEntry;
    private boolean called;
    private int minQueueLength;
    private String cache;
    private int cacheOffset;
    private int cacheLength;
    private MemReg prefixBounds;
    private MemReg suffixBounds;
    private MemReg targetBounds;

    Matcher(Pattern pattern) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        this.re = pattern;
        int n5 = pattern.memregs;
        if (n5 > 0) {
            objectArray = new MemReg[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                objectArray[n4] = new MemReg(-1);
            }
            this.memregs = objectArray;
        }
        if ((n3 = pattern.counters) > 0) {
            this.counters = new int[n3];
        }
        if ((n2 = pattern.lookaheads) > 0) {
            objectArray = new LAEntry[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                objectArray[n4] = new LAEntry();
            }
            this.lookaheads = objectArray;
        }
        this.memregCount = n5;
        this.counterCount = n3;
        this.lookaheadCount = n2;
        this.first = new SearchEntry();
        this.defaultEntry = new SearchEntry();
        this.minQueueLength = pattern.stringRepr.length() / 2;
    }

    public char[] getData() {
        return this.data;
    }

    public boolean isShared() {
        return this.shared;
    }

    public final void setTarget(Matcher matcher, int n2) {
        MemReg memReg = matcher.bounds(n2);
        if (memReg == null) {
            throw new IllegalArgumentException("group #" + n2 + " is not assigned");
        }
        this.data = matcher.data;
        this.offset = memReg.in;
        this.end = memReg.out;
        this.cache = matcher.cache;
        this.cacheLength = matcher.cacheLength;
        this.cacheOffset = matcher.cacheOffset;
        if (matcher != this) {
            this.shared = true;
            matcher.shared = true;
        }
        this.init();
    }

    public void setTarget(a a2, String string) {
        this.setTarget(a2, string, 0, string.length());
    }

    public void setTarget(String string) {
        this.setTarget(null, string, 0, string.length());
    }

    public void setTarget(a a2, String string, int n2, int n3) {
        if (this.data == null || this.shared || this.data.length < n3) {
            if (a2 == null) {
                this.data = new char[n3];
            } else {
                a2.a(string, n2, n3);
                this.data = a2.a();
            }
            this.shared = false;
        }
        if (a2 == null) {
            string.getChars(n2, n3, this.data, 0);
        }
        this.offset = 0;
        this.end = n3;
        this.cache = string;
        this.cacheOffset = -n2;
        this.cacheLength = string.length();
        this.init();
    }

    public void setTarget(char[] cArray, int n2, int n3) {
        this.setTarget(cArray, n2, n3, true);
    }

    public final void setTarget(char[] cArray, int n2, int n3, boolean bl2) {
        this.cache = null;
        this.data = cArray;
        this.offset = n2;
        this.end = n2 + n3;
        this.shared = bl2;
        this.init();
    }

    public void setTarget(Reader reader, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            this.setAll(reader);
            return;
        }
        char[] cArray = this.data;
        boolean bl2 = this.shared;
        if (cArray == null || bl2 || cArray.length < n2) {
            cArray = new char[n2];
            bl2 = false;
        }
        int n4 = 0;
        while ((n3 = reader.read(cArray, n4, n2)) >= 0) {
            n4 += n3;
            if ((n2 -= n3) != 0) continue;
        }
        this.setTarget(cArray, 0, n4, bl2);
    }

    private void setAll(Reader reader) throws IOException {
        int n2;
        int n3;
        char[] cArray = this.data;
        boolean bl2 = this.shared;
        if (cArray == null || bl2) {
            n3 = 1024;
            cArray = new char[1024];
            bl2 = false;
        } else {
            n3 = cArray.length;
        }
        int n4 = 0;
        while ((n2 = reader.read(cArray, n4, n3)) >= 0) {
            n4 += n2;
            if ((n3 -= n2) != 0) continue;
            int n5 = n4 * 3;
            char[] cArray2 = new char[n5];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = cArray2;
            n3 = n5 - n4;
            bl2 = false;
        }
        this.setTarget(cArray, 0, n4, bl2);
    }

    private final String getString(int n2, int n3) {
        String string = this.cache;
        if (string != null) {
            int n4 = this.cacheOffset;
            return string.substring(n2 - n4, n3 - n4);
        }
        int n5 = this.end;
        int n6 = this.offset;
        int n7 = n5 - n6;
        char[] cArray = this.data;
        if (n3 - n2 >= n7 / 3) {
            this.cache = string = new String(cArray, n6, n7);
            this.cacheOffset = n6;
            this.cacheLength = n7;
            return string.substring(n2 - n6, n3 - n6);
        }
        return new String(cArray, n2, n3 - n2);
    }

    public final boolean matchesPrefix() {
        this.setPosition(0);
        return this.search(13);
    }

    public final boolean isStart() {
        return this.matchesPrefix();
    }

    public final boolean matches() {
        if (this.called) {
            this.setPosition(0);
        }
        return this.search(5);
    }

    public final boolean matches(String string) {
        this.setTarget(string);
        return this.search(5);
    }

    public void setPosition(int n2) {
        this.wOffset = this.offset + n2;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public final boolean find() {
        if (this.called) {
            this.skip();
        }
        return this.search(0);
    }

    public final boolean find(int n2) {
        if (this.called) {
            this.skip();
        }
        return this.search(n2);
    }

    public MatchIterator findAll() {
        return this.findAll(0);
    }

    public MatchIterator findAll(final int n2) {
        return new MatchIterator(){
            private boolean checked = false;
            private boolean hasMore = false;

            @Override
            public boolean hasMore() {
                if (!this.checked) {
                    this.check();
                }
                return this.hasMore;
            }

            @Override
            public MatchResult nextMatch() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.checked = false;
                return Matcher.this;
            }

            private final void check() {
                this.hasMore = Matcher.this.find(n2);
                this.checked = true;
            }

            @Override
            public int count() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    return 0;
                }
                int n22 = 1;
                while (Matcher.this.find(n2)) {
                    ++n22;
                }
                this.checked = false;
                return n22;
            }
        };
    }

    public final boolean proceed() {
        return this.proceed(0);
    }

    public final boolean proceed(int n2) {
        if (this.called && this.top == null) {
            ++this.wOffset;
        }
        return this.search(0);
    }

    public final void skip() {
        int n2 = this.wEnd;
        if (this.wOffset == n2) {
            if (this.top == null) {
                ++this.wOffset;
                this.flush();
            }
            return;
        }
        this.wOffset = n2 < 0 ? 0 : n2;
        this.flush();
    }

    private final void init() {
        this.wOffset = this.offset;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    private final void flush() {
        MemReg memReg;
        int n2;
        this.top = null;
        this.defaultEntry.reset(0);
        this.first.reset(this.minQueueLength);
        for (n2 = this.memregs.length - 1; n2 > 0; --n2) {
            memReg = this.memregs[n2];
            memReg.out = -1;
            memReg.in = -1;
        }
        for (n2 = this.memregs.length - 1; n2 > 0; --n2) {
            memReg = this.memregs[n2];
            memReg.out = -1;
            memReg.in = -1;
        }
        this.called = false;
    }

    private final void rflush() {
        SearchEntry searchEntry = this.top;
        this.top = null;
        MemReg[] memRegArray = this.memregs;
        int[] nArray = this.counters;
        while (searchEntry != null) {
            SearchEntry searchEntry2 = searchEntry.sub;
            SearchEntry.popState(searchEntry, memRegArray, nArray);
            searchEntry = searchEntry2;
        }
        SearchEntry.popState(this.defaultEntry, memRegArray, nArray);
    }

    public String toString() {
        return this.getString(this.wOffset, this.wEnd);
    }

    @Override
    public Pattern pattern() {
        return this.re;
    }

    @Override
    public String target() {
        return this.getString(this.offset, this.end);
    }

    @Override
    public char[] targetChars() {
        this.shared = true;
        return this.data;
    }

    @Override
    public int targetStart() {
        return this.offset;
    }

    @Override
    public int targetEnd() {
        return this.end;
    }

    @Override
    public char charAt(int n2) {
        int n3 = this.wOffset;
        int n4 = this.wEnd;
        if (n3 < 0 || n4 < n3) {
            throw new IllegalStateException("unassigned");
        }
        return this.data[n3 + n2];
    }

    @Override
    public char charAt(int n2, int n3) {
        MemReg memReg = this.bounds(n3);
        if (memReg == null) {
            throw new IllegalStateException("group #" + n3 + " is not assigned");
        }
        int n4 = memReg.in;
        if (n2 < 0 || n2 > memReg.out - n4) {
            throw new StringIndexOutOfBoundsException("" + n2);
        }
        return this.data[n4 + n2];
    }

    @Override
    public final int length() {
        return this.wEnd - this.wOffset;
    }

    @Override
    public final int start() {
        return this.wOffset - this.offset;
    }

    @Override
    public final int end() {
        return this.wEnd - this.offset;
    }

    @Override
    public String prefix() {
        return this.getString(this.offset, this.wOffset);
    }

    @Override
    public String suffix() {
        return this.getString(this.wEnd, this.end);
    }

    @Override
    public int groupCount() {
        return this.memregs.length;
    }

    @Override
    public String group(int n2) {
        MemReg memReg = this.bounds(n2);
        if (memReg == null) {
            return null;
        }
        return this.getString(memReg.in, memReg.out);
    }

    @Override
    public String group(String string) {
        Integer n2 = this.re.groupId(string);
        if (n2 == null) {
            throw new IllegalArgumentException("<" + string + "> isn't defined");
        }
        return this.group(n2);
    }

    @Override
    public boolean getGroup(int n2, TextBuffer textBuffer) {
        MemReg memReg = this.bounds(n2);
        if (memReg == null) {
            return false;
        }
        int n3 = memReg.in;
        textBuffer.append(this.data, n3, memReg.out - n3);
        return true;
    }

    @Override
    public boolean getGroup(String string, TextBuffer textBuffer) {
        Integer n2 = this.re.groupId(string);
        if (n2 == null) {
            throw new IllegalArgumentException("unknown group: \"" + string + "\"");
        }
        return this.getGroup((int)n2, textBuffer);
    }

    @Override
    public boolean getGroup(int n2, StringBuffer stringBuffer) {
        MemReg memReg = this.bounds(n2);
        if (memReg == null) {
            return false;
        }
        int n3 = memReg.in;
        stringBuffer.append(this.data, n3, memReg.out - n3);
        return true;
    }

    @Override
    public boolean getGroup(String string, StringBuffer stringBuffer) {
        Integer n2 = this.re.groupId(string);
        if (n2 == null) {
            throw new IllegalArgumentException("unknown group: \"" + string + "\"");
        }
        return this.getGroup((int)n2, stringBuffer);
    }

    public String[] groups() {
        MemReg[] memRegArray = this.memregs;
        String[] stringArray = new String[memRegArray.length];
        for (int i2 = 0; i2 < memRegArray.length; ++i2) {
            MemReg memReg = memRegArray[i2];
            int n2 = memReg.in;
            int n3 = memReg.out;
            n2 = memReg.in;
            if (n2 < 0 || memReg.out < n2) continue;
            stringArray[i2] = this.getString(n2, n3);
        }
        return stringArray;
    }

    public Vector groupv() {
        MemReg[] memRegArray = this.memregs;
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 < memRegArray.length; ++i2) {
            MemReg memReg = this.bounds(i2);
            if (memReg == null) {
                vector.addElement("empty");
                continue;
            }
            String string = this.getString(memReg.in, memReg.out);
            vector.addElement(string);
        }
        return vector;
    }

    private final MemReg bounds(int n2) {
        MemReg memReg;
        if (n2 >= 0) {
            memReg = this.memregs[n2];
        } else {
            switch (n2) {
                case -1: {
                    memReg = this.prefixBounds;
                    if (memReg == null) {
                        this.prefixBounds = memReg = new MemReg(-1);
                    }
                    memReg.in = this.offset;
                    memReg.out = this.wOffset;
                    break;
                }
                case -2: {
                    memReg = this.suffixBounds;
                    if (memReg == null) {
                        this.suffixBounds = memReg = new MemReg(-2);
                    }
                    memReg.in = this.wEnd;
                    memReg.out = this.end;
                    break;
                }
                case -3: {
                    memReg = this.targetBounds;
                    if (memReg == null) {
                        this.targetBounds = memReg = new MemReg(-3);
                    }
                    memReg.in = this.offset;
                    memReg.out = this.end;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal group id: " + n2 + "; must either nonnegative int, or MatchResult.PREFIX, or MatchResult.SUFFIX");
                }
            }
        }
        int n3 = memReg.in;
        if (n3 < 0 || memReg.out < n3) {
            return null;
        }
        return memReg;
    }

    @Override
    public final boolean isCaptured() {
        return this.wOffset >= 0 && this.wEnd >= this.wOffset;
    }

    @Override
    public final boolean isCaptured(int n2) {
        return this.bounds(n2) != null;
    }

    @Override
    public final boolean isCaptured(String string) {
        Integer n2 = this.re.groupId(string);
        if (n2 == null) {
            throw new IllegalArgumentException("unknown group: \"" + string + "\"");
        }
        return this.isCaptured(n2);
    }

    @Override
    public final int length(int n2) {
        MemReg memReg = this.bounds(n2);
        return memReg.out - memReg.in;
    }

    @Override
    public final int start(int n2) {
        return this.bounds((int)n2).in - this.offset;
    }

    @Override
    public final int end(int n2) {
        return this.bounds((int)n2).out - this.offset;
    }

    private final boolean search(int n2) {
        int n3;
        Term term;
        this.called = true;
        int n4 = this.end;
        int n5 = this.offset;
        char[] cArray = this.data;
        int n6 = this.wOffset;
        int n7 = this.wEnd;
        MemReg[] memRegArray = this.memregs;
        int[] nArray = this.counters;
        LAEntry[] lAEntryArray = this.lookaheads;
        int n8 = this.memregCount;
        int n9 = this.counterCount;
        SearchEntry searchEntry = this.defaultEntry;
        SearchEntry searchEntry2 = this.first;
        SearchEntry searchEntry3 = this.top;
        SearchEntry searchEntry4 = null;
        boolean bl2 = (n2 & 4) > 0;
        boolean bl3 = (n2 & 8) > 0;
        Pattern pattern = this.re;
        Term term2 = pattern.root;
        if (searchEntry3 == null) {
            if ((n2 & 1) > 0) {
                term = pattern.root0;
                term2 = startAnchor;
            } else if ((n2 & 2) > 0) {
                term = pattern.root0;
                term2 = lastMatchAnchor;
            } else {
                term = term2;
            }
            n3 = n6;
            searchEntry4 = searchEntry2;
            SearchEntry.popState(searchEntry, memRegArray, nArray);
        } else {
            searchEntry4 = searchEntry3;
            searchEntry3 = searchEntry4.sub;
            term = searchEntry4.term;
            n3 = searchEntry4.index;
            SearchEntry.popState(searchEntry4, memRegArray, nArray);
        }
        int n10 = searchEntry4.cnt;
        int n11 = searchEntry4.regLen;
        block56: while (n6 <= n4) {
            block57: while (true) {
                switch (term.type) {
                    case 8: {
                        int n12 = Matcher.find(cArray, n3 + term.distance, n4, term.target);
                        if (n12 < 0) break block56;
                        n6 = n3 += n12;
                        if (term.eat) {
                            if (n3 == n4) break;
                            ++n3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 9: {
                        MemReg memReg = memRegArray[term.target.memreg];
                        int n13 = memReg.in;
                        int n14 = memReg.out - n13;
                        if (n13 < 0 || n14 < 0) break;
                        if (n14 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        int n15 = Matcher.findReg(cArray, n3 + term.distance, n13, n14, term.target, n4);
                        if (n15 < 0) break block56;
                        n6 = n3 += n15;
                        if (term.eat && (n3 += n14) > n4) break;
                        term = term.next;
                        continue block57;
                    }
                    case 17: {
                        term = term.next;
                        continue block57;
                    }
                    case 0: {
                        if (n3 >= n4 || cArray[n3] != term.c) break;
                        ++n3;
                        term = term.next;
                        continue block57;
                    }
                    case 4: {
                        if (n3 >= n4) break;
                        ++n3;
                        term = term.next;
                        continue block57;
                    }
                    case 5: {
                        char c2;
                        if (n3 >= n4 || (c2 = cArray[n3]) == '\r' || c2 == '\n') break;
                        ++n3;
                        term = term.next;
                        continue block57;
                    }
                    case 19: {
                        if (n3 < n4) break;
                        term = term.next;
                        continue block57;
                    }
                    case 20: {
                        if (n3 >= n4) {
                            term = term.next;
                            continue block57;
                        }
                        boolean bl4 = n3 >= n4 | (n3 + 1 == n4 && cArray[n3] == '\n') | (n3 + 2 == n4 && cArray[n3] == '\r' && cArray[n3 + 1] == '\n');
                        if (!bl4) break;
                        term = term.next;
                        continue block57;
                    }
                    case 22: {
                        if (n3 >= n4) {
                            term = term.next;
                            continue block57;
                        }
                        char c2 = cArray[n3];
                        if (c2 != '\r' && c2 != '\n') break;
                        term = term.next;
                        continue block57;
                    }
                    case 18: {
                        if (n3 == n5) {
                            term = term.next;
                            continue block57;
                        }
                        if (searchEntry3 == null && term == startAnchor) break block56;
                        break;
                    }
                    case 23: {
                        if (n3 != n7) break block56;
                        term = term.next;
                        continue block57;
                    }
                    case 21: {
                        char c2;
                        if (n3 == n5) {
                            term = term.next;
                            continue block57;
                        }
                        if (n3 >= n4 || (c2 = cArray[n3 - 1]) != '\n' && (c2 != '\r' || cArray[n3] == '\n')) break;
                        term = term.next;
                        continue block57;
                    }
                    case 1: {
                        char c2;
                        if (n3 >= n4 || ((c2 = cArray[n3]) > '\u00ff' || !term.bitset[c2]) ^ term.inverse) break;
                        ++n3;
                        term = term.next;
                        continue block57;
                    }
                    case 2: {
                        boolean[] blArray;
                        char c2;
                        if (n3 >= n4 || (blArray = term.bitset2[(c2 = cArray[n3]) >> 8]) == null || !blArray[c2 & 0xFF] ^ term.inverse) break;
                        ++n3;
                        term = term.next;
                        continue block57;
                    }
                    case 11: {
                        char c2;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        boolean[] blArray = term.bitset;
                        int n16 = n3 - 1;
                        if (n16 >= n5) {
                            c2 = cArray[n16];
                            boolean bl7 = bl5 = c2 < '\u0100' && blArray[c2];
                        }
                        if (n3 < n4) {
                            c2 = cArray[n3];
                            boolean bl8 = bl6 = c2 < '\u0100' && blArray[c2];
                        }
                        if (!(bl5 ^ bl6 ^ term.inverse)) break;
                        term = term.next;
                        continue block57;
                    }
                    case 13: {
                        char c2;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        boolean[][] blArray = term.bitset2;
                        int n17 = n3 - 1;
                        if (n17 >= n5) {
                            c2 = cArray[n17];
                            boolean[] blArray2 = blArray[c2 >> 8];
                            boolean bl11 = bl9 = blArray2 != null && blArray2[c2 & 0xFF];
                        }
                        if (n3 < n4) {
                            c2 = cArray[n3];
                            boolean[] blArray3 = blArray[c2 >> 8];
                            boolean bl12 = bl10 = blArray3 != null && blArray3[c2 & 0xFF];
                        }
                        if (!(bl9 ^ bl10 ^ term.inverse)) break;
                        term = term.next;
                        continue block57;
                    }
                    case 12: {
                        char c2;
                        boolean bl13 = false;
                        boolean bl14 = false;
                        boolean[] blArray = term.bitset;
                        boolean bl15 = term.inverse;
                        int n18 = n3 - 1;
                        if (n18 >= n5) {
                            c2 = cArray[n18];
                            boolean bl16 = bl13 = c2 < '\u0100' && blArray[c2];
                        }
                        if (bl13 ^ bl15) break;
                        if (n3 < n4) {
                            c2 = cArray[n3];
                            bl14 = c2 < '\u0100' && blArray[c2];
                        }
                        if (!bl14 ^ bl15) break;
                        term = term.next;
                        continue block57;
                    }
                    case 14: {
                        boolean[] blArray;
                        char c2;
                        boolean bl17 = false;
                        boolean bl18 = false;
                        boolean[][] blArray4 = term.bitset2;
                        boolean bl19 = term.inverse;
                        int n19 = n3 - 1;
                        if (n19 >= n5) {
                            c2 = cArray[n19];
                            blArray = blArray4[c2 >> 8];
                            boolean bl20 = bl17 = blArray != null && blArray[c2 & 0xFF];
                        }
                        if (bl17 ^ bl19) break;
                        if (n3 < n4) {
                            c2 = cArray[n3];
                            blArray = blArray4[c2 >> 8];
                            bl18 = blArray != null && blArray[c2 & 0xFF];
                        }
                        if (!bl18 ^ bl19) break;
                        term = term.next;
                        continue block57;
                    }
                    case 6: {
                        int n20;
                        MemReg memReg = memRegArray[term.memreg];
                        int n21 = memReg.in;
                        int n22 = memReg.out;
                        if (n21 < 0 || (n20 = n22 - n21) < 0) break;
                        if (n20 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        if (n3 + n20 > n4 || !Matcher.compareRegions(cArray, n21, n3, n20, n4)) break;
                        n3 += n20;
                        term = term.next;
                        continue block57;
                    }
                    case 7: {
                        int n23;
                        MemReg memReg = memRegArray[term.memreg];
                        int n24 = memReg.in;
                        int n25 = memReg.out;
                        if (n24 < 0 || (n23 = n25 - n24) < 0) break;
                        if (n23 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        if (n3 + n23 > n4 || !Matcher.compareRegionsI(cArray, n24, n3, n23, n4)) break;
                        n3 += n23;
                        term = term.next;
                        continue block57;
                    }
                    case 45: {
                        n10 = Matcher.repeat(cArray, n3, n4, term.target);
                        if (n10 <= 0) {
                            term = term.next;
                            continue block57;
                        }
                        searchEntry4.cnt = n10;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3 += n10;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 46: {
                        n10 = Matcher.repeat(cArray, n3, n4, term.target);
                        if (n10 < term.minCount) break;
                        searchEntry4.cnt = n10;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3 += n10;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 47: {
                        int n26 = n4;
                        int n27 = n3 + term.maxCount;
                        n10 = Matcher.repeat(cArray, n3, n26 < n27 ? n26 : n27, term.target);
                        if (n10 < term.minCount) break;
                        searchEntry4.cnt = n10;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3 += n10;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 48: {
                        int n28;
                        MemReg memReg = memRegArray[term.memreg];
                        int n29 = memReg.in;
                        int n30 = memReg.out;
                        if (n29 < 0 || (n28 = n30 - n29) < 0) break;
                        if (n28 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        n10 = 0;
                        while (Matcher.compareRegions(cArray, n3, n29, n28, n4)) {
                            ++n10;
                            n3 += n28;
                        }
                        if (n10 < term.minCount) break;
                        searchEntry4.cnt = n10;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        searchEntry4.regLen = n28;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 49: {
                        int n31;
                        MemReg memReg = memRegArray[term.memreg];
                        int n32 = memReg.in;
                        int n33 = memReg.out;
                        if (n32 < 0 || (n31 = n33 - n32) < 0) break;
                        if (n31 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        n10 = 0;
                        for (int i2 = term.maxCount; i2 > 0 && Matcher.compareRegions(cArray, n3, n32, n31, n4); --i2) {
                            ++n10;
                            n3 += n31;
                        }
                        if (n10 < term.minCount) break;
                        searchEntry4.cnt = n10;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        searchEntry4.regLen = n31;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 50: {
                        n10 = searchEntry4.cnt;
                        if (n10 <= 0) break;
                        searchEntry4.cnt = --n10;
                        searchEntry4.index = --n3;
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 51: {
                        n10 = searchEntry4.cnt;
                        if (n10 <= term.minCount) break;
                        searchEntry4.cnt = --n10;
                        searchEntry4.index = --n3;
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 52: {
                        int n34;
                        n10 = searchEntry4.cnt;
                        int n35 = term.minCount;
                        if (n10 <= n35) break;
                        int n36 = n3 + term.distance;
                        if (n36 > n4) {
                            int n37 = n36 - n4;
                            if ((n10 -= n37) <= n35) break;
                            n3 -= n37;
                            n36 = n4;
                        }
                        if ((n34 = Matcher.findBack(cArray, n3 + term.distance, n10 - n35, term.target)) < 0) break;
                        if ((n10 -= n34) <= n35) {
                            n3 -= n34;
                            if (term.eat) {
                                ++n3;
                            }
                            term = term.next;
                            continue block57;
                        }
                        n3 -= n34;
                        searchEntry4.cnt = n10;
                        searchEntry4.index = n3++;
                        if (term.eat) {
                            // empty if block
                        }
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 53: {
                        int n38;
                        n10 = searchEntry4.cnt;
                        int n39 = term.minCount;
                        if (n10 <= n39) break;
                        int n40 = n3 + term.distance;
                        if (n40 > n4) {
                            int n41 = n40 - n4;
                            if ((n10 -= n41) <= n39) break;
                            n3 -= n41;
                            n40 = n4;
                        }
                        MemReg memReg = memRegArray[term.target.memreg];
                        int n42 = memReg.in;
                        int n43 = memReg.out - n42;
                        if (n42 < 0 || n43 < 0) {
                            searchEntry4.cnt = --n10;
                            searchEntry4.index = --n3;
                            searchEntry4.term = term;
                            searchEntry3 = searchEntry4;
                            searchEntry4 = searchEntry3.on;
                            if (searchEntry4 == null) {
                                searchEntry3.on = searchEntry4 = new SearchEntry();
                                searchEntry4.sub = searchEntry3;
                            }
                            term = term.next;
                            continue block57;
                        }
                        if (n43 == 0) {
                            n38 = -1;
                        } else {
                            n38 = Matcher.findBackReg(cArray, n3 + term.distance, n42, n43, n10 - n39, term.target, n4);
                            if (n38 < 0) break;
                        }
                        searchEntry4.cnt = n10 -= n38;
                        searchEntry4.index = n3 -= n38;
                        if (term.eat) {
                            n3 += n43;
                        }
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 54: {
                        n10 = searchEntry4.cnt;
                        if (n10 <= term.minCount) break;
                        n11 = searchEntry4.regLen;
                        searchEntry4.cnt = --n10;
                        searchEntry4.index = n3 -= n11;
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 15: {
                        int n44 = term.memreg;
                        if (n44 > 0) {
                            memRegArray[n44].tmp = n3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 16: {
                        int n44 = term.memreg;
                        if (n44 > 0) {
                            MemReg memReg = memRegArray[n44];
                            SearchEntry.saveMemregState(searchEntry3 != null ? searchEntry3 : searchEntry, n44, memReg);
                            memReg.in = memReg.tmp;
                            memReg.out = n3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 39: {
                        int n45 = n3 - term.distance;
                        if (n45 < n5) break;
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n3;
                        n3 = n45;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        term = term.next;
                        continue block57;
                    }
                    case 35: 
                    case 43: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n3;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        term = term.next;
                        continue block57;
                    }
                    case 36: 
                    case 40: 
                    case 57: 
                    case 59: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        n3 = lAEntry.index;
                        searchEntry4 = lAEntry.actual;
                        searchEntry3 = lAEntry.top;
                        term = term.next;
                        continue block57;
                    }
                    case 44: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        searchEntry4 = lAEntry.actual;
                        searchEntry3 = lAEntry.top;
                        term = term.next;
                        continue block57;
                    }
                    case 41: {
                        int n46 = n3 - term.distance;
                        if (n46 < n5) {
                            term = term.failNext;
                            continue block57;
                        }
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        n3 = n46;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 37: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 38: 
                    case 42: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        searchEntry4 = lAEntry.actual;
                        searchEntry3 = lAEntry.top;
                        break;
                    }
                    case 58: {
                        int n47 = n3 - term.distance;
                        if (n47 < n5) {
                            term = term.failNext;
                            continue block57;
                        }
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n3;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        n3 = n47;
                        term = term.next;
                        continue block57;
                    }
                    case 56: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n3;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 55: {
                        MemReg memReg = memRegArray[term.memreg];
                        int n48 = memReg.in;
                        int n49 = memReg.out;
                        if (n48 >= 0 && n49 >= 0 && n49 >= n48) {
                            term = term.next;
                            continue block57;
                        }
                        term = term.failNext;
                        continue block57;
                    }
                    case 34: {
                        searchEntry4.regLen = n11;
                    }
                    case 33: {
                        searchEntry4.cnt = n10;
                    }
                    case 32: {
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n3;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 10: {
                        if (bl2 && n3 != n4) break;
                        this.wOffset = memRegArray[0].in = n6;
                        this.wEnd = memRegArray[0].out = n3;
                        this.top = searchEntry3;
                        return true;
                    }
                    case 24: {
                        n10 = 0;
                        term = term.next;
                        continue block57;
                    }
                    case 25: {
                        ++n10;
                        term = term.next;
                        continue block57;
                    }
                    case 26: {
                        if (n10 < term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 27: {
                        n10 = searchEntry4.cnt;
                        if (n10 >= term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 28: {
                        int n50 = term.cntreg;
                        int n51 = nArray[n50];
                        SearchEntry.saveCntState(searchEntry3 != null ? searchEntry3 : searchEntry, n50, n51);
                        nArray[n50] = ++n51;
                        term = term.next;
                        continue block57;
                    }
                    case 29: {
                        nArray[term.cntreg] = 0;
                        term = term.next;
                        continue block57;
                    }
                    case 30: {
                        if (nArray[term.cntreg] >= term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 31: {
                        if (nArray[term.cntreg] < term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    default: {
                        throw new Error("unknown term type: " + term.type);
                    }
                }
                if (bl3 && n3 == n4) {
                    return true;
                }
                if (searchEntry3 == null) break;
                searchEntry4 = searchEntry3;
                searchEntry3 = searchEntry4.sub;
                term = searchEntry4.term;
                n3 = searchEntry4.index;
                if (!searchEntry4.isState) continue;
                SearchEntry.popState(searchEntry4, memRegArray, nArray);
            }
            if (searchEntry.isState) {
                SearchEntry.popState(searchEntry, memRegArray, nArray);
            }
            term = term2;
            n3 = ++n6;
        }
        this.wOffset = n6;
        this.top = searchEntry3;
        return false;
    }

    private static final boolean compareRegions(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6 = n2 + n4 - 1;
        int n7 = n3 + n4 - 1;
        if (n6 >= n5 || n7 >= n5) {
            return false;
        }
        int n8 = n4;
        while (n8 > 0) {
            if (cArray[n6] != cArray[n7]) {
                return false;
            }
            --n8;
            --n6;
            --n7;
        }
        return true;
    }

    private static final boolean compareRegionsI(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6 = n2 + n4 - 1;
        int n7 = n3 + n4 - 1;
        if (n6 >= n5 || n7 >= n5) {
            return false;
        }
        int n8 = n4;
        while (n8 > 0) {
            char c2 = cArray[n6];
            char c3 = cArray[n7];
            if (c2 != Character.toLowerCase(c3) && c2 != Character.toUpperCase(c3) && c2 != Character.toTitleCase(c3)) {
                return false;
            }
            --n8;
            --n6;
            --n7;
        }
        return true;
    }

    private static final int repeat(char[] cArray, int n2, int n3, Term term) {
        switch (term.type) {
            case 0: {
                int n4;
                char c2 = term.c;
                for (n4 = n2; n4 < n3 && cArray[n4] == c2; ++n4) {
                }
                return n4 - n2;
            }
            case 4: {
                return n3 - n2;
            }
            case 5: {
                char c3;
                int n5;
                for (n5 = n2; n5 < n3 && (c3 = cArray[n5]) != '\r' && c3 != '\n'; ++n5) {
                }
                return n5 - n2;
            }
            case 1: {
                int n6;
                boolean[] blArray = term.bitset;
                if (term.inverse) {
                    char c4;
                    for (n6 = n2; !(n6 >= n3 || (c4 = cArray[n6]) <= '\u00ff' && blArray[c4]); ++n6) {
                    }
                } else {
                    char c5;
                    while (n6 < n3 && (c5 = cArray[n6]) <= '\u00ff' && blArray[c5]) {
                        ++n6;
                    }
                }
                return n6 - n2;
            }
            case 2: {
                int n7;
                boolean[][] blArray = term.bitset2;
                if (term.inverse) {
                    char c6;
                    boolean[] blArray2;
                    for (n7 = n2; !(n7 >= n3 || (blArray2 = blArray[(c6 = cArray[n7]) >> 8]) != null && blArray2[c6 & 0xFF]); ++n7) {
                    }
                } else {
                    char c7;
                    boolean[] blArray3;
                    while (n7 < n3 && (blArray3 = blArray[(c7 = cArray[n7]) >> 8]) != null && blArray3[c7 & 0xFF]) {
                        ++n7;
                    }
                }
                return n7 - n2;
            }
        }
        throw new Error("this kind of term can't be quantified:" + term.type);
    }

    private static final int find(char[] cArray, int n2, int n3, Term term) {
        if (n2 >= n3) {
            return -1;
        }
        switch (term.type) {
            case 0: {
                int n4;
                char c2 = term.c;
                for (n4 = n2; n4 < n3 && cArray[n4] != c2; ++n4) {
                }
                return n4 - n2;
            }
            case 1: {
                int n5;
                boolean[] blArray = term.bitset;
                if (!term.inverse) {
                    char c3;
                    for (n5 = n2; !(n5 >= n3 || (c3 = cArray[n5]) <= '\u00ff' && blArray[c3]); ++n5) {
                    }
                } else {
                    char c4;
                    while (n5 < n3 && (c4 = cArray[n5]) <= '\u00ff' && blArray[c4]) {
                        ++n5;
                    }
                }
                return n5 - n2;
            }
            case 2: {
                int n6;
                boolean[][] blArray = term.bitset2;
                if (!term.inverse) {
                    char c5;
                    boolean[] blArray2;
                    for (n6 = n2; !(n6 >= n3 || (blArray2 = blArray[(c5 = cArray[n6]) >> 8]) != null && blArray2[c5 & 0xFF]); ++n6) {
                    }
                } else {
                    char c6;
                    boolean[] blArray3;
                    while (n6 < n3 && (blArray3 = blArray[(c6 = cArray[n6]) >> 8]) != null && blArray3[c6 & 0xFF]) {
                        ++n6;
                    }
                }
                return n6 - n2;
            }
        }
        throw new IllegalArgumentException("can't seek this kind of term:" + term.type);
    }

    private static final int findReg(char[] cArray, int n2, int n3, int n4, Term term, int n5) {
        int n6;
        if (n2 >= n5) {
            return -1;
        }
        if (term.type == 6) {
            for (n6 = n2; n6 < n5 && !Matcher.compareRegions(cArray, n6, n3, n4, n5); ++n6) {
            }
        } else if (term.type == 7) {
            while (n6 < n5 && !Matcher.compareRegionsI(cArray, n6, n3, n4, n5)) {
                ++n6;
            }
        } else {
            throw new IllegalArgumentException("wrong findReg() target:" + term.type);
        }
        return n2 - n6;
    }

    private static final int findBack(char[] cArray, int n2, int n3, Term term) {
        switch (term.type) {
            case 0: {
                char c2 = term.c;
                int n4 = n2;
                int n5 = n2 - n3;
                while (cArray[--n4] != c2) {
                    if (n4 > n5) continue;
                    return -1;
                }
                return n2 - n4;
            }
            case 1: {
                boolean[] blArray = term.bitset;
                int n6 = n2;
                int n7 = n2 - n3;
                if (!term.inverse) {
                    char c3;
                    while ((c3 = cArray[--n6]) > '\u00ff' || !blArray[c3]) {
                        if (n6 > n7) continue;
                        return -1;
                    }
                } else {
                    char c4;
                    while ((c4 = cArray[--n6]) <= '\u00ff' && blArray[c4]) {
                        if (n6 > n7) continue;
                        return -1;
                    }
                }
                return n2 - n6;
            }
            case 2: {
                boolean[][] blArray = term.bitset2;
                int n8 = n2;
                int n9 = n2 - n3;
                if (!term.inverse) {
                    char c5;
                    boolean[] blArray2;
                    while ((blArray2 = blArray[(c5 = cArray[--n8]) >> 8]) == null || !blArray2[c5 & 0xFF]) {
                        if (n8 > n9) continue;
                        return -1;
                    }
                } else {
                    char c6;
                    boolean[] blArray3;
                    while ((blArray3 = blArray[(c6 = cArray[--n8]) >> 8]) != null && !blArray3[c6 & 0xFF]) {
                        if (n8 > n9) continue;
                        return -1;
                    }
                }
                return n2 - n8;
            }
        }
        throw new IllegalArgumentException("can't find this kind of term:" + term.type);
    }

    private static final int findBackReg(char[] cArray, int n2, int n3, int n4, int n5, Term term, int n6) {
        int n7 = n2;
        int n8 = n2 - n5;
        if (term.type == 6) {
            char c2 = cArray[n3];
            ++n3;
            --n4;
            while (cArray[--n7] != c2 || !Matcher.compareRegions(cArray, n7 + 1, n3, n4, n6)) {
                if (n7 > n8) continue;
                return -1;
            }
        } else {
            if (term.type == 7) {
                char c3 = cArray[n3];
                char c4 = Character.toLowerCase(c3);
                char c5 = Character.toUpperCase(c3);
                char c6 = Character.toTitleCase(c3);
                ++n3;
                --n4;
                while ((c3 = cArray[--n7]) != c4 && c3 != c5 && c3 != c6 || !Matcher.compareRegionsI(cArray, n7 + 1, n3, n4, n6)) {
                    if (n7 > n8) continue;
                    return -1;
                }
                return n2 - n7;
            }
            throw new IllegalArgumentException("wrong findBackReg() target type :" + term.type);
        }
        return n2 - n7;
    }

    public String toString_d() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("counters: ");
        stringBuffer.append(this.counters == null ? 0 : this.counters.length);
        stringBuffer.append("\r\nmemregs: ");
        stringBuffer.append(this.memregs.length);
        for (int i2 = 0; i2 < this.memregs.length; ++i2) {
            stringBuffer.append("\r\n #" + i2 + ": [" + this.memregs[i2].in + "," + this.memregs[i2].out + "](\"" + this.getString(this.memregs[i2].in, this.memregs[i2].out) + "\")");
        }
        stringBuffer.append("\r\ndata: ");
        if (this.data != null) {
            stringBuffer.append(this.data.length);
        } else {
            stringBuffer.append("[none]");
        }
        stringBuffer.append("\r\noffset: ");
        stringBuffer.append(this.offset);
        stringBuffer.append("\r\nend: ");
        stringBuffer.append(this.end);
        stringBuffer.append("\r\nwOffset: ");
        stringBuffer.append(this.wOffset);
        stringBuffer.append("\r\nwEnd: ");
        stringBuffer.append(this.wEnd);
        stringBuffer.append("\r\nregex: ");
        stringBuffer.append(this.re);
        return stringBuffer.toString();
    }
}

