/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.AbstractHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.Base64Helper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public class Histogram
extends AbstractHistogram {
    long totalCount;
    long[] counts;
    int normalizingIndexOffset;

    @Override
    long getCountAtIndex(int n2) {
        return this.counts[this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength)];
    }

    @Override
    long getCountAtNormalizedIndex(int n2) {
        return this.counts[n2];
    }

    @Override
    void incrementCountAtIndex(int n2) {
        int n3 = this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength);
        this.counts[n3] = this.counts[n3] + 1L;
    }

    @Override
    void addToCountAtIndex(int n2, long l2) {
        int n3 = this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength);
        this.counts[n3] = this.counts[n3] + l2;
    }

    @Override
    void setCountAtIndex(int n2, long l2) {
        this.counts[this.normalizeIndex((int)n2, (int)this.normalizingIndexOffset, (int)this.countsArrayLength)] = l2;
    }

    @Override
    void setCountAtNormalizedIndex(int n2, long l2) {
        this.counts[n2] = l2;
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.normalizingIndexOffset;
    }

    @Override
    void setNormalizingIndexOffset(int n2) {
        this.normalizingIndexOffset = n2;
    }

    @Override
    void setIntegerToDoubleValueConversionRatio(double d2) {
        this.nonConcurrentSetIntegerToDoubleValueConversionRatio(d2);
    }

    @Override
    void shiftNormalizingIndexByOffset(int n2, boolean bl2, double d2) {
        this.nonConcurrentNormalizingIndexShift(n2, bl2);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, 0L);
        this.totalCount = 0L;
    }

    @Override
    public Histogram copy() {
        Histogram histogram = new Histogram(this);
        histogram.add(this);
        return histogram;
    }

    @Override
    public Histogram copyCorrectedForCoordinatedOmission(long l2) {
        Histogram histogram = new Histogram(this);
        histogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return histogram;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long l2) {
        this.totalCount = l2;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long l2) {
        this.totalCount += l2;
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length;
    }

    @Override
    void resize(long l2) {
        int n2 = this.normalizeIndex(0, this.normalizingIndexOffset, this.countsArrayLength);
        this.establishSize(l2);
        int n3 = this.countsArrayLength - this.counts.length;
        this.counts = Arrays.copyOf(this.counts, this.countsArrayLength);
        if (n2 != 0) {
            int n4 = n2 + n3;
            int n5 = this.countsArrayLength - n3 - n2;
            System.arraycopy(this.counts, n2, this.counts, n4, n5);
            Arrays.fill(this.counts, n2, n4, 0L);
        }
    }

    public Histogram(int n2) {
        this(1L, 2L, n2);
        this.setAutoResize(true);
    }

    public Histogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public Histogram(long l2, long l3, int n2) {
        this(l2, l3, n2, true);
    }

    public Histogram(AbstractHistogram abstractHistogram) {
        this(abstractHistogram, true);
    }

    Histogram(AbstractHistogram abstractHistogram, boolean bl2) {
        super(abstractHistogram);
        if (bl2) {
            this.counts = new long[this.countsArrayLength];
        }
        this.wordSizeInBytes = 8;
    }

    Histogram(long l2, long l3, int n2, boolean bl2) {
        super(l2, l3, n2);
        if (bl2) {
            this.counts = new long[this.countsArrayLength];
        }
        this.wordSizeInBytes = 8;
    }

    public static Histogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return Histogram.decodeFromByteBuffer(byteBuffer, Histogram.class, l2);
    }

    public static Histogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return Histogram.decodeFromCompressedByteBuffer(byteBuffer, Histogram.class, l2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public static Histogram fromString(String string) throws DataFormatException {
        return Histogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }
}

