/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.input;

import java.io.Reader;
import java.io.Serializable;

public class CharSequenceReader
extends Reader
implements Serializable {
    private static final long serialVersionUID = 3724187752191401220L;
    private final CharSequence charSequence;
    private int idx;
    private int mark;

    public CharSequenceReader(CharSequence charSequence) {
        this.charSequence = charSequence != null ? charSequence : "";
    }

    @Override
    public void close() {
        this.idx = 0;
        this.mark = 0;
    }

    @Override
    public void mark(int n2) {
        this.mark = this.idx;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.idx >= this.charSequence.length()) {
            return -1;
        }
        return this.charSequence.charAt(this.idx++);
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.idx >= this.charSequence.length()) {
            return -1;
        }
        if (cArray == null) {
            throw new NullPointerException("Character array is missing");
        }
        if (n3 < 0 || n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = this.read();
            if (n5 == -1) {
                return n4;
            }
            cArray[n2 + i2] = (char)n5;
            ++n4;
        }
        return n4;
    }

    @Override
    public void reset() {
        this.idx = this.mark;
    }

    @Override
    public long skip(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + l2);
        }
        if (this.idx >= this.charSequence.length()) {
            return -1L;
        }
        int n2 = (int)Math.min((long)this.charSequence.length(), (long)this.idx + l2);
        int n3 = n2 - this.idx;
        this.idx = n2;
        return n3;
    }

    public String toString() {
        return this.charSequence.toString();
    }
}

