/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent.Computable;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent.FutureTasks;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.exception.ExceptionUtils;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;

public class Memoizer<I, O>
implements Computable<I, O> {
    private final ConcurrentMap<I, Future<O>> cache = new ConcurrentHashMap<I, Future<O>>();
    private final Function<? super I, ? extends Future<O>> mappingFunction;
    private final boolean recalculate;

    public Memoizer(Computable<I, O> computable) {
        this(computable, false);
    }

    public Memoizer(Computable<I, O> computable, boolean bl2) {
        this.recalculate = bl2;
        this.mappingFunction = object -> FutureTasks.run(() -> computable.compute(object));
    }

    public Memoizer(Function<I, O> function) {
        this(function, false);
    }

    public Memoizer(Function<I, O> function, boolean bl2) {
        this.recalculate = bl2;
        this.mappingFunction = object -> FutureTasks.run(() -> function.apply(object));
    }

    @Override
    public O compute(I i2) throws InterruptedException {
        while (true) {
            Future<O> future = this.cache.computeIfAbsent(i2, this.mappingFunction);
            try {
                return future.get();
            }
            catch (CancellationException cancellationException) {
                this.cache.remove(i2, future);
                continue;
            }
            catch (ExecutionException executionException) {
                if (this.recalculate) {
                    this.cache.remove(i2, future);
                }
                throw this.launderException(executionException.getCause());
            }
            break;
        }
    }

    private RuntimeException launderException(Throwable throwable) {
        throw new IllegalStateException("Unchecked exception", ExceptionUtils.throwUnchecked(throwable));
    }
}

