/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.io;

import com.contrastsecurity.thirdparty.org.apache.http.ConnectionClosedException;
import com.contrastsecurity.thirdparty.org.apache.http.io.BufferInfo;
import com.contrastsecurity.thirdparty.org.apache.http.io.SessionInputBuffer;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;

public class ContentLengthInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 2048;
    private final long contentLength;
    private long pos = 0L;
    private boolean closed = false;
    private SessionInputBuffer in = null;

    public ContentLengthInputStream(SessionInputBuffer sessionInputBuffer, long l2) {
        this.in = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.contentLength = Args.notNegative(l2, "Content length");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.pos < this.contentLength) {
                    byte[] byArray = new byte[2048];
                    while (this.read(byArray) >= 0) {
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            int n2 = ((BufferInfo)((Object)this.in)).length();
            return Math.min(n2, (int)(this.contentLength - this.pos));
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            if (this.pos < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: %,d; received: %,d)", this.contentLength, this.pos);
            }
        } else {
            ++this.pos;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        int n5 = n3;
        if (this.pos + (long)n3 > this.contentLength) {
            n5 = (int)(this.contentLength - this.pos);
        }
        if ((n4 = this.in.read(byArray, n2, n5)) == -1 && this.pos < this.contentLength) {
            throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: %,d; received: %,d)", this.contentLength, this.pos);
        }
        if (n4 > 0) {
            this.pos += (long)n4;
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2;
        if (l2 <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[2048];
        long l3 = 0L;
        for (long i2 = Math.min(l2, this.contentLength - this.pos); i2 > 0L && (n2 = this.read(byArray, 0, (int)Math.min(2048L, i2))) != -1; i2 -= (long)n2) {
            l3 += (long)n2;
        }
        return l3;
    }
}

