/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.jdbc;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.StringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.ColumnMapping;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.DbAppenderLoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.convert.DateTypeConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Closer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThread;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.MapMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ThreadContextMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ThreadContextStack;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.ReadOnlyStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public final class JdbcDatabaseManager
extends AbstractDatabaseManager {
    private static final JdbcDatabaseManagerFactory INSTANCE = new JdbcDatabaseManagerFactory();
    private final List<ColumnConfig> columnConfigs;
    private final String sqlStatement;
    private final FactoryData factoryData;
    private volatile Connection connection;
    private volatile PreparedStatement statement;
    private volatile Reconnector reconnector;
    private volatile boolean isBatchSupported;
    private volatile Map<String, ResultSetColumnMetaData> columnMetaData;

    private static void appendColumnName(int n2, String string, StringBuilder stringBuilder) {
        if (n2 > 1) {
            stringBuilder.append(',');
        }
        stringBuilder.append(string);
    }

    private static void appendColumnNames(String string, FactoryData factoryData, StringBuilder stringBuilder) {
        String string2;
        int n2 = 1;
        String string3 = "Appending {} {}[{}]: {}={} ";
        if (factoryData.columnMappings != null) {
            for (ColumnMapping object : factoryData.columnMappings) {
                string2 = object.getName();
                JdbcDatabaseManager.appendColumnName(n2, string2, stringBuilder);
                JdbcDatabaseManager.logger().trace("Appending {} {}[{}]: {}={} ", (Object)string, (Object)object.getClass().getSimpleName(), (Object)n2, (Object)string2, (Object)object);
                ++n2;
            }
        }
        if (factoryData.columnConfigs != null) {
            for (ColumnConfig columnConfig : factoryData.columnConfigs) {
                string2 = columnConfig.getColumnName();
                JdbcDatabaseManager.appendColumnName(n2, string2, stringBuilder);
                JdbcDatabaseManager.logger().trace("Appending {} {}[{}]: {}={} ", (Object)string, (Object)columnConfig.getClass().getSimpleName(), (Object)n2, (Object)string2, (Object)columnConfig);
                ++n2;
            }
        }
    }

    private static JdbcDatabaseManagerFactory getFactory() {
        return INSTANCE;
    }

    @Deprecated
    public static JdbcDatabaseManager getJDBCDatabaseManager(String string, int n2, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray) {
        return JdbcDatabaseManager.getManager(string, new FactoryData(n2, null, connectionSource, string2, columnConfigArray, ColumnMapping.EMPTY_ARRAY, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    @Deprecated
    public static JdbcDatabaseManager getManager(String string, int n2, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray) {
        return JdbcDatabaseManager.getManager(string, new FactoryData(n2, layout, connectionSource, string2, columnConfigArray, columnMappingArray, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    @Deprecated
    public static JdbcDatabaseManager getManager(String string, int n2, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray, boolean bl2, long l2) {
        return JdbcDatabaseManager.getManager(string, new FactoryData(n2, null, connectionSource, string2, columnConfigArray, columnMappingArray, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    public static JdbcDatabaseManager getManager(String string, int n2, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray, boolean bl2, long l2, boolean bl3) {
        return JdbcDatabaseManager.getManager(string, new FactoryData(n2, layout, connectionSource, string2, columnConfigArray, columnMappingArray, bl2, l2, bl3), JdbcDatabaseManager.getFactory());
    }

    private JdbcDatabaseManager(String string, String string2, List<ColumnConfig> list, FactoryData factoryData) {
        super(string, factoryData.getBufferSize());
        this.sqlStatement = string2;
        this.columnConfigs = list;
        this.factoryData = factoryData;
    }

    private void checkConnection() {
        boolean bl2 = true;
        try {
            bl2 = this.isClosed(this.connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean bl3 = true;
        try {
            bl3 = this.isClosed(this.statement);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!this.isRunning() || bl2 || bl3) {
            this.closeResources(false);
            if (this.reconnector != null && !this.factoryData.immediateFail) {
                this.reconnector.latch();
                if (this.connection == null) {
                    throw new AppenderLoggingException("Error writing to JDBC Manager '%s': JDBC connection not available [%s]", this.getName(), this.fieldsToString());
                }
                if (this.statement == null) {
                    throw new AppenderLoggingException("Error writing to JDBC Manager '%s': JDBC statement not available [%s].", this.getName(), this.connection, this.fieldsToString());
                }
            }
        }
    }

    protected void closeResources(boolean bl2) {
        block5: {
            Object object;
            block4: {
                PreparedStatement preparedStatement = this.statement;
                this.statement = null;
                try {
                    Closer.close(preparedStatement);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    object = exception;
                    if (!bl2) break block4;
                    this.logWarn("Failed to close SQL statement logging event or flushing buffer", (Throwable)object);
                }
            }
            object = this.connection;
            this.connection = null;
            try {
                Closer.close((AutoCloseable)object);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                if (!bl2) break block5;
                this.logWarn("Failed to close database connection logging event or flushing buffer", exception2);
            }
        }
    }

    @Override
    protected boolean commitAndClose() {
        block8: {
            boolean bl2 = true;
            try {
                if (this.connection == null || this.connection.isClosed()) break block8;
                if (this.isBuffered() && this.isBatchSupported && this.statement != null) {
                    int[] nArray;
                    JdbcDatabaseManager.logger().debug("Executing batch PreparedStatement {}", (Object)this.statement);
                    try {
                        nArray = this.statement.executeBatch();
                    }
                    catch (SQLTransactionRollbackException sQLTransactionRollbackException) {
                        JdbcDatabaseManager.logger().debug("{} executing batch PreparedStatement {}, retrying.", (Object)sQLTransactionRollbackException, (Object)this.statement);
                        nArray = this.statement.executeBatch();
                    }
                    JdbcDatabaseManager.logger().debug("Batch result: {}", (Object)Arrays.toString(nArray));
                }
                JdbcDatabaseManager.logger().debug("Committing Connection {}", (Object)this.connection);
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                throw new DbAppenderLoggingException(sQLException, "Failed to commit transaction logging event or flushing buffer [%s]", this.fieldsToString());
            }
            finally {
                this.closeResources(true);
            }
        }
        return true;
    }

    private boolean commitAndCloseAll() {
        if (this.connection != null || this.statement != null) {
            try {
                this.commitAndClose();
                return true;
            }
            catch (AppenderLoggingException appenderLoggingException) {
                Throwable throwable = appenderLoggingException.getCause();
                Throwable throwable2 = throwable == null ? appenderLoggingException : throwable;
                JdbcDatabaseManager.logger().debug("{} committing and closing connection: {}", (Object)throwable2, (Object)throwable2.getClass().getSimpleName(), (Object)appenderLoggingException.toString(), (Object)appenderLoggingException);
            }
        }
        if (this.factoryData.connectionSource != null) {
            this.factoryData.connectionSource.stop();
        }
        return true;
    }

    private void connectAndPrepare() throws SQLException {
        JdbcDatabaseManager.logger().debug("Acquiring JDBC connection from {}", (Object)this.getConnectionSource());
        this.connection = this.getConnectionSource().getConnection();
        JdbcDatabaseManager.logger().debug("Acquired JDBC connection {}", (Object)this.connection);
        JdbcDatabaseManager.logger().debug("Getting connection metadata {}", (Object)this.connection);
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        JdbcDatabaseManager.logger().debug("Connection metadata {}", (Object)databaseMetaData);
        this.isBatchSupported = databaseMetaData.supportsBatchUpdates();
        JdbcDatabaseManager.logger().debug("Connection supportsBatchUpdates: {}", (Object)this.isBatchSupported);
        this.connection.setAutoCommit(false);
        JdbcDatabaseManager.logger().debug("Preparing SQL {}", (Object)this.sqlStatement);
        this.statement = this.connection.prepareStatement(this.sqlStatement);
        JdbcDatabaseManager.logger().debug("Prepared SQL {}", (Object)this.statement);
        if (this.factoryData.truncateStrings) {
            this.initColumnMetaData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectAndStart() {
        this.checkConnection();
        JdbcDatabaseManager jdbcDatabaseManager = this;
        synchronized (jdbcDatabaseManager) {
            try {
                this.connectAndPrepare();
            }
            catch (SQLException sQLException) {
                this.reconnectOn(sQLException);
            }
        }
    }

    private Reconnector createReconnector() {
        Reconnector reconnector = new Reconnector();
        reconnector.setDaemon(true);
        reconnector.setPriority(1);
        return reconnector;
    }

    private String createSqlSelect() {
        StringBuilder stringBuilder = new StringBuilder("select ");
        JdbcDatabaseManager.appendColumnNames("SELECT", this.factoryData, stringBuilder);
        stringBuilder.append(" from ");
        stringBuilder.append(this.factoryData.tableName);
        stringBuilder.append(" where 1=0");
        return stringBuilder.toString();
    }

    private String fieldsToString() {
        return String.format("columnConfigs=%s, sqlStatement=%s, factoryData=%s, connection=%s, statement=%s, reconnector=%s, isBatchSupported=%s, columnMetaData=%s", this.columnConfigs, this.sqlStatement, this.factoryData, this.connection, this.statement, this.reconnector, this.isBatchSupported, this.columnMetaData);
    }

    public ConnectionSource getConnectionSource() {
        return this.factoryData.connectionSource;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String getTableName() {
        return this.factoryData.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initColumnMetaData() throws SQLException {
        PreparedStatement preparedStatement;
        block12: {
            Object object;
            String string = this.createSqlSelect();
            JdbcDatabaseManager.logger().debug("Getting SQL metadata for table {}: {}", (Object)this.factoryData.tableName, (Object)string);
            preparedStatement = this.connection.prepareStatement(string);
            Throwable throwable = null;
            try {
                object = preparedStatement.getMetaData();
                JdbcDatabaseManager.logger().debug("SQL metadata: {}", object);
                if (object != null) {
                    int n2 = object.getColumnCount();
                    this.columnMetaData = new HashMap<String, ResultSetColumnMetaData>(n2);
                    int n4 = 1;
                    for (int n3 = 0; n3 < n2; ++n3, ++n4) {
                        ResultSetColumnMetaData resultSetColumnMetaData = new ResultSetColumnMetaData((ResultSetMetaData)object, n4);
                        this.columnMetaData.put(resultSetColumnMetaData.getNameKey(), resultSetColumnMetaData);
                    }
                } else {
                    JdbcDatabaseManager.logger().warn("{}: truncateStrings is true and ResultSetMetaData is null for statement: {}; manager will not perform truncation.", (Object)this.getClass().getSimpleName(), (Object)preparedStatement);
                }
                if (preparedStatement == null) return;
                if (throwable == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4;
                    Throwables.throwIfCritical(throwable2);
                    throwable = throwable4 = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (preparedStatement == null) throw throwable5;
                    if (throwable == null) {
                        preparedStatement.close();
                        throw throwable5;
                    }
                    try {
                        preparedStatement.close();
                        throw throwable5;
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable7 = throwable3;
                        throwable.addSuppressed(throwable7);
                        throw throwable5;
                    }
                }
            }
            try {
                preparedStatement.close();
                return;
            }
            catch (Throwable throwable4) {
                Throwables.throwIfCritical(throwable4);
                object = throwable4;
                throwable.addSuppressed((Throwable)object);
                return;
            }
        }
        preparedStatement.close();
    }

    private boolean isClosed(Statement statement) throws SQLException {
        return statement == null || statement.isClosed();
    }

    private boolean isClosed(Connection connection) throws SQLException {
        return connection == null || connection.isClosed();
    }

    private void reconnectOn(Exception exception) {
        block4: {
            if (!this.factoryData.retry) {
                throw new AppenderLoggingException("Cannot connect and prepare", exception);
            }
            if (this.reconnector == null) {
                this.reconnector = this.createReconnector();
                try {
                    this.reconnector.reconnect();
                }
                catch (SQLException sQLException) {
                    JdbcDatabaseManager.logger().debug("Cannot reestablish JDBC connection to {}: {}; starting reconnector thread {}", (Object)this.factoryData, (Object)sQLException, (Object)this.reconnector.getName(), (Object)sQLException);
                    this.reconnector.start();
                    this.reconnector.latch();
                    if (this.connection != null && this.statement != null) break block4;
                    throw new AppenderLoggingException(exception, "Error sending to %s for %s [%s]", this.getName(), this.factoryData, this.fieldsToString());
                }
            }
        }
    }

    private void setFields(MapMessage<?, ?> mapMessage) throws SQLException {
        IndexedReadOnlyStringMap indexedReadOnlyStringMap = mapMessage.getIndexedReadOnlyStringMap();
        String string = this.statement.getClass().getName();
        int n2 = 1;
        if (this.factoryData.columnMappings != null) {
            for (ColumnMapping columnMapping : this.factoryData.columnMappings) {
                if (columnMapping.getLiteralValue() != null) continue;
                String string2 = columnMapping.getSource();
                String string3 = Strings.isEmpty(string2) ? columnMapping.getName() : string2;
                Object v2 = indexedReadOnlyStringMap.getValue(string3);
                if (JdbcDatabaseManager.logger().isTraceEnabled()) {
                    String string4 = v2 instanceof String ? "\"" + v2 + "\"" : Objects.toString(v2, null);
                    JdbcDatabaseManager.logger().trace("{} setObject({}, {}) for key '{}' and mapping '{}'", (Object)string, (Object)n2, (Object)string4, (Object)string3, (Object)columnMapping.getName());
                }
                this.setStatementObject(n2, columnMapping.getNameKey(), v2);
                ++n2;
            }
        }
    }

    private void setStatementObject(int n2, String string, Object object) throws SQLException {
        if (this.statement == null) {
            throw new AppenderLoggingException("Cannot set a value when the PreparedStatement is null.");
        }
        if (object == null) {
            if (this.columnMetaData == null) {
                throw new AppenderLoggingException("Cannot set a value when the column metadata is null.");
            }
            this.statement.setNull(n2, this.columnMetaData.get(string).getType());
        } else {
            this.statement.setObject(n2, this.truncate(string, object));
        }
    }

    @Override
    protected boolean shutdownInternal() {
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        return this.commitAndCloseAll();
    }

    @Override
    protected void startupInternal() throws Exception {
    }

    private Object truncate(String string, Object object) {
        if (object != null && this.factoryData.truncateStrings && this.columnMetaData != null) {
            ResultSetColumnMetaData resultSetColumnMetaData = this.columnMetaData.get(string);
            if (resultSetColumnMetaData != null) {
                if (resultSetColumnMetaData.isStringType()) {
                    object = resultSetColumnMetaData.truncate(object.toString());
                }
            } else {
                JdbcDatabaseManager.logger().error("Missing ResultSetColumnMetaData for {}, connection={}, statement={}", (Object)string, (Object)this.connection, (Object)this.statement);
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void writeInternal(LogEvent logEvent, Serializable serializable) {
        StringReader stringReader = null;
        try {
            if (!this.isRunning() || this.isClosed(this.connection) || this.isClosed(this.statement)) {
                throw new AppenderLoggingException("Cannot write logging event; JDBC manager not connected to the database, running=%s, [%s]).", this.isRunning(), this.fieldsToString());
            }
            this.statement.clearParameters();
            if (serializable instanceof MapMessage) {
                this.setFields((MapMessage)serializable);
            }
            int n2 = 1;
            if (this.factoryData.columnMappings != null) {
                for (ColumnMapping columnMapping : this.factoryData.columnMappings) {
                    if (ThreadContextMap.class.isAssignableFrom(columnMapping.getType()) || ReadOnlyStringMap.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setObject(n2++, logEvent.getContextData().toMap());
                        continue;
                    }
                    if (ThreadContextStack.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setObject(n2++, logEvent.getContextStack().asList());
                        continue;
                    }
                    if (Date.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setObject(n2++, DateTypeConverter.fromMillis(logEvent.getTimeMillis(), columnMapping.getType().asSubclass(Date.class)));
                        continue;
                    }
                    StringLayout stringLayout = columnMapping.getLayout();
                    if (stringLayout == null) continue;
                    if (Clob.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setClob(n2++, new StringReader((String)stringLayout.toSerializable(logEvent)));
                        continue;
                    }
                    if (NClob.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setNClob(n2++, new StringReader((String)stringLayout.toSerializable(logEvent)));
                        continue;
                    }
                    Object obj = TypeConverters.convert((String)stringLayout.toSerializable(logEvent), columnMapping.getType(), null);
                    this.setStatementObject(n2++, columnMapping.getNameKey(), obj);
                }
            }
            for (ColumnConfig columnConfig : this.columnConfigs) {
                if (columnConfig.isEventTimestamp()) {
                    this.statement.setTimestamp(n2++, new Timestamp(logEvent.getTimeMillis()));
                    continue;
                }
                if (columnConfig.isClob()) {
                    stringReader = new StringReader(columnConfig.getLayout().toSerializable(logEvent));
                    if (columnConfig.isUnicode()) {
                        this.statement.setNClob(n2++, stringReader);
                        continue;
                    }
                    this.statement.setClob(n2++, stringReader);
                    continue;
                }
                if (columnConfig.isUnicode()) {
                    this.statement.setNString(n2++, Objects.toString(this.truncate(columnConfig.getColumnNameKey(), columnConfig.getLayout().toSerializable(logEvent)), null));
                    continue;
                }
                this.statement.setString(n2++, Objects.toString(this.truncate(columnConfig.getColumnNameKey(), columnConfig.getLayout().toSerializable(logEvent)), null));
            }
            if (this.isBuffered() && this.isBatchSupported) {
                JdbcDatabaseManager.logger().debug("addBatch for {}", (Object)this.statement);
                this.statement.addBatch();
            } else {
                int n3 = this.statement.executeUpdate();
                JdbcDatabaseManager.logger().debug("executeUpdate = {} for {}", (Object)n3, (Object)this.statement);
                if (n3 == 0) {
                    throw new AppenderLoggingException("No records inserted in database table for log event in JDBC manager [%s].", this.fieldsToString());
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DbAppenderLoggingException(sQLException, "Failed to insert record for log event in JDBC manager: %s [%s]", sQLException, this.fieldsToString());
            }
            catch (Throwable throwable) {
                try {
                    if (this.statement != null) {
                        this.statement.clearParameters();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                Closer.closeSilently(stringReader);
                throw throwable;
            }
        }
        try {
            if (this.statement != null) {
                this.statement.clearParameters();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Closer.closeSilently(stringReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeThrough(LogEvent logEvent, Serializable serializable) {
        this.connectAndStart();
        try {
            try {
                this.writeInternal(logEvent, serializable);
            }
            finally {
                this.commitAndClose();
            }
        }
        catch (DbAppenderLoggingException dbAppenderLoggingException) {
            this.reconnectOn(dbAppenderLoggingException);
            try {
                this.writeInternal(logEvent, serializable);
            }
            finally {
                this.commitAndClose();
            }
        }
    }

    private static final class ResultSetColumnMetaData {
        private final String schemaName;
        private final String catalogName;
        private final String tableName;
        private final String name;
        private final String nameKey;
        private final String label;
        private final int displaySize;
        private final int type;
        private final String typeName;
        private final String className;
        private final int precision;
        private final int scale;
        private final boolean isStringType;

        public ResultSetColumnMetaData(ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
            this(resultSetMetaData.getSchemaName(n2), resultSetMetaData.getCatalogName(n2), resultSetMetaData.getTableName(n2), resultSetMetaData.getColumnName(n2), resultSetMetaData.getColumnLabel(n2), resultSetMetaData.getColumnDisplaySize(n2), resultSetMetaData.getColumnType(n2), resultSetMetaData.getColumnTypeName(n2), resultSetMetaData.getColumnClassName(n2), resultSetMetaData.getPrecision(n2), resultSetMetaData.getScale(n2));
        }

        private ResultSetColumnMetaData(String string, String string2, String string3, String string4, String string5, int n2, int n3, String string6, String string7, int n4, int n5) {
            this.schemaName = string;
            this.catalogName = string2;
            this.tableName = string3;
            this.name = string4;
            this.nameKey = ColumnMapping.toKey(string4);
            this.label = string5;
            this.displaySize = n2;
            this.type = n3;
            this.typeName = string6;
            this.className = string7;
            this.precision = n4;
            this.scale = n5;
            this.isStringType = n3 == 1 || n3 == -16 || n3 == -1 || n3 == -9 || n3 == 12;
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getClassName() {
            return this.className;
        }

        public int getDisplaySize() {
            return this.displaySize;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public String getNameKey() {
            return this.nameKey;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isStringType() {
            return this.isStringType;
        }

        public String toString() {
            return String.format("ColumnMetaData [schemaName=%s, catalogName=%s, tableName=%s, name=%s, nameKey=%s, label=%s, displaySize=%s, type=%s, typeName=%s, className=%s, precision=%s, scale=%s, isStringType=%s]", this.schemaName, this.catalogName, this.tableName, this.name, this.nameKey, this.label, this.displaySize, this.type, this.typeName, this.className, this.precision, this.scale, this.isStringType);
        }

        public String truncate(String string) {
            return this.precision > 0 ? Strings.left(string, this.precision) : string;
        }
    }

    private final class Reconnector
    extends Log4jThread {
        private final CountDownLatch latch;
        private volatile boolean shutdown;

        private Reconnector() {
            super("JdbcDatabaseManager-Reconnector");
            this.latch = new CountDownLatch(1);
        }

        public void latch() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void reconnect() throws SQLException {
            JdbcDatabaseManager.this.closeResources(false);
            JdbcDatabaseManager.this.connectAndPrepare();
            JdbcDatabaseManager.this.reconnector = null;
            this.shutdown = true;
            JdbcDatabaseManager.logger().debug("Connection reestablished to {}", (Object)JdbcDatabaseManager.this.factoryData);
        }

        @Override
        public void run() {
            ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
            try {
                while (!this.shutdown) {
                    try {
                        Reconnector.sleep(JdbcDatabaseManager.this.factoryData.reconnectIntervalMillis);
                        this.reconnect();
                    }
                    catch (InterruptedException | SQLException exception) {
                        JdbcDatabaseManager.logger().debug("Cannot reestablish JDBC connection to {}: {}", (Object)JdbcDatabaseManager.this.factoryData, (Object)exception.getLocalizedMessage(), (Object)exception);
                    }
                    finally {
                        this.latch.countDown();
                    }
                }
                scopeProvider.leaveScope();
                return;
            }
            catch (Throwable throwable) {
                scopeProvider.leaveScope();
                throw throwable;
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public String toString() {
            return String.format("Reconnector [latch=%s, shutdown=%s]", this.latch, this.shutdown);
        }
    }

    private static final class JdbcDatabaseManagerFactory
    implements ManagerFactory<JdbcDatabaseManager, FactoryData> {
        private static final char PARAMETER_MARKER = '?';

        private JdbcDatabaseManagerFactory() {
        }

        @Override
        public JdbcDatabaseManager createManager(String string, FactoryData factoryData) {
            StringBuilder stringBuilder = new StringBuilder("insert into ").append(factoryData.tableName).append(" (");
            JdbcDatabaseManager.appendColumnNames("INSERT", factoryData, stringBuilder);
            stringBuilder.append(") values (");
            int n2 = 1;
            if (factoryData.columnMappings != null) {
                for (ColumnMapping columnMapping : factoryData.columnMappings) {
                    String string2 = columnMapping.getName();
                    if (Strings.isNotEmpty(columnMapping.getLiteralValue())) {
                        JdbcDatabaseManager.logger().trace("Adding INSERT VALUES literal for ColumnMapping[{}]: {}={} ", (Object)n2, (Object)string2, (Object)columnMapping.getLiteralValue());
                        stringBuilder.append(columnMapping.getLiteralValue());
                    } else if (Strings.isNotEmpty(columnMapping.getParameter())) {
                        JdbcDatabaseManager.logger().trace("Adding INSERT VALUES parameter for ColumnMapping[{}]: {}={} ", (Object)n2, (Object)string2, (Object)columnMapping.getParameter());
                        stringBuilder.append(columnMapping.getParameter());
                    } else {
                        JdbcDatabaseManager.logger().trace("Adding INSERT VALUES parameter marker for ColumnMapping[{}]: {}={} ", (Object)n2, (Object)string2, (Object)Character.valueOf('?'));
                        stringBuilder.append('?');
                    }
                    stringBuilder.append(',');
                    ++n2;
                }
            }
            int n3 = factoryData.columnConfigs == null ? 0 : factoryData.columnConfigs.length;
            ArrayList<ColumnConfig> arrayList = new ArrayList<ColumnConfig>(n3);
            if (factoryData.columnConfigs != null) {
                for (ColumnConfig columnConfig : factoryData.columnConfigs) {
                    if (Strings.isNotEmpty(columnConfig.getLiteralValue())) {
                        stringBuilder.append(columnConfig.getLiteralValue());
                    } else {
                        stringBuilder.append('?');
                        arrayList.add(columnConfig);
                    }
                    stringBuilder.append(',');
                }
            }
            stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
            String string3 = stringBuilder.toString();
            return new JdbcDatabaseManager(string, string3, arrayList, factoryData);
        }
    }

    private static final class FactoryData
    extends AbstractDatabaseManager.AbstractFactoryData {
        private final ConnectionSource connectionSource;
        private final String tableName;
        private final ColumnConfig[] columnConfigs;
        private final ColumnMapping[] columnMappings;
        private final boolean immediateFail;
        private final boolean retry;
        private final long reconnectIntervalMillis;
        private final boolean truncateStrings;

        protected FactoryData(int n2, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray, boolean bl2, long l2, boolean bl3) {
            super(n2, layout);
            this.connectionSource = connectionSource;
            this.tableName = string;
            this.columnConfigs = columnConfigArray;
            this.columnMappings = columnMappingArray;
            this.immediateFail = bl2;
            this.retry = l2 > 0L;
            this.reconnectIntervalMillis = l2;
            this.truncateStrings = bl3;
        }

        public String toString() {
            return String.format("FactoryData [connectionSource=%s, tableName=%s, columnConfigs=%s, columnMappings=%s, immediateFail=%s, retry=%s, reconnectIntervalMillis=%s, truncateStrings=%s]", this.connectionSource, this.tableName, Arrays.toString(this.columnConfigs), Arrays.toString(this.columnMappings), this.immediateFail, this.retry, this.reconnectIntervalMillis, this.truncateStrings);
        }
    }
}

