/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async;

import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.ThreadContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.InternalAsyncUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ContextDataFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.MementoMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ThrowableProxy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.time.Instant;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.time.MutableInstant;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Clock;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NanoClock;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.ParameterConsumer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.ParameterVisitable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.ReusableMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.SimpleMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.TimestampMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.ReadOnlyStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringBuilders;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringMap;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Map;

public class RingBufferLogEvent
implements LogEvent,
ParameterVisitable,
ReusableMessage,
CharSequence {
    public static final Factory FACTORY = new Factory();
    private static final long serialVersionUID = 8462119088943934758L;
    private static final Message EMPTY = new SimpleMessage("");
    private boolean populated;
    private int threadPriority;
    private long threadId;
    private final MutableInstant instant = new MutableInstant();
    private long nanoTime;
    private short parameterCount;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private Level level;
    private String threadName;
    private String loggerName;
    private Message message;
    private String messageFormat;
    private StringBuilder messageText;
    private Object[] parameters;
    private transient Throwable thrown;
    private ThrowableProxy thrownProxy;
    private StringMap contextData = ContextDataFactory.createContextData();
    private Marker marker;
    private String fqcn;
    private StackTraceElement location;
    private ThreadContext.ContextStack contextStack;
    private transient AsyncLogger asyncLogger;

    public void setValues(AsyncLogger asyncLogger, String string, Marker marker, String string2, Level level, Message message, Throwable throwable, StringMap stringMap, ThreadContext.ContextStack contextStack, long l2, String string3, int n2, StackTraceElement stackTraceElement, Clock clock, NanoClock nanoClock) {
        this.threadPriority = n2;
        this.threadId = l2;
        this.level = level;
        this.threadName = string3;
        this.loggerName = string;
        this.setMessage(message);
        this.initTime(clock);
        this.nanoTime = nanoClock.nanoTime();
        this.thrown = throwable;
        this.thrownProxy = null;
        this.marker = marker;
        this.fqcn = string2;
        this.location = stackTraceElement;
        this.contextData = stringMap;
        this.contextStack = contextStack;
        this.asyncLogger = asyncLogger;
        this.populated = true;
    }

    private void initTime(Clock clock) {
        if (this.message instanceof TimestampMessage) {
            this.instant.initFromEpochMilli(((TimestampMessage)((Object)this.message)).getTimestamp(), 0);
        } else {
            this.instant.initFrom(clock);
        }
    }

    @Override
    public LogEvent toImmutable() {
        return this.createMemento();
    }

    private void setMessage(Message message) {
        if (message instanceof ReusableMessage) {
            ReusableMessage reusableMessage = (ReusableMessage)message;
            reusableMessage.formatTo(this.getMessageTextForWriting());
            this.messageFormat = reusableMessage.getFormat();
            this.parameters = reusableMessage.swapParameters(this.parameters == null ? new Object[10] : this.parameters);
            this.parameterCount = reusableMessage.getParameterCount();
        } else {
            this.message = InternalAsyncUtil.makeMessageImmutable(message);
        }
    }

    private StringBuilder getMessageTextForWriting() {
        if (this.messageText == null) {
            this.messageText = new StringBuilder(Constants.INITIAL_REUSABLE_MESSAGE_SIZE);
        }
        this.messageText.setLength(0);
        return this.messageText;
    }

    public void execute(boolean bl2) {
        this.endOfBatch = bl2;
        this.asyncLogger.actualAsyncLog(this);
    }

    public boolean isPopulated() {
        return this.populated;
    }

    @Override
    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    @Override
    public void setEndOfBatch(boolean bl2) {
        this.endOfBatch = bl2;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    @Override
    public void setIncludeLocation(boolean bl2) {
        this.includeLocation = bl2;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public String getLoggerFqcn() {
        return this.fqcn;
    }

    @Override
    public Level getLevel() {
        if (this.level == null) {
            this.level = Level.OFF;
        }
        return this.level;
    }

    @Override
    public Message getMessage() {
        if (this.message == null) {
            return this.messageText == null ? EMPTY : this;
        }
        return this.message;
    }

    @Override
    public String getFormattedMessage() {
        return this.messageText != null ? this.messageText.toString() : (this.message == null ? null : this.message.getFormattedMessage());
    }

    @Override
    public String getFormat() {
        return this.messageFormat;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters == null ? null : Arrays.copyOf(this.parameters, (int)this.parameterCount);
    }

    @Override
    public Throwable getThrowable() {
        return this.getThrown();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append((CharSequence)this.messageText);
    }

    @Override
    public Object[] swapParameters(Object[] objectArray) {
        Object[] objectArray2 = this.parameters;
        this.parameters = objectArray;
        return objectArray2;
    }

    @Override
    public short getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public <S> void forEachParameter(ParameterConsumer<S> parameterConsumer, S s2) {
        if (this.parameters != null) {
            for (short s3 = 0; s3 < this.parameterCount; s3 = (short)(s3 + 1)) {
                parameterConsumer.accept(this.parameters[s3], s3, s2);
            }
        }
    }

    @Override
    public Message memento() {
        if (this.message == null) {
            this.message = new MementoMessage(String.valueOf(this.messageText), this.messageFormat, this.getParameters());
        }
        return this.message;
    }

    @Override
    public int length() {
        return this.messageText.length();
    }

    @Override
    public char charAt(int n2) {
        return this.messageText.charAt(n2);
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        return this.messageText.subSequence(n2, n3);
    }

    @Override
    public Throwable getThrown() {
        if (this.thrown == null && this.thrownProxy != null) {
            this.thrown = this.thrownProxy.getThrowable();
        }
        return this.thrown;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    @Override
    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    void setContextData(StringMap stringMap) {
        this.contextData = stringMap;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextData.toMap();
    }

    @Override
    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public StackTraceElement getSource() {
        return this.location;
    }

    @Override
    public long getTimeMillis() {
        return this.message instanceof TimestampMessage ? ((TimestampMessage)((Object)this.message)).getTimestamp() : this.instant.getEpochMillisecond();
    }

    @Override
    public Instant getInstant() {
        return this.instant;
    }

    @Override
    public long getNanoTime() {
        return this.nanoTime;
    }

    public void clear() {
        this.populated = false;
        this.asyncLogger = null;
        this.loggerName = null;
        this.marker = null;
        this.fqcn = null;
        this.level = null;
        this.message = null;
        this.messageFormat = null;
        this.thrown = null;
        this.thrownProxy = null;
        this.contextStack = null;
        this.location = null;
        if (this.contextData != null) {
            if (this.contextData.isFrozen()) {
                this.contextData = null;
            } else {
                this.contextData.clear();
            }
        }
        if (Constants.ENABLE_THREADLOCALS) {
            StringBuilders.trimToMaxSize(this.messageText, Constants.MAX_REUSABLE_MESSAGE_SIZE);
            if (this.parameters != null) {
                Arrays.fill(this.parameters, null);
            }
        } else {
            this.messageText = null;
            this.parameters = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getThrownProxy();
        objectOutputStream.defaultWriteObject();
    }

    public LogEvent createMemento() {
        return new Log4jLogEvent.Builder(this).build();
    }

    public void initializeBuilder(Log4jLogEvent.Builder builder) {
        builder.setContextData(this.contextData).setContextStack(this.contextStack).setEndOfBatch(this.endOfBatch).setIncludeLocation(this.includeLocation).setLevel(this.getLevel()).setLoggerFqcn(this.fqcn).setLoggerName(this.loggerName).setMarker(this.marker).setMessage(this.memento()).setNanoTime(this.nanoTime).setSource(this.location).setThreadId(this.threadId).setThreadName(this.threadName).setThreadPriority(this.threadPriority).setThrown(this.getThrown()).setThrownProxy(this.thrownProxy).setInstant(this.instant);
    }

    private static class Factory
    implements EventFactory<RingBufferLogEvent> {
        private Factory() {
        }

        public RingBufferLogEvent newInstance() {
            return new RingBufferLogEvent();
        }
    }
}

