/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.time.Instant;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.time.MutableInstant;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

@Plugin(name="DatePatternConverter", category="Converter")
@ConverterKeys(value={"d", "date"})
@PerformanceSensitive(value={"allocation"})
public final class DatePatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private static final String UNIX_FORMAT = "UNIX";
    private static final String UNIX_MILLIS_FORMAT = "UNIX_MILLIS";
    private final String[] options;
    private final ThreadLocal<MutableInstant> threadLocalMutableInstant = new ThreadLocal();
    private final ThreadLocal<Formatter> threadLocalFormatter = new ThreadLocal();
    private final AtomicReference<CachedTime> cachedTime;
    private final Formatter formatter;

    private DatePatternConverter(String[] stringArray) {
        super("Date", "date");
        this.options = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
        this.formatter = this.createFormatter(stringArray);
        this.cachedTime = new AtomicReference<CachedTime>(this.fromEpochMillis(System.currentTimeMillis()));
    }

    private CachedTime fromEpochMillis(long l2) {
        MutableInstant mutableInstant = new MutableInstant();
        mutableInstant.initFromEpochMilli(l2, 0);
        return new CachedTime(mutableInstant);
    }

    private Formatter createFormatter(String[] stringArray) {
        FixedDateFormat fixedDateFormat = FixedDateFormat.createIfSupported(stringArray);
        if (fixedDateFormat != null) {
            return DatePatternConverter.createFixedFormatter(fixedDateFormat);
        }
        return DatePatternConverter.createNonFixedFormatter(stringArray);
    }

    public static DatePatternConverter newInstance(String[] stringArray) {
        return new DatePatternConverter(stringArray);
    }

    private static Formatter createFixedFormatter(FixedDateFormat fixedDateFormat) {
        return new FixedFormatter(fixedDateFormat);
    }

    private static Formatter createNonFixedFormatter(String[] stringArray) {
        Objects.requireNonNull(stringArray);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Options array must have at least one element");
        }
        Objects.requireNonNull(stringArray[0]);
        String string = stringArray[0];
        if (UNIX_FORMAT.equals(string)) {
            return new UnixFormatter();
        }
        if (UNIX_MILLIS_FORMAT.equals(string)) {
            return new UnixMillisFormatter();
        }
        FixedDateFormat.FixedFormat fixedFormat = FixedDateFormat.FixedFormat.lookup(string);
        String string2 = fixedFormat == null ? string : fixedFormat.getPattern();
        TimeZone timeZone = null;
        if (stringArray.length > 1 && stringArray[1] != null) {
            timeZone = TimeZone.getTimeZone(stringArray[1]);
        }
        Locale locale = null;
        if (stringArray.length > 2 && stringArray[2] != null) {
            locale = Locale.forLanguageTag(stringArray[2]);
        }
        try {
            FastDateFormat fastDateFormat = FastDateFormat.getInstance(string2, timeZone, locale);
            return new PatternFormatter(fastDateFormat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("Could not instantiate FastDateFormat with pattern " + string2, (Throwable)illegalArgumentException);
            return DatePatternConverter.createFixedFormatter(FixedDateFormat.create(FixedDateFormat.FixedFormat.DEFAULT, timeZone));
        }
    }

    public void format(Date date, StringBuilder stringBuilder) {
        this.format(date.getTime(), stringBuilder);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        this.format(logEvent.getInstant(), stringBuilder);
    }

    public void format(long l2, StringBuilder stringBuilder) {
        MutableInstant mutableInstant = this.getMutableInstant();
        mutableInstant.initFromEpochMilli(l2, 0);
        this.format(mutableInstant, stringBuilder);
    }

    private MutableInstant getMutableInstant() {
        if (Constants.ENABLE_THREADLOCALS) {
            MutableInstant mutableInstant = this.threadLocalMutableInstant.get();
            if (mutableInstant == null) {
                mutableInstant = new MutableInstant();
                this.threadLocalMutableInstant.set(mutableInstant);
            }
            return mutableInstant;
        }
        return new MutableInstant();
    }

    public void format(Instant instant, StringBuilder stringBuilder) {
        if (Constants.ENABLE_THREADLOCALS) {
            this.formatWithoutAllocation(instant, stringBuilder);
        } else {
            this.formatWithoutThreadLocals(instant, stringBuilder);
        }
    }

    private void formatWithoutAllocation(Instant instant, StringBuilder stringBuilder) {
        this.getThreadLocalFormatter().formatToBuffer(instant, stringBuilder);
    }

    private Formatter getThreadLocalFormatter() {
        Formatter formatter = this.threadLocalFormatter.get();
        if (formatter == null) {
            formatter = this.createFormatter(this.options);
            this.threadLocalFormatter.set(formatter);
        }
        return formatter;
    }

    private void formatWithoutThreadLocals(Instant instant, StringBuilder stringBuilder) {
        CachedTime cachedTime = this.cachedTime.get();
        if (instant.getEpochSecond() != cachedTime.epochSecond || instant.getNanoOfSecond() != cachedTime.nanoOfSecond) {
            CachedTime cachedTime2 = new CachedTime(instant);
            cachedTime = this.cachedTime.compareAndSet(cachedTime, cachedTime2) ? cachedTime2 : this.cachedTime.get();
        }
        stringBuilder.append(cachedTime.formatted);
    }

    @Override
    public void format(Object object, StringBuilder stringBuilder) {
        if (object instanceof Date) {
            this.format((Date)object, stringBuilder);
        }
        super.format(object, stringBuilder);
    }

    @Override
    public void format(StringBuilder stringBuilder, Object ... objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof Date)) continue;
            this.format(object, stringBuilder);
            break;
        }
    }

    public String getPattern() {
        return this.formatter.toPattern();
    }

    private final class CachedTime {
        public long epochSecond;
        public int nanoOfSecond;
        public String formatted;

        public CachedTime(Instant instant) {
            this.epochSecond = instant.getEpochSecond();
            this.nanoOfSecond = instant.getNanoOfSecond();
            this.formatted = DatePatternConverter.this.formatter.format(instant);
        }
    }

    private static final class UnixMillisFormatter
    extends Formatter {
        private UnixMillisFormatter() {
        }

        @Override
        String format(Instant instant) {
            return Long.toString(instant.getEpochMillisecond());
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder stringBuilder) {
            stringBuilder.append(instant.getEpochMillisecond());
        }
    }

    private static final class UnixFormatter
    extends Formatter {
        private UnixFormatter() {
        }

        @Override
        String format(Instant instant) {
            return Long.toString(instant.getEpochSecond());
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder stringBuilder) {
            stringBuilder.append(instant.getEpochSecond());
        }
    }

    private static final class FixedFormatter
    extends Formatter {
        private final FixedDateFormat fixedDateFormat;
        private final char[] cachedBuffer = new char[70];
        private int length = 0;

        FixedFormatter(FixedDateFormat fixedDateFormat) {
            this.fixedDateFormat = fixedDateFormat;
        }

        @Override
        String format(Instant instant) {
            return this.fixedDateFormat.formatInstant(instant);
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder stringBuilder) {
            int n2;
            long l2 = instant.getEpochSecond();
            if (!this.fixedDateFormat.isEquivalent(this.previousTime, this.nanos, l2, n2 = instant.getNanoOfSecond())) {
                this.length = this.fixedDateFormat.formatInstant(instant, this.cachedBuffer, 0);
                this.previousTime = l2;
                this.nanos = n2;
            }
            stringBuilder.append(this.cachedBuffer, 0, this.length);
        }

        @Override
        public String toPattern() {
            return this.fixedDateFormat.getFormat();
        }
    }

    private static final class PatternFormatter
    extends Formatter {
        private final FastDateFormat fastDateFormat;
        private final StringBuilder cachedBuffer = new StringBuilder(64);

        PatternFormatter(FastDateFormat fastDateFormat) {
            this.fastDateFormat = fastDateFormat;
        }

        @Override
        String format(Instant instant) {
            return this.fastDateFormat.format(instant.getEpochMillisecond());
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder stringBuilder) {
            long l2 = instant.getEpochMillisecond();
            if (this.previousTime != l2) {
                this.cachedBuffer.setLength(0);
                this.fastDateFormat.format(l2, this.cachedBuffer);
            }
            stringBuilder.append((CharSequence)this.cachedBuffer);
        }

        @Override
        public String toPattern() {
            return this.fastDateFormat.getPattern();
        }
    }

    private static abstract class Formatter {
        long previousTime;
        int nanos;

        private Formatter() {
        }

        abstract String format(Instant var1);

        abstract void formatToBuffer(Instant var1, StringBuilder var2);

        public String toPattern() {
            return null;
        }
    }
}

