/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;

@Plugin(name="repeat", category="Converter")
@ConverterKeys(value={":|", "repeat"})
@PerformanceSensitive(value={"allocation"})
public final class RepeatPatternConverter
extends LogEventPatternConverter {
    private final String result;

    public static RepeatPatternConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length != 2) {
            LOGGER.error("Incorrect number of options on repeat. Expected 2 received " + stringArray.length);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No string supplied on repeat");
            return null;
        }
        if (stringArray[1] == null) {
            LOGGER.error("No repeat count supplied on repeat");
            return null;
        }
        int n2 = 0;
        String string = stringArray[0];
        try {
            n2 = Integers.parseInt(stringArray[1]);
            string = Strings.repeat(stringArray[0], n2);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("The repeat count is not an integer: {}", (Object)stringArray[1].trim());
        }
        return new RepeatPatternConverter(string);
    }

    private RepeatPatternConverter(String string) {
        super("repeat", "repeat");
        this.result = string;
    }

    @Override
    public void format(Object object, StringBuilder stringBuilder) {
        this.format(stringBuilder);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        this.format(stringBuilder);
    }

    private void format(StringBuilder stringBuilder) {
        if (this.result != null) {
            stringBuilder.append(this.result);
        }
    }
}

