/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class Source {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final File file;
    private final URI uri;
    private final String location;

    private static String normalize(File file) {
        try {
            return file.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    private static File toFile(Path path) {
        try {
            return Objects.requireNonNull(path, "path").toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    private static File toFile(URI uRI) {
        try {
            String string = Objects.requireNonNull(uRI, "uri").getScheme();
            if (Strings.isBlank(string) || string.equals("file")) {
                return new File(uRI.getPath());
            }
            LOGGER.debug("uri does not represent a local file: " + uRI);
            return null;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.debug("uri is malformed: " + uRI.toString());
            return null;
        }
    }

    private static URI toURI(URL uRL) {
        try {
            return Objects.requireNonNull(uRL, "url").toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public Source(ConfigurationSource configurationSource) {
        this.file = configurationSource.getFile();
        this.uri = configurationSource.getURI();
        this.location = configurationSource.getLocation();
    }

    public Source(File file) {
        this.file = Objects.requireNonNull(file, "file");
        this.location = Source.normalize(file);
        this.uri = file.toURI();
    }

    public Source(Path path) {
        Path path2 = Objects.requireNonNull(path, "path").normalize();
        this.file = Source.toFile(path2);
        this.uri = path2.toUri();
        this.location = path2.toString();
    }

    public Source(URI uRI) {
        URI uRI2;
        this.uri = uRI2 = Objects.requireNonNull(uRI, "uri").normalize();
        this.location = uRI2.toString();
        this.file = Source.toFile(uRI2);
    }

    @Deprecated
    public Source(URI uRI, long l2) {
        this(uRI);
    }

    public Source(URL uRL) {
        this.uri = Source.toURI(uRL);
        this.location = this.uri.toString();
        this.file = Source.toFile(this.uri);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Source)) {
            return false;
        }
        Source source = (Source)object;
        return Objects.equals(this.location, source.location);
    }

    public File getFile() {
        return this.file;
    }

    public String getLocation() {
        return this.location;
    }

    public Path getPath() {
        return this.file != null ? this.file.toPath() : (this.uri != null ? Paths.get(this.uri) : Paths.get(this.location, new String[0]));
    }

    public URI getURI() {
        return this.uri;
    }

    public URL getURL() {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public String toString() {
        return this.location;
    }
}

