/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.message;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.AsynchronouslyFormattable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.MapMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.StructuredDataId;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.EnglishEnums;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringBuilders;
import java.util.Map;

@AsynchronouslyFormattable
public class StructuredDataMessage
extends MapMessage<StructuredDataMessage, String> {
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;
    private final int maxLength;

    public StructuredDataMessage(String string, String string2, String string3) {
        this(string, string2, string3, 32);
    }

    public StructuredDataMessage(String string, String string2, String string3, int n2) {
        this.id = new StructuredDataId(string, null, null, n2);
        this.message = string2;
        this.type = string3;
        this.maxLength = n2;
    }

    public StructuredDataMessage(String string, String string2, String string3, Map<String, String> map) {
        this(string, string2, string3, map, 32);
    }

    public StructuredDataMessage(String string, String string2, String string3, Map<String, String> map, int n2) {
        super(map);
        this.id = new StructuredDataId(string, null, null, n2);
        this.message = string2;
        this.type = string3;
        this.maxLength = n2;
    }

    public StructuredDataMessage(StructuredDataId structuredDataId, String string, String string2) {
        this(structuredDataId, string, string2, 32);
    }

    public StructuredDataMessage(StructuredDataId structuredDataId, String string, String string2, int n2) {
        this.id = structuredDataId;
        this.message = string;
        this.type = string2;
        this.maxLength = n2;
    }

    public StructuredDataMessage(StructuredDataId structuredDataId, String string, String string2, Map<String, String> map) {
        this(structuredDataId, string, string2, map, 32);
    }

    public StructuredDataMessage(StructuredDataId structuredDataId, String string, String string2, Map<String, String> map, int n2) {
        super(map);
        this.id = structuredDataId;
        this.message = string;
        this.type = string2;
        this.maxLength = n2;
    }

    private StructuredDataMessage(StructuredDataMessage structuredDataMessage, Map<String, String> map) {
        super(map);
        this.id = structuredDataMessage.id;
        this.message = structuredDataMessage.message;
        this.type = structuredDataMessage.type;
        this.maxLength = 32;
    }

    protected StructuredDataMessage() {
        this.maxLength = 32;
    }

    @Override
    public String[] getFormats() {
        String[] stringArray = new String[Format.values().length];
        int n2 = 0;
        for (Format format : Format.values()) {
            stringArray[n2++] = format.name();
        }
        return stringArray;
    }

    public StructuredDataId getId() {
        return this.id;
    }

    protected void setId(String string) {
        this.id = new StructuredDataId(string, null, null);
    }

    protected void setId(StructuredDataId structuredDataId) {
        this.id = structuredDataId;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String string) {
        if (string.length() > 32) {
            throw new IllegalArgumentException("structured data type exceeds maximum length of 32 characters: " + string);
        }
        this.type = string;
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        this.asString(Format.FULL, null, stringBuilder);
    }

    @Override
    public void formatTo(String[] stringArray, StringBuilder stringBuilder) {
        this.asString(this.getFormat(stringArray), null, stringBuilder);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    protected void setMessageFormat(String string) {
        this.message = string;
    }

    @Override
    public String asString() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String asString(String string) {
        try {
            return this.asString(EnglishEnums.valueOf(Format.class, string), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.asString();
        }
    }

    public final String asString(Format format, StructuredDataId structuredDataId) {
        StringBuilder stringBuilder = new StringBuilder();
        this.asString(format, structuredDataId, stringBuilder);
        return stringBuilder.toString();
    }

    public final void asString(Format format, StructuredDataId structuredDataId, StringBuilder stringBuilder) {
        String string;
        Object object;
        boolean bl2 = Format.FULL.equals((Object)format);
        if (bl2) {
            object = this.getType();
            if (object == null) {
                return;
            }
            stringBuilder.append(this.getType()).append(' ');
        }
        if ((object = (object = this.getId()) != null ? ((StructuredDataId)object).makeId(structuredDataId) : structuredDataId) == null || ((StructuredDataId)object).getName() == null) {
            return;
        }
        if (Format.XML.equals((Object)format)) {
            this.asXml((StructuredDataId)object, stringBuilder);
            return;
        }
        stringBuilder.append('[');
        StringBuilders.appendValue(stringBuilder, object);
        stringBuilder.append(' ');
        this.appendMap(stringBuilder);
        stringBuilder.append(']');
        if (bl2 && (string = this.getFormat()) != null) {
            stringBuilder.append(' ').append(string);
        }
    }

    private void asXml(StructuredDataId structuredDataId, StringBuilder stringBuilder) {
        stringBuilder.append("<StructuredData>\n");
        stringBuilder.append("<type>").append(this.type).append("</type>\n");
        stringBuilder.append("<id>").append(structuredDataId).append("</id>\n");
        super.asXml(stringBuilder);
        stringBuilder.append("\n</StructuredData>\n");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String getFormattedMessage(String[] stringArray) {
        return this.asString(this.getFormat(stringArray), null);
    }

    private Format getFormat(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (Format.XML.name().equalsIgnoreCase(string)) {
                    return Format.XML;
                }
                if (!Format.FULL.name().equalsIgnoreCase(string)) continue;
                return Format.FULL;
            }
            return null;
        }
        return Format.FULL;
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    @Override
    public StructuredDataMessage newInstance(Map<String, String> map) {
        return new StructuredDataMessage(this, map);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructuredDataMessage structuredDataMessage = (StructuredDataMessage)object;
        if (!super.equals(object)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(structuredDataMessage.type) : structuredDataMessage.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(structuredDataMessage.id) : structuredDataMessage.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(structuredDataMessage.message) : structuredDataMessage.message != null);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.id != null ? this.id.hashCode() : 0);
        n2 = 31 * n2 + (this.message != null ? this.message.hashCode() : 0);
        return n2;
    }

    @Override
    protected void validate(String string, boolean bl2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, byte by) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, char c2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, double d2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, float f2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, int n2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, long l2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, Object object) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, short s2) {
        this.validateKey(string);
    }

    @Override
    protected void validate(String string, String string2) {
        this.validateKey(string);
    }

    protected void validateKey(String string) {
        if (this.maxLength > 0 && string.length() > this.maxLength) {
            throw new IllegalArgumentException("Structured data keys are limited to " + this.maxLength + " characters. key: " + string);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '!' && c2 <= '~' && c2 != '=' && c2 != ']' && c2 != '\"') continue;
            throw new IllegalArgumentException("Structured data keys must contain printable US ASCII charactersand may not contain a space, =, ], or \"");
        }
    }

    public static enum Format {
        XML,
        FULL;

    }
}

