/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.LowLevelLogUtil;
import com.contrastsecurity.thirdparty.org.osgi.framework.Bundle;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleContext;
import com.contrastsecurity.thirdparty.org.osgi.framework.FrameworkUtil;
import java.lang.invoke.MethodHandles;
import java.util.stream.Stream;

public class OsgiServiceLocator {
    private static final boolean OSGI_AVAILABLE = OsgiServiceLocator.checkOsgiAvailable();

    private static boolean checkOsgiAvailable() {
        try {
            Class.forName("com.contrastsecurity.thirdparty.org.osgi.framework.Bundle");
            return true;
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            return false;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            LowLevelLogUtil.logException("Unknown error checking for existence of class: org.osgi.framework.Bundle", throwable2);
            return false;
        }
    }

    public static boolean isAvailable() {
        return OSGI_AVAILABLE;
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup) {
        return OsgiServiceLocator.loadServices(clazz, lookup, true);
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup, boolean bl2) {
        block3: {
            Bundle bundle = FrameworkUtil.getBundle(lookup.lookupClass());
            if (bundle != null) {
                BundleContext bundleContext = bundle.getBundleContext();
                try {
                    return bundleContext.getServiceReferences(clazz, null).stream().map(arg_0 -> ((BundleContext)bundleContext).getService(arg_0));
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    if (!bl2) break block3;
                    StatusLogger.getLogger().error("Unable to load OSGI services for service {}", (Object)clazz, (Object)throwable2);
                }
            }
        }
        return Stream.empty();
    }
}

