/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;

@PerformanceSensitive(value={"allocation"})
public class Unbox {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int BITS_PER_INT = 32;
    private static final int RINGBUFFER_MIN_SIZE = 32;
    private static final int RINGBUFFER_SIZE = Unbox.calculateRingBufferSize("com.contrastsecurity.thirdparty.log4j.unbox.ringbuffer.size");
    private static final int MASK = RINGBUFFER_SIZE - 1;
    private static ThreadLocal<State> threadLocalState = new ThreadLocal();
    private static WebSafeState webSafeState = new WebSafeState();

    private Unbox() {
    }

    private static int calculateRingBufferSize(String string) {
        String string2 = PropertiesUtil.getProperties().getStringProperty(string, String.valueOf(32));
        try {
            int n2 = Integer.parseInt(string2.trim());
            if (n2 < 32) {
                n2 = 32;
                LOGGER.warn("Invalid {} {}, using minimum size {}.", (Object)string, (Object)string2, (Object)32);
            }
            return Unbox.ceilingNextPowerOfTwo(n2);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.warn("Invalid {} {}, using default size {}.", (Object)string, (Object)string2, (Object)32);
            return 32;
        }
    }

    private static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(float f2) {
        return Unbox.getSB().append(f2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(double d2) {
        return Unbox.getSB().append(d2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(short s2) {
        return Unbox.getSB().append(s2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(int n2) {
        return Unbox.getSB().append(n2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(char c2) {
        return Unbox.getSB().append(c2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(long l2) {
        return Unbox.getSB().append(l2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(byte by) {
        return Unbox.getSB().append(by);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(boolean bl2) {
        return Unbox.getSB().append(bl2);
    }

    private static State getState() {
        State state = threadLocalState.get();
        if (state == null) {
            state = new State();
            threadLocalState.set(state);
        }
        return state;
    }

    private static StringBuilder getSB() {
        return Constants.ENABLE_THREADLOCALS ? Unbox.getState().getStringBuilder() : webSafeState.getStringBuilder();
    }

    static int getRingbufferSize() {
        return RINGBUFFER_SIZE;
    }

    private static class State {
        private final StringBuilder[] ringBuffer = new StringBuilder[Unbox.access$000()];
        private int current;

        State() {
            for (int i2 = 0; i2 < this.ringBuffer.length; ++i2) {
                this.ringBuffer[i2] = new StringBuilder(21);
            }
        }

        public StringBuilder getStringBuilder() {
            StringBuilder stringBuilder = this.ringBuffer[MASK & this.current++];
            stringBuilder.setLength(0);
            return stringBuilder;
        }

        public boolean isBoxedPrimitive(StringBuilder stringBuilder) {
            for (int i2 = 0; i2 < this.ringBuffer.length; ++i2) {
                if (stringBuilder != this.ringBuffer[i2]) continue;
                return true;
            }
            return false;
        }
    }

    private static class WebSafeState {
        private final ThreadLocal<StringBuilder[]> ringBuffer = new ThreadLocal();
        private final ThreadLocal<int[]> current = new ThreadLocal();

        private WebSafeState() {
        }

        public StringBuilder getStringBuilder() {
            StringBuilder[] stringBuilderArray = this.ringBuffer.get();
            if (stringBuilderArray == null) {
                stringBuilderArray = new StringBuilder[RINGBUFFER_SIZE];
                for (int i2 = 0; i2 < stringBuilderArray.length; ++i2) {
                    stringBuilderArray[i2] = new StringBuilder(21);
                }
                this.ringBuffer.set(stringBuilderArray);
                this.current.set(new int[1]);
            }
            int[] nArray = this.current.get();
            int n2 = nArray[0];
            nArray[0] = n2 + 1;
            StringBuilder stringBuilder = stringBuilderArray[MASK & n2];
            stringBuilder.setLength(0);
            return stringBuilder;
        }

        public boolean isBoxedPrimitive(StringBuilder stringBuilder) {
            StringBuilder[] stringBuilderArray = this.ringBuffer.get();
            if (stringBuilderArray == null) {
                return false;
            }
            for (int i2 = 0; i2 < stringBuilderArray.length; ++i2) {
                if (stringBuilder != stringBuilderArray[i2]) continue;
                return true;
            }
            return false;
        }
    }
}

