/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.msgpack.core;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.msgpack.core.ExtensionTypeHeader;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageFormat;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageFormatException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageInsufficientBufferException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageIntegerOverflowException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageNeverUsedFormatException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessagePack;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessagePackException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageSizeException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageStringCodingException;
import com.contrastsecurity.thirdparty.org.msgpack.core.MessageTypeException;
import com.contrastsecurity.thirdparty.org.msgpack.core.Preconditions;
import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBuffer;
import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBufferInput;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.Value;
import com.contrastsecurity.thirdparty.org.msgpack.value.ValueFactory;
import com.contrastsecurity.thirdparty.org.msgpack.value.Variable;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.time.Instant;

public class MessageUnpacker
implements Closeable {
    private static final MessageBuffer EMPTY_BUFFER = MessageBuffer.wrap(new byte[0]);
    private final boolean allowReadingStringAsBinary;
    private final boolean allowReadingBinaryAsString;
    private final CodingErrorAction actionOnMalformedString;
    private final CodingErrorAction actionOnUnmappableString;
    private final int stringSizeLimit;
    private final int stringDecoderBufferSize;
    private MessageBufferInput in;
    private MessageBuffer buffer = EMPTY_BUFFER;
    private int position;
    private long totalReadBytes;
    private final MessageBuffer numberBuffer = MessageBuffer.allocate(8);
    private int nextReadPosition;
    private StringBuilder decodeStringBuffer;
    private CharsetDecoder decoder;
    private CharBuffer decodeBuffer;
    private static final String EMPTY_STRING = "";

    protected MessageUnpacker(MessageBufferInput messageBufferInput, MessagePack.UnpackerConfig unpackerConfig) {
        this.in = Preconditions.checkNotNull(messageBufferInput, "MessageBufferInput is null");
        this.allowReadingStringAsBinary = unpackerConfig.getAllowReadingStringAsBinary();
        this.allowReadingBinaryAsString = unpackerConfig.getAllowReadingBinaryAsString();
        this.actionOnMalformedString = unpackerConfig.getActionOnMalformedString();
        this.actionOnUnmappableString = unpackerConfig.getActionOnUnmappableString();
        this.stringSizeLimit = unpackerConfig.getStringSizeLimit();
        this.stringDecoderBufferSize = unpackerConfig.getStringDecoderBufferSize();
    }

    public MessageBufferInput reset(MessageBufferInput messageBufferInput) throws IOException {
        MessageBufferInput messageBufferInput2 = Preconditions.checkNotNull(messageBufferInput, "MessageBufferInput is null");
        MessageBufferInput messageBufferInput3 = this.in;
        this.in = messageBufferInput2;
        this.buffer = EMPTY_BUFFER;
        this.position = 0;
        this.totalReadBytes = 0L;
        return messageBufferInput3;
    }

    public long getTotalReadBytes() {
        return this.totalReadBytes + (long)this.position;
    }

    private MessageBuffer getNextBuffer() throws IOException {
        MessageBuffer messageBuffer = this.in.next();
        if (messageBuffer == null) {
            throw new MessageInsufficientBufferException();
        }
        assert (this.buffer != null);
        this.totalReadBytes += (long)this.buffer.size();
        return messageBuffer;
    }

    private void nextBuffer() throws IOException {
        this.buffer = this.getNextBuffer();
        this.position = 0;
    }

    private MessageBuffer prepareNumberBuffer(int n2) throws IOException {
        int n3 = this.buffer.size() - this.position;
        if (n3 >= n2) {
            this.nextReadPosition = this.position;
            this.position += n2;
            return this.buffer;
        }
        int n4 = 0;
        if (n3 > 0) {
            this.numberBuffer.putMessageBuffer(0, this.buffer, this.position, n3);
            n2 -= n3;
            n4 += n3;
        }
        while (true) {
            this.nextBuffer();
            int n5 = this.buffer.size();
            if (n5 >= n2) break;
            this.numberBuffer.putMessageBuffer(n4, this.buffer, 0, n5);
            n2 -= n5;
            n4 += n5;
        }
        this.numberBuffer.putMessageBuffer(n4, this.buffer, 0, n2);
        this.position = n2;
        this.nextReadPosition = 0;
        return this.numberBuffer;
    }

    private static int utf8MultibyteCharacterSize(byte by) {
        return Integer.numberOfLeadingZeros(~(by & 0xFF) << 24);
    }

    public boolean hasNext() throws IOException {
        return this.ensureBuffer();
    }

    private boolean ensureBuffer() throws IOException {
        while (this.buffer.size() <= this.position) {
            MessageBuffer messageBuffer = this.in.next();
            if (messageBuffer == null) {
                return false;
            }
            this.totalReadBytes += (long)this.buffer.size();
            this.buffer = messageBuffer;
            this.position = 0;
        }
        return true;
    }

    public MessageFormat getNextFormat() throws IOException {
        if (!this.ensureBuffer()) {
            throw new MessageInsufficientBufferException();
        }
        byte by = this.buffer.getByte(this.position);
        return MessageFormat.valueOf(by);
    }

    private byte readByte() throws IOException {
        if (this.buffer.size() > this.position) {
            byte by = this.buffer.getByte(this.position);
            ++this.position;
            return by;
        }
        this.nextBuffer();
        if (this.buffer.size() > 0) {
            byte by = this.buffer.getByte(0);
            this.position = 1;
            return by;
        }
        return this.readByte();
    }

    private short readShort() throws IOException {
        MessageBuffer messageBuffer = this.prepareNumberBuffer(2);
        return messageBuffer.getShort(this.nextReadPosition);
    }

    private int readInt() throws IOException {
        MessageBuffer messageBuffer = this.prepareNumberBuffer(4);
        return messageBuffer.getInt(this.nextReadPosition);
    }

    private long readLong() throws IOException {
        MessageBuffer messageBuffer = this.prepareNumberBuffer(8);
        return messageBuffer.getLong(this.nextReadPosition);
    }

    private float readFloat() throws IOException {
        MessageBuffer messageBuffer = this.prepareNumberBuffer(4);
        return messageBuffer.getFloat(this.nextReadPosition);
    }

    private double readDouble() throws IOException {
        MessageBuffer messageBuffer = this.prepareNumberBuffer(8);
        return messageBuffer.getDouble(this.nextReadPosition);
    }

    public void skipValue() throws IOException {
        this.skipValue(1);
    }

    public void skipValue(int n2) throws IOException {
        while (n2 > 0) {
            byte by = this.readByte();
            MessageFormat messageFormat = MessageFormat.valueOf(by);
            switch (messageFormat) {
                case POSFIXINT: 
                case NEGFIXINT: 
                case BOOLEAN: 
                case NIL: {
                    break;
                }
                case FIXMAP: {
                    int n3 = by & 0xF;
                    n2 += n3 * 2;
                    break;
                }
                case FIXARRAY: {
                    int n3 = by & 0xF;
                    n2 += n3;
                    break;
                }
                case FIXSTR: {
                    int n3 = by & 0x1F;
                    this.skipPayload(n3);
                    break;
                }
                case INT8: 
                case UINT8: {
                    this.skipPayload(1);
                    break;
                }
                case INT16: 
                case UINT16: {
                    this.skipPayload(2);
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.skipPayload(4);
                    break;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    this.skipPayload(8);
                    break;
                }
                case BIN8: 
                case STR8: {
                    this.skipPayload(this.readNextLength8());
                    break;
                }
                case BIN16: 
                case STR16: {
                    this.skipPayload(this.readNextLength16());
                    break;
                }
                case BIN32: 
                case STR32: {
                    this.skipPayload(this.readNextLength32());
                    break;
                }
                case FIXEXT1: {
                    this.skipPayload(2);
                    break;
                }
                case FIXEXT2: {
                    this.skipPayload(3);
                    break;
                }
                case FIXEXT4: {
                    this.skipPayload(5);
                    break;
                }
                case FIXEXT8: {
                    this.skipPayload(9);
                    break;
                }
                case FIXEXT16: {
                    this.skipPayload(17);
                    break;
                }
                case EXT8: {
                    this.skipPayload(this.readNextLength8() + 1);
                    break;
                }
                case EXT16: {
                    this.skipPayload(this.readNextLength16() + 1);
                    break;
                }
                case EXT32: {
                    int n3 = this.readNextLength32();
                    this.skipPayload(1);
                    this.skipPayload(n3);
                    break;
                }
                case ARRAY16: {
                    n2 += this.readNextLength16();
                    break;
                }
                case ARRAY32: {
                    n2 += this.readNextLength32();
                    break;
                }
                case MAP16: {
                    n2 += this.readNextLength16() * 2;
                    break;
                }
                case MAP32: {
                    n2 += this.readNextLength32() * 2;
                    break;
                }
                case NEVER_USED: {
                    throw new MessageNeverUsedFormatException("Encountered 0xC1 \"NEVER_USED\" byte");
                }
            }
            --n2;
        }
    }

    private static MessagePackException unexpected(String string, byte by) {
        MessageFormat messageFormat = MessageFormat.valueOf(by);
        if (messageFormat == MessageFormat.NEVER_USED) {
            return new MessageNeverUsedFormatException(String.format("Expected %s, but encountered 0xC1 \"NEVER_USED\" byte", string));
        }
        String string2 = messageFormat.getValueType().name();
        String string3 = string2.substring(0, 1) + string2.substring(1).toLowerCase();
        return new MessageTypeException(String.format("Expected %s, but got %s (%02x)", string, string3, by));
    }

    private static MessagePackException unexpectedExtension(String string, int n2, int n3) {
        return new MessageTypeException(String.format("Expected extension type %s (%d), but got extension type %d", string, n2, n3));
    }

    public ImmutableValue unpackValue() throws IOException {
        MessageFormat messageFormat = this.getNextFormat();
        switch (messageFormat.getValueType()) {
            case NIL: {
                this.readByte();
                return ValueFactory.newNil();
            }
            case BOOLEAN: {
                return ValueFactory.newBoolean(this.unpackBoolean());
            }
            case INTEGER: {
                if (messageFormat == MessageFormat.UINT64) {
                    return ValueFactory.newInteger(this.unpackBigInteger());
                }
                return ValueFactory.newInteger(this.unpackLong());
            }
            case FLOAT: {
                return ValueFactory.newFloat(this.unpackDouble());
            }
            case STRING: {
                int n2 = this.unpackRawStringHeader();
                return ValueFactory.newString(this.readPayload(n2), true);
            }
            case BINARY: {
                int n3 = this.unpackBinaryHeader();
                return ValueFactory.newBinary(this.readPayload(n3), true);
            }
            case ARRAY: {
                int n4 = this.unpackArrayHeader();
                Value[] valueArray = new Value[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    valueArray[i2] = this.unpackValue();
                }
                return ValueFactory.newArray(valueArray, true);
            }
            case MAP: {
                int n5 = this.unpackMapHeader();
                Value[] valueArray = new Value[n5 * 2];
                for (int i3 = 0; i3 < n5 * 2; ++i3) {
                    valueArray[i3] = this.unpackValue();
                    valueArray[++i3] = this.unpackValue();
                }
                return ValueFactory.newMap(valueArray, true);
            }
            case EXTENSION: {
                ExtensionTypeHeader extensionTypeHeader = this.unpackExtensionTypeHeader();
                switch (extensionTypeHeader.getType()) {
                    case -1: {
                        return ValueFactory.newTimestamp(this.unpackTimestamp(extensionTypeHeader));
                    }
                }
                return ValueFactory.newExtension(extensionTypeHeader.getType(), this.readPayload(extensionTypeHeader.getLength()));
            }
        }
        throw new MessageNeverUsedFormatException("Unknown value type");
    }

    public Variable unpackValue(Variable variable) throws IOException {
        MessageFormat messageFormat = this.getNextFormat();
        switch (messageFormat.getValueType()) {
            case NIL: {
                this.readByte();
                variable.setNilValue();
                return variable;
            }
            case BOOLEAN: {
                variable.setBooleanValue(this.unpackBoolean());
                return variable;
            }
            case INTEGER: {
                switch (messageFormat) {
                    case UINT64: {
                        variable.setIntegerValue(this.unpackBigInteger());
                        return variable;
                    }
                }
                variable.setIntegerValue(this.unpackLong());
                return variable;
            }
            case FLOAT: {
                variable.setFloatValue(this.unpackDouble());
                return variable;
            }
            case STRING: {
                int n2 = this.unpackRawStringHeader();
                variable.setStringValue(this.readPayload(n2));
                return variable;
            }
            case BINARY: {
                int n3 = this.unpackBinaryHeader();
                variable.setBinaryValue(this.readPayload(n3));
                return variable;
            }
            case ARRAY: {
                int n4 = this.unpackArrayHeader();
                Value[] valueArray = new Value[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    valueArray[i2] = this.unpackValue();
                }
                variable.setArrayValue(valueArray);
                return variable;
            }
            case MAP: {
                int n5 = this.unpackMapHeader();
                Value[] valueArray = new Value[n5 * 2];
                for (int i3 = 0; i3 < n5 * 2; ++i3) {
                    valueArray[i3] = this.unpackValue();
                    valueArray[++i3] = this.unpackValue();
                }
                variable.setMapValue(valueArray);
                return variable;
            }
            case EXTENSION: {
                ExtensionTypeHeader extensionTypeHeader = this.unpackExtensionTypeHeader();
                switch (extensionTypeHeader.getType()) {
                    case -1: {
                        variable.setTimestampValue(this.unpackTimestamp(extensionTypeHeader));
                        break;
                    }
                    default: {
                        variable.setExtensionValue(extensionTypeHeader.getType(), this.readPayload(extensionTypeHeader.getLength()));
                    }
                }
                return variable;
            }
        }
        throw new MessageFormatException("Unknown value type");
    }

    public void unpackNil() throws IOException {
        byte by = this.readByte();
        if (by == -64) {
            return;
        }
        throw MessageUnpacker.unexpected("Nil", by);
    }

    public boolean tryUnpackNil() throws IOException {
        if (!this.ensureBuffer()) {
            throw new MessageInsufficientBufferException();
        }
        byte by = this.buffer.getByte(this.position);
        if (by == -64) {
            this.readByte();
            return true;
        }
        return false;
    }

    public boolean unpackBoolean() throws IOException {
        byte by = this.readByte();
        if (by == -62) {
            return false;
        }
        if (by == -61) {
            return true;
        }
        throw MessageUnpacker.unexpected("boolean", by);
    }

    public byte unpackByte() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                if (by2 < 0) {
                    throw MessageUnpacker.overflowU8(by2);
                }
                return by2;
            }
            case -51: {
                short s2 = this.readShort();
                if (s2 < 0 || s2 > 127) {
                    throw MessageUnpacker.overflowU16(s2);
                }
                return (byte)s2;
            }
            case -50: {
                int n2 = this.readInt();
                if (n2 < 0 || n2 > 127) {
                    throw MessageUnpacker.overflowU32(n2);
                }
                return (byte)n2;
            }
            case -49: {
                long l2 = this.readLong();
                if (l2 < 0L || l2 > 127L) {
                    throw MessageUnpacker.overflowU64(l2);
                }
                return (byte)l2;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s3 = this.readShort();
                if (s3 < -128 || s3 > 127) {
                    throw MessageUnpacker.overflowI16(s3);
                }
                return (byte)s3;
            }
            case -46: {
                int n3 = this.readInt();
                if (n3 < -128 || n3 > 127) {
                    throw MessageUnpacker.overflowI32(n3);
                }
                return (byte)n3;
            }
            case -45: {
                long l3 = this.readLong();
                if (l3 < -128L || l3 > 127L) {
                    throw MessageUnpacker.overflowI64(l3);
                }
                return (byte)l3;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public short unpackShort() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return (short)(by2 & 0xFF);
            }
            case -51: {
                short s2 = this.readShort();
                if (s2 < 0) {
                    throw MessageUnpacker.overflowU16(s2);
                }
                return s2;
            }
            case -50: {
                int n2 = this.readInt();
                if (n2 < 0 || n2 > Short.MAX_VALUE) {
                    throw MessageUnpacker.overflowU32(n2);
                }
                return (short)n2;
            }
            case -49: {
                long l2 = this.readLong();
                if (l2 < 0L || l2 > 32767L) {
                    throw MessageUnpacker.overflowU64(l2);
                }
                return (short)l2;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s3 = this.readShort();
                return s3;
            }
            case -46: {
                int n3 = this.readInt();
                if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                    throw MessageUnpacker.overflowI32(n3);
                }
                return (short)n3;
            }
            case -45: {
                long l3 = this.readLong();
                if (l3 < -32768L || l3 > 32767L) {
                    throw MessageUnpacker.overflowI64(l3);
                }
                return (short)l3;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public int unpackInt() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return by2 & 0xFF;
            }
            case -51: {
                short s2 = this.readShort();
                return s2 & 0xFFFF;
            }
            case -50: {
                int n2 = this.readInt();
                if (n2 < 0) {
                    throw MessageUnpacker.overflowU32(n2);
                }
                return n2;
            }
            case -49: {
                long l2 = this.readLong();
                if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                    throw MessageUnpacker.overflowU64(l2);
                }
                return (int)l2;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s3 = this.readShort();
                return s3;
            }
            case -46: {
                int n3 = this.readInt();
                return n3;
            }
            case -45: {
                long l3 = this.readLong();
                if (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE) {
                    throw MessageUnpacker.overflowI64(l3);
                }
                return (int)l3;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public long unpackLong() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return by2 & 0xFF;
            }
            case -51: {
                short s2 = this.readShort();
                return s2 & 0xFFFF;
            }
            case -50: {
                int n2 = this.readInt();
                if (n2 < 0) {
                    return (long)(n2 & Integer.MAX_VALUE) + 0x80000000L;
                }
                return n2;
            }
            case -49: {
                long l2 = this.readLong();
                if (l2 < 0L) {
                    throw MessageUnpacker.overflowU64(l2);
                }
                return l2;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s3 = this.readShort();
                return s3;
            }
            case -46: {
                int n3 = this.readInt();
                return n3;
            }
            case -45: {
                long l3 = this.readLong();
                return l3;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public BigInteger unpackBigInteger() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixInt(by)) {
            return BigInteger.valueOf(by);
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return BigInteger.valueOf(by2 & 0xFF);
            }
            case -51: {
                short s2 = this.readShort();
                return BigInteger.valueOf(s2 & 0xFFFF);
            }
            case -50: {
                int n2 = this.readInt();
                if (n2 < 0) {
                    return BigInteger.valueOf((long)(n2 & Integer.MAX_VALUE) + 0x80000000L);
                }
                return BigInteger.valueOf(n2);
            }
            case -49: {
                long l2 = this.readLong();
                if (l2 < 0L) {
                    BigInteger bigInteger = BigInteger.valueOf(l2 + Long.MAX_VALUE + 1L).setBit(63);
                    return bigInteger;
                }
                return BigInteger.valueOf(l2);
            }
            case -48: {
                byte by3 = this.readByte();
                return BigInteger.valueOf(by3);
            }
            case -47: {
                short s3 = this.readShort();
                return BigInteger.valueOf(s3);
            }
            case -46: {
                int n3 = this.readInt();
                return BigInteger.valueOf(n3);
            }
            case -45: {
                long l3 = this.readLong();
                return BigInteger.valueOf(l3);
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public float unpackFloat() throws IOException {
        byte by = this.readByte();
        switch (by) {
            case -54: {
                float f2 = this.readFloat();
                return f2;
            }
            case -53: {
                double d2 = this.readDouble();
                return (float)d2;
            }
        }
        throw MessageUnpacker.unexpected("Float", by);
    }

    public double unpackDouble() throws IOException {
        byte by = this.readByte();
        switch (by) {
            case -54: {
                float f2 = this.readFloat();
                return f2;
            }
            case -53: {
                double d2 = this.readDouble();
                return d2;
            }
        }
        throw MessageUnpacker.unexpected("Float", by);
    }

    private void resetDecoder() {
        if (this.decoder == null) {
            this.decodeBuffer = CharBuffer.allocate(this.stringDecoderBufferSize);
            this.decoder = MessagePack.UTF8.newDecoder().onMalformedInput(this.actionOnMalformedString).onUnmappableCharacter(this.actionOnUnmappableString);
        } else {
            this.decoder.reset();
        }
        if (this.decodeStringBuffer == null) {
            this.decodeStringBuffer = new StringBuilder();
        } else {
            this.decodeStringBuffer.setLength(0);
        }
    }

    public String unpackString() throws IOException {
        int n2 = this.unpackRawStringHeader();
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        if (n2 > this.stringSizeLimit) {
            throw new MessageSizeException(String.format("cannot unpack a String of size larger than %,d: %,d", this.stringSizeLimit, n2), n2);
        }
        this.resetDecoder();
        if (this.buffer.size() - this.position >= n2) {
            return this.decodeStringFastPath(n2);
        }
        try {
            int n3 = n2;
            while (n3 > 0) {
                int n4;
                int n5 = this.buffer.size() - this.position;
                if (n5 >= n3) {
                    this.decodeStringBuffer.append(this.decodeStringFastPath(n3));
                    break;
                }
                if (n5 == 0) {
                    this.nextBuffer();
                    continue;
                }
                ByteBuffer byteBuffer = this.buffer.sliceAsByteBuffer(this.position, n5);
                int n6 = byteBuffer.position();
                this.decodeBuffer.clear();
                CoderResult coderResult = this.decoder.decode(byteBuffer, this.decodeBuffer, false);
                int n7 = byteBuffer.position() - n6;
                this.position += n7;
                n3 -= n7;
                this.decodeStringBuffer.append(this.decodeBuffer.flip());
                if (coderResult.isError()) {
                    this.handleCoderError(coderResult);
                }
                if (!coderResult.isUnderflow() || n7 >= n5) continue;
                int n8 = MessageUnpacker.utf8MultibyteCharacterSize(this.buffer.getByte(this.position));
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n8);
                this.buffer.getBytes(this.position, this.buffer.size() - this.position, byteBuffer2);
                while (true) {
                    this.nextBuffer();
                    n4 = byteBuffer2.remaining();
                    if (this.buffer.size() >= n4) break;
                    this.buffer.getBytes(0, this.buffer.size(), byteBuffer2);
                    this.position = this.buffer.size();
                }
                this.buffer.getBytes(0, n4, byteBuffer2);
                this.position = n4;
                byteBuffer2.position(0);
                this.decodeBuffer.clear();
                coderResult = this.decoder.decode(byteBuffer2, this.decodeBuffer, false);
                if (coderResult.isError()) {
                    this.handleCoderError(coderResult);
                }
                if (coderResult.isOverflow() || coderResult.isUnderflow() && byteBuffer2.position() < byteBuffer2.limit()) {
                    try {
                        coderResult.throwException();
                        throw new MessageFormatException("Unexpected UTF-8 multibyte sequence");
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        Exception exception2 = exception;
                        throw new MessageFormatException("Unexpected UTF-8 multibyte sequence", exception2);
                    }
                }
                n3 -= byteBuffer2.limit();
                this.decodeStringBuffer.append(this.decodeBuffer.flip());
            }
            return this.decodeStringBuffer.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            throw new MessageStringCodingException(characterCodingException);
        }
    }

    private void handleCoderError(CoderResult coderResult) throws CharacterCodingException {
        if (coderResult.isMalformed() && this.actionOnMalformedString == CodingErrorAction.REPORT || coderResult.isUnmappable() && this.actionOnUnmappableString == CodingErrorAction.REPORT) {
            coderResult.throwException();
        }
    }

    private String decodeStringFastPath(int n2) {
        CharBuffer charBuffer;
        if (this.actionOnMalformedString == CodingErrorAction.REPLACE && this.actionOnUnmappableString == CodingErrorAction.REPLACE && this.buffer.hasArray()) {
            String string = new String(this.buffer.array(), this.buffer.arrayOffset() + this.position, n2, MessagePack.UTF8);
            this.position += n2;
            return string;
        }
        ByteBuffer byteBuffer = this.buffer.sliceAsByteBuffer(this.position, n2);
        try {
            charBuffer = this.decoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new MessageStringCodingException(characterCodingException);
        }
        this.position += n2;
        return charBuffer.toString();
    }

    public Instant unpackTimestamp() throws IOException {
        ExtensionTypeHeader extensionTypeHeader = this.unpackExtensionTypeHeader();
        return this.unpackTimestamp(extensionTypeHeader);
    }

    public Instant unpackTimestamp(ExtensionTypeHeader extensionTypeHeader) throws IOException {
        if (extensionTypeHeader.getType() != -1) {
            throw MessageUnpacker.unexpectedExtension("Timestamp", -1, extensionTypeHeader.getType());
        }
        switch (extensionTypeHeader.getLength()) {
            case 4: {
                long l2 = (long)this.readInt() & 0xFFFFFFFFL;
                return Instant.ofEpochSecond(l2);
            }
            case 8: {
                long l3 = this.readLong();
                int n2 = (int)(l3 >>> 34);
                long l4 = l3 & 0x3FFFFFFFFL;
                return Instant.ofEpochSecond(l4, n2);
            }
            case 12: {
                long l5 = (long)this.readInt() & 0xFFFFFFFFL;
                long l6 = this.readLong();
                return Instant.ofEpochSecond(l6, l5);
            }
        }
        throw new MessageFormatException(String.format("Timestamp extension type (%d) expects 4, 8, or 12 bytes of payload but got %d bytes", (byte)-1, extensionTypeHeader.getLength()));
    }

    public int unpackArrayHeader() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixedArray(by)) {
            return by & 0xF;
        }
        switch (by) {
            case -36: {
                int n2 = this.readNextLength16();
                return n2;
            }
            case -35: {
                int n3 = this.readNextLength32();
                return n3;
            }
        }
        throw MessageUnpacker.unexpected("Array", by);
    }

    public int unpackMapHeader() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixedMap(by)) {
            return by & 0xF;
        }
        switch (by) {
            case -34: {
                int n2 = this.readNextLength16();
                return n2;
            }
            case -33: {
                int n3 = this.readNextLength32();
                return n3;
            }
        }
        throw MessageUnpacker.unexpected("Map", by);
    }

    public ExtensionTypeHeader unpackExtensionTypeHeader() throws IOException {
        byte by = this.readByte();
        switch (by) {
            case -44: {
                byte by2 = this.readByte();
                return new ExtensionTypeHeader(by2, 1);
            }
            case -43: {
                byte by3 = this.readByte();
                return new ExtensionTypeHeader(by3, 2);
            }
            case -42: {
                byte by4 = this.readByte();
                return new ExtensionTypeHeader(by4, 4);
            }
            case -41: {
                byte by5 = this.readByte();
                return new ExtensionTypeHeader(by5, 8);
            }
            case -40: {
                byte by6 = this.readByte();
                return new ExtensionTypeHeader(by6, 16);
            }
            case -57: {
                MessageBuffer messageBuffer = this.prepareNumberBuffer(2);
                byte by7 = messageBuffer.getByte(this.nextReadPosition);
                int n2 = by7 & 0xFF;
                byte by8 = messageBuffer.getByte(this.nextReadPosition + 1);
                return new ExtensionTypeHeader(by8, n2);
            }
            case -56: {
                MessageBuffer messageBuffer = this.prepareNumberBuffer(3);
                short s2 = messageBuffer.getShort(this.nextReadPosition);
                int n3 = s2 & 0xFFFF;
                byte by9 = messageBuffer.getByte(this.nextReadPosition + 2);
                return new ExtensionTypeHeader(by9, n3);
            }
            case -55: {
                MessageBuffer messageBuffer = this.prepareNumberBuffer(5);
                int n4 = messageBuffer.getInt(this.nextReadPosition);
                if (n4 < 0) {
                    throw MessageUnpacker.overflowU32Size(n4);
                }
                int n5 = n4;
                byte by10 = messageBuffer.getByte(this.nextReadPosition + 4);
                return new ExtensionTypeHeader(by10, n5);
            }
        }
        throw MessageUnpacker.unexpected("Ext", by);
    }

    private int tryReadStringHeader(byte by) throws IOException {
        switch (by) {
            case -39: {
                return this.readNextLength8();
            }
            case -38: {
                return this.readNextLength16();
            }
            case -37: {
                return this.readNextLength32();
            }
        }
        return -1;
    }

    private int tryReadBinaryHeader(byte by) throws IOException {
        switch (by) {
            case -60: {
                return this.readNextLength8();
            }
            case -59: {
                return this.readNextLength16();
            }
            case -58: {
                return this.readNextLength32();
            }
        }
        return -1;
    }

    public int unpackRawStringHeader() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixedRaw(by)) {
            return by & 0x1F;
        }
        int n2 = this.tryReadStringHeader(by);
        if (n2 >= 0) {
            return n2;
        }
        if (this.allowReadingBinaryAsString && (n2 = this.tryReadBinaryHeader(by)) >= 0) {
            return n2;
        }
        throw MessageUnpacker.unexpected("String", by);
    }

    public int unpackBinaryHeader() throws IOException {
        byte by = this.readByte();
        if (MessagePack.Code.isFixedRaw(by)) {
            return by & 0x1F;
        }
        int n2 = this.tryReadBinaryHeader(by);
        if (n2 >= 0) {
            return n2;
        }
        if (this.allowReadingStringAsBinary && (n2 = this.tryReadStringHeader(by)) >= 0) {
            return n2;
        }
        throw MessageUnpacker.unexpected("Binary", by);
    }

    private void skipPayload(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("payload size must be >= 0: " + n2);
        }
        while (true) {
            int n3;
            if ((n3 = this.buffer.size() - this.position) >= n2) {
                this.position += n2;
                return;
            }
            this.position += n3;
            n2 -= n3;
            this.nextBuffer();
        }
    }

    public void readPayload(ByteBuffer byteBuffer) throws IOException {
        while (true) {
            int n2 = byteBuffer.remaining();
            int n3 = this.buffer.size() - this.position;
            if (n3 >= n2) {
                this.buffer.getBytes(this.position, n2, byteBuffer);
                this.position += n2;
                return;
            }
            this.buffer.getBytes(this.position, n3, byteBuffer);
            this.position += n3;
            this.nextBuffer();
        }
    }

    public void readPayload(MessageBuffer messageBuffer, int n2, int n3) throws IOException {
        while (true) {
            int n4;
            if ((n4 = this.buffer.size() - this.position) >= n3) {
                messageBuffer.putMessageBuffer(n2, this.buffer, this.position, n3);
                this.position += n3;
                return;
            }
            messageBuffer.putMessageBuffer(n2, this.buffer, this.position, n4);
            n2 += n4;
            n3 -= n4;
            this.position += n4;
            this.nextBuffer();
        }
    }

    public void readPayload(byte[] byArray) throws IOException {
        this.readPayload(byArray, 0, byArray.length);
    }

    public byte[] readPayload(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.readPayload(byArray);
        return byArray;
    }

    public void readPayload(byte[] byArray, int n2, int n3) throws IOException {
        while (true) {
            int n4;
            if ((n4 = this.buffer.size() - this.position) >= n3) {
                this.buffer.getBytes(this.position, byArray, n2, n3);
                this.position += n3;
                return;
            }
            this.buffer.getBytes(this.position, byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.position += n4;
            this.nextBuffer();
        }
    }

    public MessageBuffer readPayloadAsReference(int n2) throws IOException {
        int n3 = this.buffer.size() - this.position;
        if (n3 >= n2) {
            MessageBuffer messageBuffer = this.buffer.slice(this.position, n2);
            this.position += n2;
            return messageBuffer;
        }
        MessageBuffer messageBuffer = MessageBuffer.allocate(n2);
        this.readPayload(messageBuffer, 0, n2);
        return messageBuffer;
    }

    private int readNextLength8() throws IOException {
        byte by = this.readByte();
        return by & 0xFF;
    }

    private int readNextLength16() throws IOException {
        short s2 = this.readShort();
        return s2 & 0xFFFF;
    }

    private int readNextLength32() throws IOException {
        int n2 = this.readInt();
        if (n2 < 0) {
            throw MessageUnpacker.overflowU32Size(n2);
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.totalReadBytes += (long)this.position;
        this.buffer = EMPTY_BUFFER;
        this.position = 0;
        this.in.close();
    }

    private static MessageIntegerOverflowException overflowU8(byte by) {
        BigInteger bigInteger = BigInteger.valueOf(by & 0xFF);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowU16(short s2) {
        BigInteger bigInteger = BigInteger.valueOf(s2 & 0xFFFF);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowU32(int n2) {
        BigInteger bigInteger = BigInteger.valueOf((long)(n2 & Integer.MAX_VALUE) + 0x80000000L);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowU64(long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2 + Long.MAX_VALUE + 1L).setBit(63);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowI16(short s2) {
        BigInteger bigInteger = BigInteger.valueOf(s2);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowI32(int n2) {
        BigInteger bigInteger = BigInteger.valueOf(n2);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowI64(long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageSizeException overflowU32Size(int n2) {
        long l2 = (long)(n2 & Integer.MAX_VALUE) + 0x80000000L;
        return new MessageSizeException(l2);
    }
}

