/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.msgpack.core.buffer;

import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBuffer;
import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBufferOutput;
import java.util.ArrayList;
import java.util.List;

public class ArrayBufferOutput
implements MessageBufferOutput {
    private final List<MessageBuffer> list;
    private final int bufferSize;
    private MessageBuffer lastBuffer;

    public ArrayBufferOutput() {
        this(8192);
    }

    public ArrayBufferOutput(int n2) {
        this.bufferSize = n2;
        this.list = new ArrayList<MessageBuffer>();
    }

    public int getSize() {
        int n2 = 0;
        for (MessageBuffer messageBuffer : this.list) {
            n2 += messageBuffer.size();
        }
        return n2;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.getSize()];
        int n2 = 0;
        for (MessageBuffer messageBuffer : this.list) {
            messageBuffer.getBytes(0, byArray, n2, messageBuffer.size());
            n2 += messageBuffer.size();
        }
        return byArray;
    }

    public MessageBuffer toMessageBuffer() {
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        if (this.list.isEmpty()) {
            return MessageBuffer.allocate(0);
        }
        return MessageBuffer.wrap(this.toByteArray());
    }

    public List<MessageBuffer> toBufferList() {
        return new ArrayList<MessageBuffer>(this.list);
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public MessageBuffer next(int n2) {
        MessageBuffer messageBuffer;
        if (this.lastBuffer != null && this.lastBuffer.size() > n2) {
            return this.lastBuffer;
        }
        int n3 = Math.max(this.bufferSize, n2);
        this.lastBuffer = messageBuffer = MessageBuffer.allocate(n3);
        return messageBuffer;
    }

    @Override
    public void writeBuffer(int n2) {
        this.list.add(this.lastBuffer.slice(0, n2));
        this.lastBuffer = this.lastBuffer.size() - n2 > this.bufferSize / 4 ? this.lastBuffer.slice(n2, this.lastBuffer.size() - n2) : null;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        MessageBuffer messageBuffer = MessageBuffer.allocate(n3);
        messageBuffer.putBytes(0, byArray, n2, n3);
        this.list.add(messageBuffer);
    }

    @Override
    public void add(byte[] byArray, int n2, int n3) {
        MessageBuffer messageBuffer = MessageBuffer.wrap(byArray, n2, n3);
        this.list.add(messageBuffer);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

