/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Proto;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.AbstractParser;
import com.contrastsecurity.thirdparty.org.mvel2.integration.Interceptor;
import com.contrastsecurity.thirdparty.org.mvel2.util.MethodStub;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfiguration
implements Serializable {
    private static final int MAX_NEGATIVE_CACHE_SIZE;
    protected Map<String, Object> imports;
    protected HashSet<String> packageImports;
    protected Map<String, Interceptor> interceptors;
    protected transient ClassLoader classLoader;
    private transient Set<String> nonValidImports;
    private boolean allowNakedMethCall = MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL;
    private boolean allowBootstrapBypass = true;

    public ParserConfiguration() {
    }

    public ParserConfiguration(Map<String, Object> map, Map<String, Interceptor> map2) {
        this.addAllImports(map);
        this.interceptors = map2;
    }

    public ParserConfiguration(Map<String, Object> map, HashSet<String> hashSet, Map<String, Interceptor> map2) {
        this.addAllImports(map);
        this.packageImports = hashSet;
        this.interceptors = map2;
    }

    public HashSet<String> getPackageImports() {
        return this.packageImports;
    }

    public void setPackageImports(HashSet<String> hashSet) {
        this.packageImports = hashSet;
    }

    public Class getImport(String string) {
        if (this.imports != null && this.imports.containsKey(string) && this.imports.get(string) instanceof Class) {
            return (Class)this.imports.get(string);
        }
        return (Class)(AbstractParser.LITERALS.get(string) instanceof Class ? AbstractParser.LITERALS.get(string) : null);
    }

    public MethodStub getStaticImport(String string) {
        return this.imports != null ? (MethodStub)this.imports.get(string) : null;
    }

    public Object getStaticOrClassImport(String string) {
        return this.imports != null && this.imports.containsKey(string) ? this.imports.get(string) : AbstractParser.LITERALS.get(string);
    }

    public void addPackageImport(String string) {
        if (this.packageImports == null) {
            this.packageImports = new LinkedHashSet<String>();
        }
        this.packageImports.add(string);
        if (!this.addClassMemberStaticImports(string)) {
            this.packageImports.add(string);
        }
    }

    private boolean addClassMemberStaticImports(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            this.initImports();
            if (clazz.isEnum()) {
                for (Enum enum_ : EnumSet.allOf(clazz)) {
                    this.imports.put(enum_.name(), enum_);
                }
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & 9) != 9) continue;
                this.imports.put(field.getName(), field.get(null));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("error adding static imports for: " + string, illegalAccessException);
        }
        return false;
    }

    public void addAllImports(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        this.initImports();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Method) {
                this.imports.put(entry.getKey(), new MethodStub((Method)object));
                continue;
            }
            this.imports.put(entry.getKey(), object);
        }
    }

    private boolean checkForDynamicImport(String string) {
        if (this.packageImports == null) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        if (this.nonValidImports != null && this.nonValidImports.contains(string)) {
            return false;
        }
        int n2 = 0;
        Class clazz = null;
        for (String string2 : this.packageImports) {
            try {
                clazz = ParseTools.forNameWithInner(string2 + "." + string, this.getClassLoader());
                ++n2;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
            }
        }
        if (n2 > 1) {
            throw new RuntimeException("ambiguous class name: " + string);
        }
        if (n2 == 1) {
            this.addImport(string, clazz);
            return true;
        }
        this.cacheNegativeHitForDynamicImport(string);
        return false;
    }

    public boolean hasImport(String string) {
        return this.imports != null && this.imports.containsKey(string) || AbstractParser.CLASS_LITERALS.containsKey(string) || this.checkForDynamicImport(string);
    }

    private void initImports() {
        if (this.imports == null) {
            this.imports = new ConcurrentHashMap<String, Object>();
        }
    }

    public void addImport(Class clazz) {
        this.initImports();
        this.addImport(clazz.getSimpleName(), clazz);
    }

    public void addImport(String string, Class clazz) {
        this.initImports();
        this.imports.put(string, clazz);
    }

    public void addImport(String string, Proto proto) {
        this.initImports();
        this.imports.put(string, proto);
    }

    public void addImport(String string, Method method) {
        this.addImport(string, new MethodStub(method));
    }

    public void addImport(String string, MethodStub methodStub) {
        this.initImports();
        this.imports.put(string, methodStub);
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Map<String, Interceptor> map) {
        this.interceptors = map;
    }

    public Map<String, Object> getImports() {
        return this.imports;
    }

    public void setImports(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Class) {
                this.addImport(entry.getKey(), (Class)object);
                continue;
            }
            if (object instanceof Method) {
                this.addImport(entry.getKey(), (Method)object);
                continue;
            }
            if (object instanceof MethodStub) {
                this.addImport(entry.getKey(), (MethodStub)object);
                continue;
            }
            if (object instanceof Proto) {
                this.addImport(entry.getKey(), (Proto)entry.getValue());
                continue;
            }
            throw new RuntimeException("invalid element in imports map: " + entry.getKey() + " (" + object + ")");
        }
    }

    public boolean hasImports() {
        return this.imports == null || !this.imports.isEmpty() || this.packageImports != null && this.packageImports.size() != 0;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader == null ? (this.classLoader = Thread.currentThread().getContextClassLoader()) : this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setAllImports(Map<String, Object> map) {
        this.initImports();
        this.imports.clear();
        if (map != null) {
            this.imports.putAll(map);
        }
    }

    public void setImports(HashMap<String, Object> hashMap) {
        this.setAllImports(hashMap);
    }

    private void cacheNegativeHitForDynamicImport(String string) {
        if (this.nonValidImports == null) {
            this.nonValidImports = new LinkedHashSet<String>();
        } else if (this.nonValidImports.size() > 1000) {
            Iterator<String> iterator = this.nonValidImports.iterator();
            iterator.next();
            iterator.remove();
        }
        this.nonValidImports.add(string);
    }

    public void flushCaches() {
        if (this.nonValidImports != null) {
            this.nonValidImports.clear();
        }
    }

    public boolean isAllowNakedMethCall() {
        return this.allowNakedMethCall;
    }

    public void setAllowNakedMethCall(boolean bl2) {
        this.allowNakedMethCall = bl2;
    }

    public boolean isAllowBootstrapBypass() {
        return this.allowBootstrapBypass;
    }

    public void setAllowBootstrapBypass(boolean bl2) {
        this.allowBootstrapBypass = bl2;
    }

    static {
        String string = System.getProperty("mvel2.compiler.max_neg_cache_size");
        MAX_NEGATIVE_CACHE_SIZE = string != null ? Integer.parseInt(string) : 1000;
    }
}

