/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
public final class AppActivity {
    private final Set<String> technologies = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<ArchitectureComponent> components = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger httpCallCount = new AtomicInteger();
    private final AtomicInteger queryCount = new AtomicInteger();
    private final AtomicInteger urlCount = new AtomicInteger();

    public Set<String> getTechnologies() {
        return this.technologies;
    }

    public void addTechnology(String string) {
        this.technologies.add(string);
    }

    public Set<ArchitectureComponent> getArchs() {
        return this.components;
    }

    public void addArchitecture(ArchitectureComponent architectureComponent) {
        this.components.add(architectureComponent);
    }

    public int getHttpCallCount() {
        return this.httpCallCount.get();
    }

    public void addHttpCallMonitored() {
        this.httpCallCount.incrementAndGet();
    }

    public int getQueryCount() {
        return this.queryCount.get();
    }

    public void addQueryMonitored() {
        this.queryCount.incrementAndGet();
    }

    public int getUrlCount() {
        return this.urlCount.get();
    }

    public void urlHit() {
        this.urlCount.incrementAndGet();
    }

    public void merge(AppActivity appActivity) {
        if (appActivity == null) {
            return;
        }
        this.technologies.addAll(appActivity.getTechnologies());
        appActivity.getTechnologies().clear();
        this.components.addAll(appActivity.getArchs());
        appActivity.getArchs().clear();
        this.httpCallCount.addAndGet(appActivity.httpCallCount.getAndSet(0));
        this.queryCount.addAndGet(appActivity.queryCount.getAndSet(0));
        this.urlCount.addAndGet(appActivity.urlCount.getAndSet(0));
    }

    public boolean isEmpty() {
        return this.technologies.isEmpty() && this.components.isEmpty() && this.httpCallCount.get() == 0 && this.queryCount.get() == 0 && this.urlCount.get() == 0;
    }
}

