/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.EmptyTreeMap;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@DontObfuscate
public final class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <K, V> Map<K, V> newTreeMap(Map<K, V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, List<V>> deepCopyList(Map<K, List<V>> map) {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), Lists.copy((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static <K, V> Map<K, List<V>> deepCopyArrayToList(Map<K, V[]> map) {
        HashMap<K, List<V>> hashMap = new HashMap<K, List<V>>(map.size());
        for (Map.Entry<K, V[]> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static <K, V> boolean deepContainsValue(Map<K, V[]> map, V v2) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(v2);
        for (V[] VArray : map.values()) {
            if (VArray == null) continue;
            for (V v3 : VArray) {
                if (!v2.equals(v3)) continue;
                return true;
            }
        }
        return false;
    }

    public static <K, V> Map<K, Set<V>> deepCopySet(Map<K, Set<V>> map) {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry<K, Set<V>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), Sets.copy((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builder(int n2) {
        return new Builder(n2);
    }

    public static <K, V> TreeMap<K, V> emptyTreeMap() {
        return EmptyTreeMap.INSTANCE;
    }

    @DontObfuscate
    public static final class Builder<K, V> {
        private Map<K, V> map;

        private Builder() {
            this.map = new HashMap();
        }

        private Builder(int n2) {
            this.map = new HashMap(n2);
        }

        public Builder<K, V> add(K k2, V v2) {
            Preconditions.check(this.map != null, "This one-time-use map builder has already built a map.");
            this.map.put(k2, v2);
            return this;
        }

        public Builder<K, V> addAll(Map<? extends K, ? extends V> map) {
            Preconditions.check(this.map != null, "This one-time-use map builder has already built a map.");
            this.map.putAll(map);
            return this;
        }

        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.buildMutable());
        }

        public Map<K, V> buildMutable() {
            Preconditions.check(this.map != null, "This one-time-use map builder has already built a map.");
            Map<K, V> map = this.map;
            this.map = null;
            return map;
        }
    }
}

