/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.config;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigFactory;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigSourceSet;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.b.a;
import com.contrastsecurity.agent.config.d.b;
import com.contrastsecurity.agent.config.exception.ContrastConfigurationException;
import com.contrastsecurity.agent.config.i;
import com.contrastsecurity.agent.config.j;
import com.contrastsecurity.agent.config.l;
import com.contrastsecurity.agent.config.m;
import com.contrastsecurity.agent.config.n;
import com.contrastsecurity.agent.config.p;
import com.contrastsecurity.agent.context.ApplicationExecutionContext;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.ApplicationAssessSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.apps.e;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

@DontObfuscate
public class ConfigImpl
implements ConfigUpdatable {
    private static final ExecutionContext.Key<Boolean> ALREADY_INITIALIZED_APP_CONFIG = ExecutionContext.Key.create(Boolean.class);
    private final Object currentServerSettingsLock = new Object();
    private final ConfigFactory configFactory;
    private final Set<ConfigProperty> definedByImmutableSources;
    private final l invalidConfigLog = new l();
    private volatile ApplicationManager applicationManager;
    private volatile j effectiveConfigUpdateListener;
    private volatile m globalConfig;
    private ServerSettingsDTM currentServerSettings;

    public ConfigImpl(ConfigAbstractBuilder<?> configAbstractBuilder) {
        ConfigSourceSet configSourceSet;
        ConfigSourceSet configSourceSet2;
        String string;
        ConfigSourceSet configSourceSet3;
        ConfigSourceSet configSourceSet4 = configAbstractBuilder.embeddedXML() == null ? a.a(configAbstractBuilder.embeddedConfigFinderArgs(), configAbstractBuilder.isVerbose()) : configAbstractBuilder.embeddedXML();
        String string2 = configAbstractBuilder.systemProperties().getProperty("user.home");
        String string3 = WorkingDirectories.getDefaultContrastDirPath(string2);
        String string4 = configSourceSet4.getWorkingDir();
        if (string4 != null) {
            string3 = string4;
        }
        if ((string4 = (configSourceSet3 = configAbstractBuilder.yaml() != null ? configAbstractBuilder.yaml() : com.contrastsecurity.agent.config.e.a.a(configAbstractBuilder.systemProperties(), configAbstractBuilder.env(), this.invalidConfigLog)).getWorkingDir()) != null) {
            string3 = string4;
        }
        if ((string = configAbstractBuilder.systemProperties().getProperty(ConfigProperty.PROPERTIES.legacySystemPropertyName())) != null) {
            PreConfigUtil.out("Agent configuration via *.properties file is no longer supported. You could use any of the following options: System properties, YAML config file or Environment variables");
        }
        if ((string4 = (configSourceSet2 = com.contrastsecurity.agent.config.d.a.a(configAbstractBuilder.env(), this.invalidConfigLog)).getWorkingDir()) != null) {
            string3 = string4;
        }
        if ((string4 = (configSourceSet = b.a(configAbstractBuilder.systemProperties(), this.invalidConfigLog)).getWorkingDir()) != null) {
            string3 = string4;
        }
        ConfigSourceSet configSourceSet5 = com.contrastsecurity.agent.config.a.a.a(string3);
        this.configFactory = new ConfigFactory(configSourceSet5, configSourceSet4, configSourceSet3, configSourceSet2, configSourceSet, new SystemClock());
        this.globalConfig = this.configFactory.a();
        this.definedByImmutableSources = this.immutablePropertiesSet(configSourceSet4, configSourceSet3, configSourceSet2, configSourceSet);
    }

    public static ConfigBuilder builder() {
        return (ConfigBuilder)((ConfigBuilder)new ConfigBuilder().env(System.getenv())).systemProperties(System.getProperties());
    }

    @Override
    public void initializeApplicationConfig(ApplicationExecutionContext applicationExecutionContext, String string) {
        String string2;
        Boolean bl2 = applicationExecutionContext.putIfAbsent(ALREADY_INITIALIZED_APP_CONFIG, Boolean.TRUE);
        if (bl2 != null && bl2.booleanValue() || string == null) {
            return;
        }
        if (Assert.ENABLED) {
            Assert.assertTrue(string.equals(StringUtils.trimToNull(string)) && n.a(string), "Profile name \"" + string + "\" is invalid.");
        }
        if ((string2 = applicationExecutionContext.putIfAbsent(PROFILE_KEY, string)) != null) {
            return;
        }
        p p2 = applicationExecutionContext.get(p.a);
        ApplicationSettingsDTM applicationSettingsDTM = p2 == null ? null : p2.a();
        m m2 = this.configFactory.a(applicationExecutionContext, applicationSettingsDTM);
        if (p2 != null && m2.equals(p2.b())) {
            return;
        }
        applicationExecutionContext.put(p.a, p.a(applicationSettingsDTM, m2));
    }

    @o
    String getProfile(ExecutionContext executionContext) {
        return (String)executionContext.get(PROFILE_KEY);
    }

    @Override
    public ConfigFactory configFactory() {
        return this.configFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onServerSettingsUpdate(ServerSettingsDTM serverSettingsDTM, ServerSettingsDTM serverSettingsDTM2) {
        Object object = this.currentServerSettingsLock;
        synchronized (object) {
            this.currentServerSettings = serverSettingsDTM2;
        }
        this._serverSettingsUpdateConfig(serverSettingsDTM2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateServerSettings(UnaryOperator<ServerSettingsDTM> unaryOperator) {
        Object object = this.currentServerSettingsLock;
        synchronized (object) {
            this.currentServerSettings = (ServerSettingsDTM)unaryOperator.apply(this.currentServerSettings);
        }
        this._serverSettingsUpdateConfig(this.currentServerSettings);
    }

    private void _serverSettingsUpdateConfig(ServerSettingsDTM serverSettingsDTM) {
        this.globalConfig = this.configFactory.a(serverSettingsDTM);
        this.notifyEffectiveConfigUpdateListener();
    }

    void notifyEffectiveConfigUpdateListener() {
        for (Application application : ApplicationContext.all()) {
            this.notifyEffectiveConfigUpdateListener(application);
        }
    }

    void notifyEffectiveConfigUpdateListener(Application application) {
        if (this.effectiveConfigUpdateListener == null) {
            return;
        }
        this.effectiveConfigUpdateListener.a(application);
    }

    @Override
    public final synchronized void initializeApplicationManager(ApplicationManager applicationManager) {
        if (this.applicationManager != null) {
            throw new IllegalStateException("Attempted to initialize ApplicationManager multiple times");
        }
        this.applicationManager = Objects.requireNonNull(applicationManager);
    }

    @Override
    public String getStringGloballyOrViaAnyProfile(ConfigProperty configProperty) {
        String string = this.getOrNull(configProperty);
        return string == null ? this.configFactory.a(configProperty) : string;
    }

    @Override
    public final void initializeEffectiveConfigUpdateListener(j j2) {
        this.effectiveConfigUpdateListener = Objects.requireNonNull(j2);
    }

    @Override
    public String get(ConfigProperty configProperty) {
        return this.get(null, configProperty);
    }

    @Override
    public String get(ExecutionContext executionContext, ConfigProperty configProperty) {
        String string = this.getOrNull(executionContext, configProperty);
        if (string == null) {
            throw new ContrastConfigurationException("Expected a value to be assigned to " + (Object)((Object)configProperty) + " but it was empty instead.");
        }
        return string;
    }

    @Override
    public String getOrNull(ConfigProperty configProperty) {
        return this.getOrNull(null, configProperty);
    }

    @Override
    public String getOrNull(ExecutionContext executionContext, ConfigProperty configProperty) {
        Objects.requireNonNull(configProperty);
        m m2 = this.findMaterializedConfig(executionContext, configProperty);
        return m2.d(configProperty);
    }

    @Override
    public int getInt(ConfigProperty configProperty) {
        return this.getInt(null, configProperty);
    }

    @Override
    public int getInt(ExecutionContext executionContext, ConfigProperty configProperty) {
        Objects.requireNonNull(configProperty);
        m m2 = this.findMaterializedConfig(executionContext, configProperty);
        return m2.a(configProperty);
    }

    @Override
    public long getLong(ConfigProperty configProperty) {
        return this.getLong(null, configProperty);
    }

    @Override
    public long getLong(ExecutionContext executionContext, ConfigProperty configProperty) {
        Objects.requireNonNull(configProperty);
        m m2 = this.findMaterializedConfig(executionContext, configProperty);
        return m2.b(configProperty);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> clazz, ConfigProperty configProperty) {
        return this.getEnum(null, clazz, configProperty);
    }

    @Override
    public <T extends Enum<T>> T getEnum(ExecutionContext executionContext, Class<T> clazz, ConfigProperty configProperty) {
        m m2 = this.findMaterializedConfig(executionContext, configProperty);
        T t2 = m2.a(clazz, configProperty);
        if (t2 == null) {
            throw new ContrastConfigurationException("Expected a value to be assigned to " + (Object)((Object)configProperty) + " but it was empty instead.");
        }
        return t2;
    }

    @Override
    public <T extends Enum<T>> T getEnumOrNull(ExecutionContext executionContext, Class<T> clazz, ConfigProperty configProperty) {
        m m2 = this.findMaterializedConfig(executionContext, configProperty);
        return m2.a(clazz, configProperty);
    }

    @Override
    public <T extends Enum<T>> T getEnumOrNull(Class<T> clazz, ConfigProperty configProperty) {
        return this.getEnumOrNull(null, clazz, configProperty);
    }

    @Override
    public boolean getBoolean(ConfigProperty configProperty) {
        return this.getBoolean(null, configProperty);
    }

    @Override
    public boolean getBoolean(ExecutionContext executionContext, ConfigProperty configProperty) {
        Objects.requireNonNull(configProperty);
        m m2 = this.findMaterializedConfig(executionContext, configProperty);
        return m2.c(configProperty);
    }

    @Override
    public l invalidLog() {
        return this.invalidConfigLog;
    }

    private m findMaterializedConfig(ExecutionContext executionContext, ConfigProperty configProperty) {
        if (configProperty.isAppSpecific()) {
            p p2;
            p p3 = p2 = executionContext == null ? this.context().get(p.a) : executionContext.get(p.a);
            if (p2 != null) {
                return p2.b();
            }
        }
        return this.globalConfig;
    }

    final ExecutionContext context() {
        ApplicationContext applicationContext = ContrastContext.current().application();
        Application application = applicationContext.current();
        return application == null ? ExecutionContext.EMPTY : application.context();
    }

    @Override
    public Map<ConfigProperty, Object> retrieveSetProperties(boolean bl2) {
        EnumMap<ConfigProperty, Object> enumMap = new EnumMap<ConfigProperty, Object>(ConfigProperty.class);
        for (ConfigProperty configProperty : ConfigProperty.values()) {
            Object object;
            if (ConfigProperty.Category.INTERNAL_USAGE.equals((Object)configProperty.category())) continue;
            Class<?> clazz = configProperty.type();
            boolean bl3 = configProperty.hasNullDefaultValue();
            boolean bl4 = configProperty.shouldMask();
            Object object2 = clazz == Boolean.class ? Boolean.valueOf(this.getBoolean(configProperty)) : (clazz == Integer.class ? Integer.valueOf(this.getInt(configProperty)) : (clazz == Long.class ? Long.valueOf(this.getLong(configProperty)) : (clazz.isEnum() ? this.getEnumOrNullForRetrieveProps(Enum.class, configProperty) : this.getOrNull(configProperty))));
            if (bl3 && object2 == null || !bl3 && (object = configProperty.defaultValue()) != null && object.equals(object2)) continue;
            enumMap.put(configProperty, bl2 && bl4 ? "contrast-log-redacted" : object2);
        }
        return Collections.unmodifiableMap(enumMap);
    }

    <T extends Enum<T>> T getEnumOrNullForRetrieveProps(Class<T> clazz, ConfigProperty configProperty) {
        return this.getEnumOrNull(clazz, configProperty);
    }

    private Set<ConfigProperty> immutablePropertiesSet(ConfigSourceSet ... configSourceSetArray) {
        HashSet<ConfigProperty> hashSet = new HashSet<ConfigProperty>();
        for (ConfigSourceSet configSourceSet : configSourceSetArray) {
            hashSet.addAll(configSourceSet.getProperties().stream().filter(i2 -> i2.b() != null).map(i::d).collect(Collectors.toSet()));
        }
        return hashSet;
    }

    @Override
    public boolean isImmutable(ConfigProperty configProperty) {
        return this.definedByImmutableSources.contains((Object)configProperty);
    }

    @Override
    public void onApplicationSettingsUpdate(e e2) {
        ApplicationSettingsDTM applicationSettingsDTM = e2.b();
        Application application = e2.a();
        p p2 = application.context().get(p.a);
        if (p2 != null && applicationSettingsDTM.equals(p2.a())) {
            return;
        }
        this.saveSessionIdExactlyOnce(applicationSettingsDTM, application.context());
        application.context().put(p.a, p.a(applicationSettingsDTM, this.configFactory.a(application.context(), applicationSettingsDTM)));
        this.notifyEffectiveConfigUpdateListener(application);
    }

    private void saveSessionIdExactlyOnce(ApplicationSettingsDTM applicationSettingsDTM, ExecutionContext executionContext) {
        String string;
        ApplicationAssessSettingsDTM applicationAssessSettingsDTM = applicationSettingsDTM.getAssessment();
        String string2 = string = applicationAssessSettingsDTM == null ? null : applicationAssessSettingsDTM.getSessionId();
        if (string != null) {
            executionContext.put(SESSION_ID_KEY, string);
        }
    }

    @DontObfuscate
    public static final class ConfigBuilder
    extends ConfigAbstractBuilder<ConfigBuilder> {
        @Override
        protected ConfigBuilder self() {
            return this;
        }

        @Override
        public ConfigUpdatable build() {
            return new ConfigImpl(this);
        }
    }

    @DontObfuscate
    public static abstract class ConfigAbstractBuilder<T extends ConfigAbstractBuilder<T>> {
        private String embeddedConfigFinderArgs;
        private boolean verbose;
        private Properties systemProperties;
        private Map<String, String> env;
        private ConfigSourceSet yaml;
        private ConfigSourceSet embeddedXML;

        ConfigAbstractBuilder() {
        }

        public T embeddedConfigFinderArgs(String string) {
            if (this.embeddedXML != null) {
                throw new IllegalStateException("Cannot set embeddedXML and embedded XML configuration finder arguments");
            }
            this.embeddedConfigFinderArgs = string;
            return this.self();
        }

        public String embeddedConfigFinderArgs() {
            return this.embeddedConfigFinderArgs;
        }

        public T verbose() {
            this.verbose = true;
            return this.self();
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public T systemProperties(Properties properties) {
            this.systemProperties = properties;
            return this.self();
        }

        public Properties systemProperties() {
            return this.systemProperties;
        }

        public T env(Map<String, String> map) {
            this.env = map;
            return this.self();
        }

        public Map<String, String> env() {
            return this.env;
        }

        public T yaml(ConfigSourceSet configSourceSet) {
            this.yaml = configSourceSet;
            return this.self();
        }

        public ConfigSourceSet yaml() {
            return this.yaml;
        }

        public T embeddedXML(ConfigSourceSet configSourceSet) {
            this.embeddedXML = configSourceSet;
            return this.self();
        }

        public ConfigSourceSet embeddedXML() {
            return this.embeddedXML;
        }

        protected abstract T self();

        public abstract Config build();
    }
}

