/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.config;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.l;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;

@DontObfuscate
public class WorkingDirectories {
    private static final String SETTINGS = ".contrast";
    private static final String TMPDIR = "java.io.tmpdir";
    private static final String USER_HOME = "user.home";
    private final File cacheDirectory;
    private final File settingsDirectory;
    private final File workingDirectory;

    public static WorkingDirectories fromConfig(Config config) throws IOException {
        File file = WorkingDirectories.workingDirectoryFromConfig(config);
        File file2 = WorkingDirectories.cacheDirectoryFromWorkingDirectory(file);
        File file3 = WorkingDirectories.settingsDirectoryFromWorkingDirectory(file);
        return new WorkingDirectories(file2, file3, file);
    }

    private static File workingDirectoryFromConfig(Config config) throws IOException {
        String string = WorkingDirectories.getDefaultContrastDirPath();
        String string2 = config.getOrNull(ConfigProperty.WORKING_DIR);
        if (string2 != null) {
            string = string2;
        }
        return WorkingDirectories.createAndObtainDirectory(new File(string), "working");
    }

    public static String getDefaultContrastDirPath() {
        String string = l.b(USER_HOME);
        return WorkingDirectories.getDefaultContrastDirPath(string);
    }

    static String getDefaultContrastDirPath(String string) {
        return string + File.separatorChar + SETTINGS + File.separatorChar;
    }

    static File settingsDirectoryFromWorkingDirectory(File file) throws IOException {
        String string = l.b(TMPDIR);
        return WorkingDirectories.settingsDirectoryFromWorkingDirectory(file, string);
    }

    static File settingsDirectoryFromWorkingDirectory(File file, String string) throws IOException {
        String string2 = !file.exists() ? WorkingDirectories.getDefaultContrastDirPath(string) : file.getPath();
        File file2 = new File(string2);
        try {
            AccessController.doPrivileged(() -> {
                boolean bl2 = file2.exists();
                if (!bl2) {
                    file2.mkdirs();
                } else if (file2.isFile()) {
                    boolean bl3 = file2.delete();
                    if (!bl3) {
                        throw new IOException("Couldn't delete " + file2.getAbsolutePath() + " file where Contrast data directory should be");
                    }
                    if (!file2.mkdirs()) {
                        throw new IOException("Couldn't create " + file2.getAbsolutePath() + " directory. Maybe use -Dcontrast.dir=<some writeable directory>");
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwables.throwIfCritical(privilegedActionException);
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            throw Throwables.propagate(privilegedActionException2, IOException.class);
        }
        return file2;
    }

    private static File cacheDirectoryFromWorkingDirectory(File file) throws IOException {
        return WorkingDirectories.createAndObtainDirectory(new File(file, "cache"), "cache");
    }

    private static File createAndObtainDirectory(File file, String string) throws IOException {
        if ((file.exists() || file.mkdirs()) && file.canWrite()) {
            return file;
        }
        throw new IOException("Can't promise read/write on " + string + " directory");
    }

    private WorkingDirectories(File file, File file2, File file3) {
        this.cacheDirectory = file;
        this.settingsDirectory = file2;
        this.workingDirectory = file3;
    }

    public File cacheDirectory() {
        return this.cacheDirectory;
    }

    public File settingsDirectory() {
        return this.settingsDirectory;
    }

    public File workingDirectory() {
        return this.workingDirectory;
    }
}

