/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.contrastapi_v1_0;

import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public enum StandardRequestMethod implements RequestMethod
{
    ALL,
    CONNECT,
    DELETE,
    GET,
    HEAD,
    OPTIONS,
    PATCH,
    POST,
    PUT,
    TRACE,
    UNARY,
    CLIENTSTREAM,
    SERVERSTREAM,
    BIDISTREAM,
    WEBSOCKET,
    PROPFIND,
    PROPPATCH,
    MKCOL,
    COPY,
    MOVE,
    LOCK,
    UNLOCK,
    VERSION_CONTROL("VERSION-CONTROL"),
    REPORT,
    CHECKOUT,
    CHECKIN,
    UNCHECKOUT,
    MKWORKSPACE,
    UPDATE,
    LABEL,
    MERGE,
    BASELINE_CONTROL("BASELINE-CONTROL"),
    MKACTIVITY,
    ORDERPATCH,
    ACL,
    SEARCH,
    MKCALENDAR;

    private final String name;
    static final RequestMethodMap REQUEST_METHOD_MAP;

    private StandardRequestMethod(String string2) {
        this.name = string2;
    }

    private StandardRequestMethod() {
        this.name = this.name();
    }

    @Override
    public String methodName() {
        return this.name;
    }

    @Override
    public boolean isUnknownHeader() {
        return false;
    }

    public String toString() {
        return this.methodName();
    }

    static {
        REQUEST_METHOD_MAP = new RequestMethodMap();
    }

    @o
    static final class RequestMethodMap {
        private final Map<String, RequestMethod> map = new ConcurrentSkipListMap<String, RequestMethod>(String.CASE_INSENSITIVE_ORDER);

        RequestMethodMap() {
            for (StandardRequestMethod standardRequestMethod : StandardRequestMethod.values()) {
                this.map.put(standardRequestMethod.methodName(), standardRequestMethod);
            }
        }

        @o
        int size() {
            return this.map.size();
        }

        @o
        RequestMethod remove(String string) {
            return this.map.remove(string);
        }

        @o
        Set<String> keySet() {
            return this.map.keySet();
        }

        RequestMethod of(final String string) {
            String string3 = string == null ? "" : string;
            RequestMethod requestMethod = this.map.get(string3);
            if (requestMethod != null) {
                return requestMethod;
            }
            return this.map.computeIfAbsent(StringUtils.trimToEmpty(string), string2 -> new RequestMethod(){

                @Override
                public String methodName() {
                    return StringUtils.trimToNull(string);
                }

                @Override
                public boolean isUnknownHeader() {
                    return true;
                }
            });
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

