/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.java.b;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.core.a;
import com.contrastsecurity.agent.core.c;
import com.contrastsecurity.agent.d;
import com.contrastsecurity.agent.j.g;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.startup.A;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.w;
import com.contrastsecurity.agent.startup.x;
import com.contrastsecurity.agent.startup.y;
import com.contrastsecurity.agent.t.e;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.C2Compiler;
import com.contrastsecurity.agent.util.F;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.O;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.agent.util.k;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@DontObfuscate
public class ContrastEngine
implements PluginManager {
    private final PluginManager pluginManager;
    private d transformer;
    private final f legacyReportingService;
    private com.contrastsecurity.agent.services.a compositeServices;
    private final List<com.contrastsecurity.agent.services.a> injectedBackgroundServices;
    private final Instrumentation inst;
    private final Config config;
    private final com.contrastsecurity.agent.services.b executorServiceModule;
    private final Clock clock;
    private final WorkingDirectories directories;
    private final c failureStrategy;
    private final com.contrastsecurity.agent.h.b environmentInfo;
    private final Queue<b> classLoadEvents;
    private final com.contrastsecurity.agent.logging.c loggerManager;
    private final o errorEmitter;
    private final com.contrastsecurity.agent.telemetry.c startupMetricReporter;
    private final g hierarchyCache;
    private final List<x> startupTasks;
    private final TelemetryMetrics metrics;
    private final com.contrastsecurity.agent.i.a errorHandler;
    private final C2Compiler c2Compiler;
    private static final Logger logger = LoggerFactory.getLogger(ContrastEngine.class);

    @Override
    public List<ContrastPlugin> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public void forEachEnabled(ContrastContext contrastContext, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachEnabled(contrastContext, consumer);
    }

    @Override
    public void forEachDisabled(ContrastContext contrastContext, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachDisabled(contrastContext, consumer);
    }

    public o getErrorEmitter() {
        return this.errorEmitter;
    }

    public ContrastEngine(Instrumentation instrumentation, com.contrastsecurity.agent.h.b b2, Config config, List<x> list, Clock clock, List<com.contrastsecurity.agent.services.a> list2, PluginManager pluginManager, f f2, WorkingDirectories workingDirectories, TelemetryMetrics telemetryMetrics, o o2, Queue<b> queue, com.contrastsecurity.agent.logging.c c2, com.contrastsecurity.agent.services.b b3, com.contrastsecurity.agent.telemetry.c c3, g g2, com.contrastsecurity.agent.i.a a2, C2Compiler c2Compiler) {
        this.inst = Objects.requireNonNull(instrumentation);
        this.environmentInfo = Objects.requireNonNull(b2);
        this.config = Objects.requireNonNull(config);
        this.startupTasks = Lists.copy((Collection)Objects.requireNonNull(list));
        this.injectedBackgroundServices = list2;
        this.clock = Objects.requireNonNull(clock);
        this.pluginManager = Objects.requireNonNull(pluginManager);
        this.executorServiceModule = Objects.requireNonNull(b3);
        this.legacyReportingService = Objects.requireNonNull(f2);
        this.directories = Objects.requireNonNull(workingDirectories);
        this.metrics = Objects.requireNonNull(telemetryMetrics);
        this.classLoadEvents = Objects.requireNonNull(queue);
        this.loggerManager = Objects.requireNonNull(c2);
        this.errorEmitter = Objects.requireNonNull(o2);
        this.failureStrategy = c.a(config.get(ConfigProperty.STARTUP_FAILURE_STRATEGY));
        this.startupMetricReporter = Objects.requireNonNull(c3);
        this.hierarchyCache = Objects.requireNonNull(g2);
        this.errorHandler = Objects.requireNonNull(a2);
        this.c2Compiler = Objects.requireNonNull(c2Compiler);
    }

    public synchronized void start(StartupTiming startupTiming) throws FatalStartupException {
        Objects.requireNonNull(startupTiming);
        F f2 = G.b();
        Contrast.starting(this.directories);
        w w2 = this.startupContext();
        w2.a(this.errorHandler);
        f2.b();
        this.startupMetricReporter.a(PerfUtil.a.a, "init-working-dir", f2);
        f2.c();
        try {
            for (x x2 : this.startupTasks) {
                f2.a();
                x2.onStartupBegin(w2);
                f2.b();
                this.startupMetricReporter.a(PerfUtil.a.a, x2.getTaskName(), f2);
            }
        }
        catch (FatalStartupException fatalStartupException) {
            this.errorAndPointToLog();
            logger.error("Problem starting up Contrast", fatalStartupException);
            logger.error(this.failureStrategy.b());
            PreConfigUtil.err(this.failureStrategy.b());
            this.failureStrategy.a(fatalStartupException);
            this.ifWebSphereAddFallbackTransformer(w2);
            return;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            this.logUnexpectedError(throwable2, this.failureStrategy.b());
            this.failureStrategy.a(throwable2);
            return;
        }
        this.transformer = w2.a();
        try {
            f2.c();
            this.initBackgroundServicesAndRegisterPlugins(f2, startupTiming);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable3 = throwable;
            PreConfigUtil.err("Error reading Contrast configuration or policy. Are you sure your XML is right? " + this.failureStrategy.b());
            this.failureStrategy.a(throwable3);
            throwable3.printStackTrace(System.err);
            return;
        }
        PreConfigUtil.out("Contrast engine started.");
        logger.info("Contrast engine started.");
    }

    private void ifWebSphereAddFallbackTransformer(w w2) {
        d d2 = w2.a();
        if (d2 == null && y.a(this.environmentInfo)) {
            logger.debug("Running in WebSphere, PhoneHome to TeamServer failed, attempting to add fallback transformer");
            try {
                this.addWebSphereFallBackTransformer(w2);
                logger.debug("Added WebSphereFallbackTransformer");
                new A(this.errorEmitter, this.inst).onStartupBegin(w2);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                logger.warn("Unable to prepare to correct disabled TLS algorithms in WebSphere", exception2);
            }
        }
    }

    private void addWebSphereFallBackTransformer(w w2) {
        new com.contrastsecurity.agent.plugins.frameworks.websphere.a.a(this.config, this.environmentInfo, this.hierarchyCache, this.classLoadEvents, this.errorEmitter, this.inst, w2).a();
    }

    private w startupContext() {
        w w2 = new w();
        w2.a(this);
        return w2;
    }

    private void logUnexpectedError(Throwable throwable, String string) {
        this.errorAndPointToLog();
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        PreConfigUtil.err("Unexpected error starting up. " + string + " Exception message [1]: " + string2);
        throwable.printStackTrace(System.err);
        PreConfigUtil.out("Unexpected error starting up. " + string + " Exception message [2]:  " + string2);
    }

    private void initBackgroundServicesAndRegisterPlugins(F f2, StartupTiming startupTiming) {
        logger.info("Installing Contrast plugins...");
        f2.a();
        ArrayList<com.contrastsecurity.agent.services.a> arrayList = new ArrayList<com.contrastsecurity.agent.services.a>(this.injectedBackgroundServices);
        if (JVMUtils.isIBMJVM()) {
            logger.info("On IBM JVM, adding zombie watcher thread.");
            arrayList.add(new com.contrastsecurity.agent.services.f(this.config, Suppliers.constant(this), this.errorEmitter, this.executorServiceModule));
        }
        this.compositeServices = new a(this.config, arrayList, this.clock);
        this.compositeServices.start(this.inst, this.pluginManager.getPlugins());
        this.pluginManager.handoffToJVM();
        this.sendServerInfoUpdate();
        startupTiming.premainEndTimeNs(this.clock.nanoTime());
        long l2 = startupTiming.premainElapsedTimeMs();
        f2.b();
        this.startupMetricReporter.a(PerfUtil.a.a, "init-services-plugins", f2);
        PerfUtil.printStartupTimingMessage(String.format("All Startup Tasks: %s", k.a(l2)));
        logger.info("Beginning application...");
        PreConfigUtil.out("Starting JVM [" + l2 + "ms]");
        this.startupMetricReporter.b("startupTimeAgent", l2);
        this.metrics.scheduleStartupReporting(this.executorServiceModule.b(), this.config.getLong(ConfigProperty.AGENT_TELEMETRY_INITIAL_DELAY), this.startupMetricReporter);
        this.c2Compiler.reEnableC2CompilationIfNecessary(this.executorServiceModule.a(), this.config.getLong(ConfigProperty.DELAYED_C2_COMPILATION_TIMEOUT_MS));
        Contrast.active(this.directories);
    }

    private void sendServerInfoUpdate() {
        e e2 = new e(null, true);
        this.legacyReportingService.a(e2);
    }

    private void errorAndPointToLog() {
        String string = this.config.get(ConfigProperty.LOGGER_LOCATION);
        PreConfigUtil.err("Contrast not enabled. Check log for details - " + string);
    }

    public synchronized void stop() {
        logger.info("Stopping Contrast...");
        Contrast.stopping(this.directories);
        if (this.compositeServices != null) {
            this.compositeServices.stop();
        }
        this.pluginManager.deactivatePlugins();
        this.executorServiceModule.close();
        Contrast.inactive(this.directories);
        logger.info("Stopped");
        this.loggerManager.a(this.config.getLong(ConfigProperty.LOGGER_SHUTDOWN_TIMEOUT), TimeUnit.SECONDS);
    }

    public void deinstrument() {
        this.transformer.b();
        List<Class<?>> list = Arrays.stream(this.inst.getAllLoadedClasses()).filter(this.inst::isModifiableClass).collect(Collectors.toList());
        logger.info("De-instrumenting {} classes", (Object)list.size());
        O.a(this.inst, this.errorEmitter, list);
    }

    @Override
    public void registerPlugin(ContrastPlugin contrastPlugin) {
        this.pluginManager.registerPlugin(contrastPlugin);
    }

    @Override
    public void activatePlugins() {
        this.pluginManager.activatePlugins();
    }

    @Override
    public void deactivatePlugins() {
        this.pluginManager.deactivatePlugins();
    }

    @Override
    public void handoffToJVM() {
        this.pluginManager.handoffToJVM();
    }

    @Override
    public List<com.contrastsecurity.agent.instr.a.c> getDenylistAwarePlugins() {
        return this.pluginManager.getDenylistAwarePlugins();
    }
}

