/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.logging.log4j2.plugins;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.SimpleSleeper;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.commons.g;
import com.contrastsecurity.agent.commons.h;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsLoggerDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsDTM;
import com.contrastsecurity.agent.core.ContrastVersion;
import com.contrastsecurity.agent.e.d;
import com.contrastsecurity.agent.e.e;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.util.t;
import com.contrastsecurity.thirdparty.cggl.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.cggl.protobuf.CodedOutputStream;
import com.contrastsecurity.thirdparty.cggl.protobuf.UnknownFieldSet;
import com.contrastsecurity.thirdparty.iot.proto.collector.logs.v1.ExportLogsPartialSuccess;
import com.contrastsecurity.thirdparty.iot.proto.collector.logs.v1.ExportLogsServiceRequest;
import com.contrastsecurity.thirdparty.iot.proto.collector.logs.v1.ExportLogsServiceResponse;
import com.contrastsecurity.thirdparty.iot.proto.common.v1.AnyValue;
import com.contrastsecurity.thirdparty.iot.proto.common.v1.KeyValue;
import com.contrastsecurity.thirdparty.iot.proto.logs.v1.LogRecord;
import com.contrastsecurity.thirdparty.iot.proto.logs.v1.ResourceLogs;
import com.contrastsecurity.thirdparty.iot.proto.logs.v1.ScopeLogs;
import com.contrastsecurity.thirdparty.iot.proto.logs.v1.SeverityNumber;
import com.contrastsecurity.thirdparty.iot.proto.resource.v1.Resource;
import com.contrastsecurity.thirdparty.oa4j.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.http.Header;
import com.contrastsecurity.thirdparty.oa4j.http.HeaderElement;
import com.contrastsecurity.thirdparty.oa4j.http.HttpEntity;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpPost;
import com.contrastsecurity.thirdparty.oa4j.http.entity.AbstractHttpEntity;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AsyncAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.LoggerType;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.StandardLevel;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

@Plugin(name="OtelAppender", category="Core", elementType="appender")
@DontObfuscate
public final class OtelAppender
extends AbstractAppender
implements h {
    @o
    public static final int MAX_CONSECUTIVE_FAILURES = 10;
    private static final String ASYNC_APPENDER_PREFIX = LoggerType.CONTRAST_DIAGNOSTICS_LOGGER.name() + ".";
    private static final String SYNC_APPENDER_PREFIX = LoggerType.CONTRAST_DIAGNOSTICS_LOGGER.name() + ".sync" + ".";
    private static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";
    private static final AtomicInteger UNIQUE_INDEX = new AtomicInteger(0);
    private static final AtomicBoolean SHUTDOWN_DUE_TO_ERRORS = new AtomicBoolean(false);
    private final Configuration log4j2Configuration;
    private final ConfigUpdatable contrastConfig;
    private final String parentAppenderName;
    private final long backoffFactorMs;
    private final long maxTotalBackoffMs;
    private final int maxBatchSize;
    private final long batchTimeoutMs;
    private final com.contrastsecurity.agent.e.d httpClient;
    private final g sleeper;
    private final t jitter;
    private final LogEvent[] batchedMessages;
    private final ExportLogsServiceRequest.Builder requestBodyBuilder;
    private final ScopeLogs.Builder logMessageBuilder;
    private final HttpPost request;
    private final c reponseBodyBuffer;
    private final d requestBody;
    private int batchedMessagesCount;
    private int consecutiveFailures;
    private static final UnknownFieldSet EMPTY_UNKNOWN_FIELD_SET;
    private static final ScopeLogs EMPTY;

    @o
    OtelAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl2, Property[] propertyArray, Configuration configuration, ConfigUpdatable configUpdatable, String string2, String string3, String string4, String string5, long l2, long l3, int n2, long l4, com.contrastsecurity.agent.e.d d2, g g2, t t2) {
        super(string, filter, layout, bl2, propertyArray);
        this.log4j2Configuration = Objects.requireNonNull(configuration);
        this.contrastConfig = Objects.requireNonNull(configUpdatable);
        Objects.requireNonNull(string2);
        this.parentAppenderName = Preconditions.checkNotEmpty(string4);
        Preconditions.checkNotEmpty(string5);
        Preconditions.check(l2 > 0L, "backoffFactorMs must be greater than 0.");
        this.backoffFactorMs = l2;
        Preconditions.check(l3 > 0L, "maxTotalBackoffMs must be greater than 0.");
        this.maxTotalBackoffMs = l3;
        Preconditions.check(n2 > 0, "maxBatchSize must be greater than 0.");
        this.maxBatchSize = n2;
        Preconditions.check(l4 > 0L, "batchTimeoutMs must be greater than 0.");
        this.batchTimeoutMs = l4;
        this.httpClient = Objects.requireNonNull(d2);
        this.sleeper = Objects.requireNonNull(g2);
        this.jitter = Objects.requireNonNull(t2);
        this.batchedMessages = new LogEvent[n2];
        HttpPost httpPost = new HttpPost(string5 + "/agents/v2.0/diagnostics/logs");
        com.contrastsecurity.agent.e.d.a(httpPost, (Config)configUpdatable, com.contrastsecurity.agent.e.d.a(configUpdatable));
        this.reponseBodyBuffer = new c();
        d d3 = new d(new c(), PROTOBUF_CONTENT_TYPE);
        httpPost.setEntity(d3);
        httpPost.setHeader("Content-Type", PROTOBUF_CONTENT_TYPE);
        this.requestBody = d3;
        this.request = httpPost;
        AnyValue.Builder builder = AnyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET);
        ExportLogsServiceRequest.Builder builder2 = ExportLogsServiceRequest.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET);
        builder2.addResourceLogsBuilder(0).setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setResource(Resource.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("server.name").setValue(builder.setStringValue(string2).build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("diagnostics.uuid").setValue(builder.setStringValue(string3).build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("service.name").setValue(builder.setStringValue("contrast_agent:java").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("telemetry.sdk.language").setValue(builder.setStringValue("java").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("telemetry.sdk.name").setValue(builder.setStringValue("contrast.opentelemetry.java").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("telemetry.sdk.version").setValue(builder.setStringValue(ContrastVersion.VERSION).build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).setKey("contrast.agent.version").setValue(builder.setStringValue(ContrastVersion.VERSION).build()).build()).build());
        this.requestBodyBuilder = builder2;
        ScopeLogs.Builder builder3 = ScopeLogs.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET);
        builder3.getScopeBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET);
        LogRecord.Builder builder4 = builder3.addLogRecordsBuilder(0);
        builder4.setUnknownFields(EMPTY_UNKNOWN_FIELD_SET);
        builder4.getBodyBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET);
        ResourceLogs.Builder builder5 = builder2.getResourceLogsBuilder(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            builder5.addScopeLogs(i2, EMPTY);
        }
        this.logMessageBuilder = builder3;
    }

    public static long newIndex() {
        return UNIQUE_INDEX.getAndIncrement();
    }

    public static String asyncName(long l2) {
        return ASYNC_APPENDER_PREFIX + l2;
    }

    public static String syncName(long l2) {
        return SYNC_APPENDER_PREFIX + l2;
    }

    public static boolean shutdownDueToErrors() {
        return SHUTDOWN_DUE_TO_ERRORS.get();
    }

    private static <T> T getOrDefault(Config config, ConfigProperty configProperty, Supplier<T> supplier, Class<T> clazz) {
        String string = config.getOrNull(configProperty);
        if (string == null) {
            return supplier.get();
        }
        try {
            return clazz.cast(Class.forName(string, true, OtelAppender.class.getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalArgumentException("Failed to create instance of " + string + ". Does it have a default, no-args constructor?", reflectiveOperationException2);
        }
    }

    @Override
    public void append(LogEvent logEvent) {
        Object object;
        if (OtelAppender.isShutdownDueToConsecutiveErrors(this.consecutiveFailures)) {
            return;
        }
        if (!this.isStarted() && !this.isStopping()) {
            return;
        }
        ResourceLogs.Builder builder = this.requestBodyBuilder.getResourceLogsBuilder(0);
        if (!logEvent.isEndOfBatch()) {
            this.batchedMessages[this.batchedMessagesCount] = logEvent.toImmutable();
            ++this.batchedMessagesCount;
            if (this.batchedMessagesCount < this.maxBatchSize) {
                return;
            }
        }
        if (this.batchedMessagesCount == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.batchedMessagesCount; ++i2) {
            object = this.batchedMessages[i2];
            this.logMessageBuilder.getScopeBuilder().setName(object.getLoggerName());
            this.logMessageBuilder.getLogRecordsBuilder(0).setTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(object.getTimeMillis())).setObservedTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(object.getTimeMillis())).setSeverityNumber(OtelAppender.level(object.getLevel().getStandardLevel())).setSeverityText(object.getLevel().name()).getBodyBuilder().setStringValue(object.getMessage().getFormattedMessage());
            builder.setScopeLogs(i2, this.logMessageBuilder.build());
            this.batchedMessages[i2] = null;
        }
        while (this.batchedMessagesCount < this.maxBatchSize) {
            builder.setScopeLogs(this.batchedMessagesCount, EMPTY);
            ++this.batchedMessagesCount;
        }
        this.batchedMessagesCount = 0;
        ExportLogsServiceRequest exportLogsServiceRequest = this.requestBodyBuilder.build();
        this.requestBody.a.a(exportLogsServiceRequest.getSerializedSize());
        try {
            exportLogsServiceRequest.writeTo(CodedOutputStream.newInstance(this.requestBody.a.b, 0, this.requestBody.a.c));
        }
        catch (IOException iOException) {
            b.a.debug("Unexpected error writing request to byte buffer.", iOException);
            Assert.fail("Unexpected error writing request to byte buffer.", iOException);
        }
        object = this.httpClient.a(this.request, httpResponse -> {
            ExportLogsServiceResponse exportLogsServiceResponse;
            block13: {
                InputStream inputStream;
                long l2;
                block11: {
                    ExportLogsServiceResponse exportLogsServiceResponse2;
                    block12: {
                        HttpEntity httpEntity = httpResponse.getEntity();
                        if (httpEntity == null) {
                            return null;
                        }
                        Header header = httpEntity.getContentType();
                        if (header == null) {
                            return null;
                        }
                        HeaderElement[] headerElementArray = header.getElements();
                        if (headerElementArray == null || headerElementArray.length == 0) {
                            return null;
                        }
                        String string = headerElementArray[0].getName();
                        if (!PROTOBUF_CONTENT_TYPE.equals(string)) {
                            return null;
                        }
                        l2 = httpEntity.getContentLength();
                        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
                            return null;
                        }
                        inputStream = httpEntity.getContent();
                        try {
                            if (inputStream != null) break block11;
                            exportLogsServiceResponse2 = null;
                            if (inputStream == null) break block12;
                        }
                        catch (Throwable throwable) {
                            Throwables.throwIfCritical(throwable);
                            Throwable throwable2 = throwable;
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    Throwables.throwIfCritical(throwable3);
                                    Throwable throwable4 = throwable3;
                                    throwable2.addSuppressed(throwable4);
                                }
                            }
                            throw throwable2;
                        }
                        inputStream.close();
                    }
                    return exportLogsServiceResponse2;
                }
                this.reponseBodyBuffer.a((int)l2);
                IOUtils.readFully(inputStream, this.reponseBodyBuffer.b, 0, this.reponseBodyBuffer.c);
                exportLogsServiceResponse = ExportLogsServiceResponse.parseFrom(CodedInputStream.newInstance(this.reponseBodyBuffer.b, 0, this.reponseBodyBuffer.c));
                if (inputStream == null) break block13;
                inputStream.close();
            }
            return exportLogsServiceResponse;
        }, this.backoffFactorMs, this.maxTotalBackoffMs, this.jitter, this.sleeper);
        if (d.b.b.a != ((d.b)object).a()) {
            b.a.debug("Otel log request failed with response code: {}", (Object)((d.b)object).b(), (Object)((d.b)object).e());
            ++this.consecutiveFailures;
            if (OtelAppender.isShutdownDueToConsecutiveErrors(this.consecutiveFailures)) {
                this.stopImmediately();
            }
            return;
        }
        ExportLogsServiceResponse exportLogsServiceResponse = (ExportLogsServiceResponse)((d.b)object).d();
        this.consecutiveFailures = 0;
        if (exportLogsServiceResponse == null) {
            b.a.debug("Otel log request succeeded with no response body.");
            return;
        }
        if (!exportLogsServiceResponse.hasPartialSuccess()) {
            return;
        }
        ExportLogsPartialSuccess exportLogsPartialSuccess = exportLogsServiceResponse.getPartialSuccess();
        if (exportLogsPartialSuccess == null || exportLogsPartialSuccess == ExportLogsPartialSuccess.getDefaultInstance()) {
            return;
        }
        String string = exportLogsPartialSuccess.getErrorMessage();
        long l2 = exportLogsPartialSuccess.getRejectedLogRecords();
        if (StringUtils.isEmpty(string) && l2 < 1L) {
            return;
        }
        b.a.debug("Otel log request partially failed. {} Rejected {} logs.", (Object)string, (Object)l2);
    }

    private static boolean isShutdownDueToConsecutiveErrors(int n2) {
        return n2 >= 10;
    }

    private static void close(String string, Closeable closeable) {
        try {
            Objects.requireNonNull(closeable).close();
        }
        catch (IOException iOException) {
            b.a.debug("Failed to close {} for diagnostic logger.", (Object)string, (Object)iOException);
        }
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        boolean bl2 = super.stop(l2, timeUnit);
        OtelAppender.close("client", this.httpClient);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @o
    void stopImmediately() {
        b.a.debug("Disabling Otel log collection due to {} consecutive failures.", (Object)this.consecutiveFailures);
        this.contrastConfig.updateServerSettings(OtelAppender::disableDiagnosticsLogger);
        SHUTDOWN_DUE_TO_ERRORS.set(true);
        super.stop(1L, TimeUnit.NANOSECONDS);
        Thread.currentThread().interrupt();
        try {
            this.log4j2Configuration.getAppenders().remove(this.getName());
            this.log4j2Configuration.getLoggerContext().getRootLogger().removeAppender(this);
            Appender appender = this.log4j2Configuration.getAppenders().remove(this.parentAppenderName);
            if (appender == null) {
                return;
            }
            this.log4j2Configuration.getLoggerContext().getRootLogger().removeAppender(appender);
            if (!(appender instanceof AsyncAppender)) {
                throw new IllegalStateException("Unable to stop async appender thread.");
            }
            Reflect reflect = Reflect.reflect(appender, b.a).invoke("setStopped").asVoid();
            if (reflect.hasError()) {
                throw new IllegalStateException("Unable to stop async appender thread: " + (Object)((Object)reflect.error()), reflect.caughtException());
            }
            Collection collection = reflect.reset(appender).field("dispatcher").field("queue").asNullable(Collection.class);
            if (reflect.hasError()) {
                throw new IllegalStateException("Unable to stop async appender thread: " + (Object)((Object)reflect.error()), reflect.caughtException());
            }
            collection.clear();
        }
        finally {
            OtelAppender.close("client", this.httpClient);
        }
    }

    public static ServerSettingsDTM disableDiagnosticsLogger(ServerSettingsDTM serverSettingsDTM) {
        if (serverSettingsDTM == null) {
            serverSettingsDTM = new ServerSettingsDTM().setDiagnostics(new DiagnosticsDTM().setDiagnosticsLogger(new DiagnosticsLoggerDTM()));
        }
        serverSettingsDTM.getDiagnostics().getDiagnosticsLogger().setEnabled(false);
        return serverSettingsDTM;
    }

    @Override
    public long timeoutMs() {
        return this.batchTimeoutMs;
    }

    private static SeverityNumber level(StandardLevel standardLevel) {
        switch (standardLevel) {
            case OFF: {
                return SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED;
            }
            case FATAL: {
                return SeverityNumber.SEVERITY_NUMBER_FATAL;
            }
            case ERROR: {
                return SeverityNumber.SEVERITY_NUMBER_ERROR;
            }
            case WARN: {
                return SeverityNumber.SEVERITY_NUMBER_WARN;
            }
            case INFO: {
                return SeverityNumber.SEVERITY_NUMBER_INFO;
            }
            case TRACE: 
            case ALL: {
                return SeverityNumber.SEVERITY_NUMBER_TRACE;
            }
        }
        return SeverityNumber.SEVERITY_NUMBER_DEBUG;
    }

    @PluginBuilderFactory
    public static <B extends a<B>> B builder() {
        return (B)((a)new a().asBuilder());
    }

    static {
        try {
            Constructor constructor = UnknownFieldSet.class.getDeclaredConstructor(TreeMap.class);
            constructor.setAccessible(true);
            EMPTY_UNKNOWN_FIELD_SET = (UnknownFieldSet)constructor.newInstance(Maps.emptyTreeMap());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new RuntimeException(reflectiveOperationException2);
        }
        EMPTY = ScopeLogs.newBuilder().setUnknownFields(EMPTY_UNKNOWN_FIELD_SET).buildPartial();
    }

    private static final class b {
        private static final Logger a = LoggerFactory.getLogger(OtelAppender.class);

        private b() {
        }
    }

    public static final class a<B extends a<B>>
    extends AbstractAppender.Builder<B>
    implements Builder<OtelAppender> {
        @PluginBuilderAttribute(value="uuid")
        private String a;
        @PluginBuilderAttribute(value="parentAppenderName")
        private String b;
        @PluginBuilderAttribute(value="teamserverUrl")
        private String c;
        @PluginBuilderAttribute(value="timeoutMs")
        private int d;
        @PluginBuilderAttribute(value="backoffFactorMs")
        private long e;
        @PluginBuilderAttribute(value="maxTotalBackoffMs")
        private long f;
        @PluginBuilderAttribute(value="maxBatchSize")
        private int g;
        @PluginBuilderAttribute(value="batchTimeoutMs")
        private long h;

        public a<B> a(String string) {
            this.a = Preconditions.checkNotEmpty(string);
            return this;
        }

        public a<B> b(String string) {
            this.b = string;
            return this;
        }

        public a<B> c(String string) {
            this.c = string;
            return this;
        }

        public a<B> a(int n2) {
            this.d = n2;
            return this;
        }

        public a<B> a(long l2) {
            this.e = l2;
            return this;
        }

        public a<B> b(long l2) {
            this.f = l2;
            return this;
        }

        public a<B> b(int n2) {
            this.g = n2;
            return this;
        }

        public a<B> c(long l2) {
            this.h = l2;
            return this;
        }

        public OtelAppender a() {
            Configuration configuration = this.getConfiguration();
            if (!(configuration instanceof com.contrastsecurity.agent.logging.b)) {
                throw new IllegalArgumentException("Log4j2 configuration must be an instance of " + com.contrastsecurity.agent.logging.b.class.getTypeName());
            }
            com.contrastsecurity.agent.logging.b b2 = (com.contrastsecurity.agent.logging.b)((Object)configuration);
            ConfigUpdatable configUpdatable = b2.a();
            com.contrastsecurity.agent.h.b b3 = b2.b();
            Preconditions.check(this.d > 0, "timeoutMs must be greater than 0.");
            com.contrastsecurity.agent.e.d d2 = com.contrastsecurity.agent.e.e.a(configUpdatable).a(this.c).a(this.d).a(b3).b();
            g g2 = (g)OtelAppender.getOrDefault(configUpdatable, ConfigProperty.OTEL_SLEEPER_CLASS, SimpleSleeper::new, g.class);
            t t2 = (t)OtelAppender.getOrDefault(configUpdatable, ConfigProperty.OTEL_JITTER_CLASS, Suppliers.constant(t.a), t.class);
            return new OtelAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray(), configuration, configUpdatable, StringUtils.trimToEmpty(b3.f()), this.a, this.b, this.c, this.e, this.f, this.g, this.h, d2, g2, t2);
        }

        @Override
        public /* synthetic */ Object build() {
            return this.a();
        }
    }

    private static final class d
    extends AbstractHttpEntity {
        private final c a;

        private d(c c2, String string) {
            this.setContentType(Preconditions.checkNotEmpty(string));
            this.a = Objects.requireNonNull(c2);
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public long getContentLength() {
            return this.a.c;
        }

        @Override
        public InputStream getContent() {
            return this.a.d;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            Objects.requireNonNull(outputStream);
            outputStream.write(this.a.b, 0, this.a.c);
            outputStream.flush();
        }

        @Override
        public boolean isStreaming() {
            return false;
        }
    }

    private static final class c {
        private static final int a = 4096;
        private byte[] b;
        private int c;
        private ByteArrayInputStream d;

        private c() {
        }

        private void a(int n2) {
            if (this.b == null || n2 > this.b.length) {
                int n3;
                for (n3 = 4096; n3 < n2; n3 += 4096) {
                }
                this.b = new byte[n3];
                this.d = new ByteArrayInputStream(this.b);
            } else {
                this.d.reset();
            }
            this.c = n2;
        }
    }
}

