/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.mq;

import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.messages.mq.ApplicationAnalyticDTM;
import com.contrastsecurity.agent.messages.mq.ScreenerApplication;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class VulnerabilityDTM
extends ApplicationAnalyticDTM {
    private final long hash;
    private final String ruleId;
    private final String evidence;
    private final HttpRequestDTM request;
    private final Map<PropertyKey, String> properties;
    private final List<EventDTM> events;

    private VulnerabilityDTM(Builder builder) {
        super(builder.app);
        this.hash = builder.hash;
        this.ruleId = builder.ruleId;
        this.evidence = builder.evidence;
        this.request = builder.request;
        this.properties = builder.properties;
        this.events = builder.events;
    }

    public long getHash() {
        return this.hash;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public HttpRequestDTM getRequest() {
        return this.request;
    }

    public Map<PropertyKey, String> getProperties() {
        return this.properties;
    }

    public List<EventDTM> getEvents() {
        return this.events;
    }

    public String toString() {
        return "VulnerabilityDTM{hash=" + this.hash + ", ruleId='" + this.ruleId + '\'' + ", evidence='" + this.evidence + '\'' + ", request=" + this.request + ", properties=" + this.properties + ", events=" + this.events.stream().map(eventDTM -> "\n\t--> " + eventDTM.toString()).collect(Collectors.toList()) + '}';
    }

    public static final class Builder {
        private long hash;
        private String ruleId;
        private String evidence;
        private HttpRequestDTM request;
        private Map<PropertyKey, String> properties;
        private List<EventDTM> events;
        private ScreenerApplication app;

        public Builder(String string, ScreenerApplication screenerApplication) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(screenerApplication);
            this.ruleId = string;
            this.app = screenerApplication;
        }

        public Builder hash(long l2) {
            this.hash = l2;
            return this;
        }

        public Builder evidence(String string) {
            this.evidence = string;
            return this;
        }

        public Builder request(HttpRequestDTM httpRequestDTM) {
            this.request = httpRequestDTM;
            return this;
        }

        public Builder properties(Map<PropertyKey, String> map) {
            this.properties = map;
            return this;
        }

        public Builder events(List<EventDTM> list) {
            this.events = list;
            return this;
        }

        public Builder app(ScreenerApplication screenerApplication) {
            this.app = screenerApplication;
            return this;
        }

        public VulnerabilityDTM build() {
            if (this.evidence == null && this.properties == null && (this.events == null || this.events.isEmpty())) {
                throw new IllegalArgumentException("Vulnerability has no data");
            }
            return new VulnerabilityDTM(this);
        }
    }
}

