/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.graphql.assess;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.context.ApplicationExecutionContext;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.e;
import com.contrastsecurity.agent.plugins.security.j;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

@DontObfuscate
@m
public final class ContrastGraphQLAssessDispatcherImpl
implements ContrastGraphQLAssessDispatcher {
    private final e disabledRulesFilter;
    private final ProviderUtil providerUtil;
    private final j.b configurationHasher;
    private final Set<Integer> graphQLInstrumentationHashesSeen;
    private static final String GRAPHQL_BUILD_METHOD = "graphql.GraphQL$Builder.build";
    private static final String DEFAULT_FIELD_VISIBILITY_NAME = "graphql.schema.visibility.DefaultGraphqlFieldVisibility";
    private static final int RECURSION_DEPTH_LIMIT = 10;
    private static final String QUERY_COMPLEXITY_INSTR_NAME = "graphql.analysis.MaxQueryComplexityInstrumentation";
    private static final String QUERY_DEPTH_INSTR_NAME = "graphql.analysis.MaxQueryDepthInstrumentation";
    private static final String CHAIN_INSTR_NAME = "graphql.execution.instrumentation.ChainedInstrumentation";
    private static final String SCHEMA_PATTERN = "__.*";
    @o
    public static final ExecutionContext.Key<Boolean> ALREADY_REPORTED_INTROSPECTION = ExecutionContext.Key.create(Boolean.class);
    @o
    public static final ExecutionContext.Key<Boolean> ALREADY_REPORTED_FIELD_VISIBILITY = ExecutionContext.Key.create(Boolean.class);
    @o
    public static final ExecutionContext.Key<Boolean> ALREADY_REPORTED_DOS = ExecutionContext.Key.create(Boolean.class);
    private static final Logger logger = LoggerFactory.getLogger(ContrastGraphQLAssessDispatcherImpl.class);

    public ContrastGraphQLAssessDispatcherImpl(e e2, ProviderUtil providerUtil, j j2) {
        this.disabledRulesFilter = e2;
        this.providerUtil = providerUtil;
        this.configurationHasher = j2.a();
        this.graphQLInstrumentationHashesSeen = new HashSet<Integer>();
    }

    public void onIsIntrospectionEnabled(Object object, boolean bl2) {
        if (bl2) {
            this.reportVulnerability((ContrastContext)object, ALREADY_REPORTED_INTROSPECTION, "graphql-introspection", "graphql.introspection.Introspection.isIntrospectionEnabled");
        }
    }

    public void onGraphQLBuild(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        if (contrastContext.scope().inScope(ScopeType.ASSESS_SAMPLING)) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        Predicate<String> predicate = this.disabledRulesFilter.a(application);
        boolean bl2 = predicate.test("graphql-introspection");
        boolean bl3 = predicate.test("graphql-field-visibility");
        boolean bl4 = predicate.test("graphql-dos");
        if (bl2 && bl3 && bl4) {
            return;
        }
        Reflect reflect = Reflect.reflect(object2, logger);
        Object object3 = reflect.field("graphQLSchema").field("codeRegistry").field("fieldVisibility").asNullable(Object.class);
        ApplicationExecutionContext applicationExecutionContext = application.context();
        this.checkAndReportFieldVisibilityRule(bl3, object3, applicationExecutionContext, contrastContext);
        this.checkAndReportIntrospectionRule(bl2, object2, reflect, object3, applicationExecutionContext, contrastContext);
        this.checkAndReportDosRule(bl4, object2, reflect, applicationExecutionContext, contrastContext);
    }

    private void checkAndReportFieldVisibilityRule(boolean bl2, Object object, ApplicationExecutionContext applicationExecutionContext, ContrastContext contrastContext) {
        if (bl2 || object == null || applicationExecutionContext.get(ALREADY_REPORTED_FIELD_VISIBILITY) != null) {
            return;
        }
        if (DEFAULT_FIELD_VISIBILITY_NAME.equals(object.getClass().getName())) {
            this.reportVulnerability(contrastContext, ALREADY_REPORTED_FIELD_VISIBILITY, "graphql-field-visibility", GRAPHQL_BUILD_METHOD);
        }
    }

    private void checkAndReportIntrospectionRule(boolean bl2, Object object, Reflect reflect, Object object2, ApplicationExecutionContext applicationExecutionContext, ContrastContext contrastContext) {
        if (bl2 || applicationExecutionContext.get(ALREADY_REPORTED_INTROSPECTION) != null) {
            return;
        }
        if (!this.isIntrospectionEnabledJvmWide(reflect, object.getClass().getClassLoader())) {
            return;
        }
        if (this.fieldVisibilityPrecludesIntrospection(reflect, object2)) {
            return;
        }
        this.reportVulnerability(contrastContext, ALREADY_REPORTED_INTROSPECTION, "graphql-introspection", GRAPHQL_BUILD_METHOD);
    }

    private void checkAndReportDosRule(boolean bl2, Object object, Reflect reflect, ApplicationExecutionContext applicationExecutionContext, ContrastContext contrastContext) {
        if (bl2 || applicationExecutionContext.get(ALREADY_REPORTED_DOS) != null) {
            return;
        }
        Object object2 = reflect.reset(object).field("instrumentation").asNullable(Object.class);
        if (object2 != null) {
            int n2 = object2.hashCode();
            if (this.graphQLInstrumentationHashesSeen.contains(n2)) {
                return;
            }
            this.graphQLInstrumentationHashesSeen.add(n2);
        }
        if (this.instrumentationPrecludesDOS(object2, reflect, 0)) {
            return;
        }
        this.reportVulnerability(contrastContext, ALREADY_REPORTED_DOS, "graphql-dos", GRAPHQL_BUILD_METHOD);
    }

    private boolean isIntrospectionEnabledJvmWide(Reflect reflect, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        return reflect.reset(ContrastClassLoaderUtil.findLoadedClass((ClassLoader)classLoader, (String)"graphql.introspection.Introspection")).invoke("isEnabledJvmWide").asBoolean(true);
    }

    private boolean fieldVisibilityPrecludesIntrospection(Reflect reflect, Object object) {
        if (object == null) {
            return false;
        }
        List list = reflect.reset(object).field("blockedFields").field("patterns").as(List.class, Collections.emptyList());
        for (Object t2 : list) {
            if (!(t2 instanceof Pattern) || !SCHEMA_PATTERN.equals(((Pattern)t2).pattern())) continue;
            return true;
        }
        return false;
    }

    private boolean instrumentationPrecludesDOS(Object object, Reflect reflect, int n2) {
        if (object == null || n2 > 10) {
            return false;
        }
        String string = object.getClass().getName();
        if (QUERY_COMPLEXITY_INSTR_NAME.equals(string) || QUERY_DEPTH_INSTR_NAME.equals(string)) {
            return true;
        }
        if (CHAIN_INSTR_NAME.equals(string)) {
            List list = reflect.reset(object).field("instrumentations").asNullable(List.class);
            if (list == null) {
                return false;
            }
            for (Object e2 : list) {
                if (!this.instrumentationPrecludesDOS(e2, reflect, n2 + 1)) continue;
                return true;
            }
        }
        return false;
    }

    private void reportVulnerability(ContrastContext contrastContext, ExecutionContext.Key<Boolean> key, String string, String string2) {
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        if (application.context().putIfAbsent(key, Boolean.TRUE) != null) {
            return;
        }
        long l2 = this.configurationHasher.a(string, contrastContext.http().getRequest(), string2);
        this.providerUtil.reportFinding(contrastContext, string, null, l2);
    }
}

