/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect.rules.xxe;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.messages.app.activity.protect.AttackResult;
import com.contrastsecurity.agent.messages.app.activity.protect.details.ExternalEntityWrapperDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.details.XMLMatchDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.G;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.e;
import com.contrastsecurity.agent.plugins.protect.q;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.XXEDetailsDTM;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.c;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d.a;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d.b;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d.g;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.jrgx.MatchIterator;
import com.contrastsecurity.thirdparty.jrgx.MatchResult;
import com.contrastsecurity.thirdparty.jrgx.Matcher;
import com.contrastsecurity.thirdparty.jrgx.Pattern;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringEscapeUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.xml.sax.InputSource;

@m
@DontObfuscate
public final class XXEProtectRule
implements p {
    private final e attackEventPublisher;
    private final ProtectManager manager;
    private final G protectRuleMode;
    @o
    static final Pattern EXTERNAL_ENTITY = new Pattern("(<!ENTITY(?:\\s+)[a-zA-Z0-f]+(?:\\s+)(?:SYSTEM|PUBLIC)(?:\\s+)(.*?)>)");
    @o
    static final Pattern XINCLUDE = new Pattern("(:include(?:\\s+)href=(?:['\"]((?:\\w:)*(?:\\/)*(?:[A-z0-9.-_+]+(?:\\/)*)+)['\"])(?:\\s*)(?:parse=)*)", 1);
    private static final String ERROR_XDPSTART = "xercesDocParsingStart";
    @o
    static final String WOODSTOX_KEY = ProtectRuleId.XXE.id() + "_woodstox";
    @o
    static final String XERCES_KEY = ProtectRuleId.XXE.id() + "_xerces";
    private static final String XERCES_STAX_KEY = ProtectRuleId.XXE.id() + "_xerces_stax";
    private static final String IBM_KEY = ProtectRuleId.XXE.id() + "_ibm_xlxp";
    private static final String[] PATH_UP_STRS = new String[]{"../", "..\\"};
    private static final String[] PATH_STRS = new String[]{"/", "."};
    private static final String[] SUSPICIOUS_CHARS = new String[]{"#", "?"};
    public static final int MAX_EVIDENCE_LENGTH = 2048;
    private static final Pattern WINDOWS_FILE_PATTERN = new Pattern("^[\\\\]*[a-zA-Z]{1,3}:.*");
    private static final Logger logger = LoggerFactory.getLogger(XXEProtectRule.class);
    private static final String INPUT_NAME = "XML Prolog";

    public XXEProtectRule(e e2, ProtectManager protectManager, Config config) {
        this.attackEventPublisher = e2;
        this.manager = protectManager;
        this.protectRuleMode = new q(config, ConfigProperty.PROTECT_XXE_MODE);
    }

    @Override
    public ProtectRuleId getRuleId() {
        return ProtectRuleId.XXE;
    }

    @Override
    public G getProtectRuleMode() {
        return this.protectRuleMode;
    }

    public void onXercesDocumentParsingStart(ProtectContext protectContext, Object object) {
        try {
            this._onXercesDocumentParsingStart(protectContext, (InputSource)object);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            com.contrastsecurity.agent.logging.a.a(ERROR_XDPSTART, logger, "Problem handling Xerces document parsing start", throwable2);
        }
    }

    private void _onXercesDocumentParsingStart(ProtectContext protectContext, InputSource inputSource) {
        Closeable closeable;
        if (logger.isDebugEnabled()) {
            logger.debug("Starting parsing context for input {} / {}", (Object)JVMUtils.getSafeToString(inputSource, true), (Object)inputSource.getClass().getName());
        }
        g g2 = new g();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            closeable = this.wrap(inputStream);
            inputSource.setByteStream((InputStream)closeable);
            g2.a((a)closeable);
            if (logger.isDebugEnabled()) {
                logger.debug("Created wrapper for bytestream {} for context {}", (Object)JVMUtils.getSafeToString(inputStream, true), (Object)JVMUtils.getSafeToString(g2, true));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Bytestream was null -- no wrapper created for input {} for context {}", (Object)JVMUtils.getSafeToString(inputSource, true), (Object)JVMUtils.getSafeToString(g2, true));
        }
        closeable = inputSource.getCharacterStream();
        if (closeable != null) {
            b b2 = this.wrap((Reader)closeable);
            inputSource.setCharacterStream(b2);
            g2.a(b2);
            if (logger.isDebugEnabled()) {
                logger.debug("Created wrapper for reader {} for context {}", (Object)JVMUtils.getSafeToString(closeable, true), (Object)JVMUtils.getSafeToString(g2, true));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("reader was null -- no wrapper created for input {} for context {}", (Object)JVMUtils.getSafeToString(inputSource, true), (Object)JVMUtils.getSafeToString(g2, true));
        }
        logger.debug("Saving the context {}", (Object)g2);
        protectContext.put(XERCES_KEY, g2);
    }

    public void onXercesDoctypeDeclarationFinished(ProtectContext protectContext) {
        try {
            this._onXercesDoctypeDeclarationFinished(protectContext);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem handling Xerces doctype declaration end", exception2);
        }
    }

    private void _onXercesDoctypeDeclarationFinished(ProtectContext protectContext) {
        g g2 = (g)protectContext.get(XERCES_KEY);
        logger.debug("Xerces doctype declaration finishing for context {}", (Object)protectContext);
        if (g2 == null) {
            logger.debug("No xerces parsing context when doctype declaration finished");
            return;
        }
        g2.k();
        this.scanXml(g2, EXTERNAL_ENTITY);
    }

    public void onXercesEntityResolved(ContrastContext contrastContext, String string, Object object, boolean bl2, boolean bl3) {
        try {
            this._onXercesEntityResolved(contrastContext, string, object, bl2, bl3);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem handling Xerces entity resolution", throwable2);
        }
    }

    private void _onXercesEntityResolved(ContrastContext contrastContext, String string, Object object, boolean bl2, boolean bl3) {
        c c2;
        String string2;
        ProtectContext protectContext = contrastContext.protect();
        d d2 = (d)protectContext.get(XERCES_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug("Entity {} name resolved for context {}", (Object)string, (Object)JVMUtils.getSafeToString(d2, true));
        }
        boolean bl4 = false;
        if (d2 == null) {
            d2 = (d)protectContext.get(XERCES_STAX_KEY);
            bl4 = true;
        }
        if (d2 == null) {
            if (!bl4) {
                logger.debug("No xerces parsing context when entity resolved");
                return;
            }
            d2 = new d();
            d2.a(this.buildSpoofedEntity(string, object));
        }
        if (this.isExternalEntityId(string2 = (c2 = new c(object)).a()) && !d2.h()) {
            d2.a(c2);
            d2.g();
            this.scanXml(d2, EXTERNAL_ENTITY);
            this.sendReport(contrastContext, d2);
        }
    }

    public void onXercesDocumentParsingEnd(ContrastContext contrastContext) {
        try {
            this._onXercesDocumentParsingEnd(contrastContext);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem handling Xerces document parsing end", throwable2);
        }
    }

    private void _onXercesDocumentParsingEnd(ContrastContext contrastContext) {
        g g2 = (g)contrastContext.protect().remove(XERCES_KEY);
        logger.debug("Xerces document parsing ends");
        if (g2 == null) {
            logger.debug("No xerces parsing context when document parsing ends");
            return;
        }
        List<c> list = g2.d();
        List<XMLMatchDTM> list2 = g2.c();
        if (!(list.isEmpty() || list2.isEmpty() || g2.h())) {
            if (!g2.e()) {
                this.scanXml(g2, EXTERNAL_ENTITY);
            }
            this.sendReport(contrastContext, g2);
        }
    }

    public void onStAXEventRead(ProtectContext protectContext, Object object, Object object2) {
        try {
            this._onStAXEventRead(protectContext, object, object2);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem handling StAX event read", exception2);
        }
    }

    private void _onStAXEventRead(ProtectContext protectContext, Object object, Object object2) {
        String string;
        logger.debug("Analyzing reader {} and event {}", object, object2);
        d d2 = (d)protectContext.get(XERCES_STAX_KEY);
        if (d2 == null) {
            d2 = new d();
            protectContext.put(XERCES_STAX_KEY, d2);
        }
        if ("DTDEvent".equals(string = object2.getClass().getSimpleName())) {
            d2.a(object2.toString());
            this.scanXml(d2, EXTERNAL_ENTITY);
        } else if ("EndDocumentEvent".equals(string)) {
            protectContext.remove(XERCES_STAX_KEY);
        }
    }

    public void onWoodstoxStAXEventRead(ContrastContext contrastContext, Object object) {
        ProtectContext protectContext = contrastContext.protect();
        try {
            this._onWoodstoxStAXEventRead(protectContext, object);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem handling Woodstox/StAX event read", exception2);
        }
    }

    private void _onWoodstoxStAXEventRead(ProtectContext protectContext, Object object) {
        com.contrastsecurity.agent.plugins.protect.rules.xxe.c.d d2;
        int n2;
        logger.debug("Analyzing reader {}", object);
        d d3 = (d)protectContext.get(WOODSTOX_KEY);
        if (d3 == null) {
            d3 = new d();
            protectContext.put(WOODSTOX_KEY, d3);
        }
        if (11 == (n2 = (d2 = new com.contrastsecurity.agent.plugins.protect.rules.xxe.c.d(object)).a())) {
            d3.a("<?xml version=\"1.0\"?>" + d2.b());
            this.scanXml(d3, EXTERNAL_ENTITY);
        } else if (8 == n2) {
            protectContext.remove(WOODSTOX_KEY);
        }
    }

    public void onWoodstoxEntityResolved(ContrastContext contrastContext, Object object) {
        try {
            this._onWoodstoxEntityResolved(contrastContext, object);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem handling Woodtstox entity resolution", throwable2);
        }
    }

    private void _onWoodstoxEntityResolved(ContrastContext contrastContext, Object object) {
        d d2 = (d)contrastContext.protect().get(WOODSTOX_KEY);
        if (d2 == null) {
            logger.debug("No woodstox parsing context when entity resolved");
            return;
        }
        c c2 = new c(object);
        String string = c2.a();
        if (this.isExternalEntityId(string)) {
            d2.a(c2);
            this.sendReport(contrastContext, d2);
        }
    }

    void onIbmXlxpDoctypeParsingEnd(ProtectContext protectContext, Object object) {
        try {
            this._onIbmXlxpDoctypeParsingEnd(protectContext, object);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem handling IBM XLMP doctype parsing", exception2);
        }
    }

    private void _onIbmXlxpDoctypeParsingEnd(ProtectContext protectContext, Object object) throws NoSuchMethodException {
        Object object2 = Reflect.reflect(object, logger).field("fDoctypeString").asNullable(Object.class);
        if (object2 == null) {
            logger.debug("Null xml body received by Contrast IBM XLXP listener");
            return;
        }
        String string = object2.toString();
        if (string.contains("DTDScanner")) {
            throw new NoSuchMethodException("toString is implemented on the Object rather than StAXDTDScanner and thus dont return the string representation we want");
        }
        d d2 = (d)protectContext.get(IBM_KEY);
        if (d2 == null) {
            d2 = new d();
            protectContext.put(IBM_KEY, d2);
        }
        d2.a(string);
        this.scanXml(d2, EXTERNAL_ENTITY);
    }

    void onIbmXlxpExternalEntityResolved(ContrastContext contrastContext, Object object, Object object2) {
        try {
            this._onIbmXlxpExternalEntityResolved(contrastContext, object, object2);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem handling IBM XLMP entity resolution", throwable2);
        }
    }

    private void _onIbmXlxpExternalEntityResolved(ContrastContext contrastContext, Object object, Object object2) {
        String string = object != null ? object.toString() : null;
        String string2 = object2.toString();
        ProtectContext protectContext = contrastContext.protect();
        d d2 = (d)protectContext.get(IBM_KEY);
        if (d2 == null) {
            d2 = new d();
            protectContext.put(IBM_KEY, d2);
        }
        if (this.isExternalEntityId(string2)) {
            c c2 = new c(string2, string);
            d2.a(c2);
            this.sendReport(contrastContext, d2);
        }
    }

    boolean isExternalEntityId(String string) {
        if (string == null) {
            return false;
        }
        if ((StringUtils.endsWithIgnoreCase(string, ".dtd") || StringUtils.endsWithIgnoreCase(string, ".xsd") || StringUtils.endsWithIgnoreCase(string, ".ent")) && !this.containsSuspiciousChars(string)) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase(string, "http:") || StringUtils.startsWithIgnoreCase(string, "https:") || StringUtils.startsWithIgnoreCase(string, "file:") || StringUtils.startsWithIgnoreCase(string, "ftp:") || StringUtils.startsWithIgnoreCase(string, "jar:") || StringUtils.startsWithIgnoreCase(string, "gopher:")) {
            return true;
        }
        if (StringUtils.startsWithAny(string, PATH_STRS)) {
            return true;
        }
        String string2 = URLDecoder.decode(string);
        for (String string3 : PATH_UP_STRS) {
            if (!string2.contains(string3)) continue;
            return true;
        }
        return WINDOWS_FILE_PATTERN.matches(string);
    }

    private boolean containsSuspiciousChars(String string) {
        String string2 = URLDecoder.decode(string);
        for (String string3 : SUSPICIOUS_CHARS) {
            if (!string.contains(string3) && !string2.contains(string3)) continue;
            return true;
        }
        return false;
    }

    private void sendReport(ContrastContext contrastContext, d d2) {
        String string = d2.b();
        ArrayList<c> arrayList = new ArrayList<c>(d2.d());
        boolean bl2 = this.manager.canBlock(contrastContext, this);
        XXEDetailsDTM xXEDetailsDTM = this.buildXXEDetailsDTM(d2.c(), arrayList, string);
        AttackResult attackResult = bl2 ? AttackResult.BLOCKED : AttackResult.EXPLOITED;
        this.attackEventPublisher.a(contrastContext, ProtectRuleId.XXE, xXEDetailsDTM, UserInputDTM.builder().value(string).name(INPUT_NAME).type(UserInputDTM.InputType.UNKNOWN).time(d2.a()).build(), attackResult);
        if (bl2) {
            throw new AttackBlockedException("XXE attack detected");
        }
    }

    private XXEDetailsDTM buildXXEDetailsDTM(List<XMLMatchDTM> list, List<c> list2, String string) {
        if (list2 == null) {
            return new XXEDetailsDTM(string, list, Collections.emptyList());
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<ExternalEntityWrapperDTM> arrayList = new ArrayList<ExternalEntityWrapperDTM>(list2.size());
        for (c c2 : list2) {
            String string2 = c2.a();
            String string3 = c2.b();
            String string4 = string2 + string3;
            if (!hashSet.add(string4)) continue;
            arrayList.add(new ExternalEntityWrapperDTM(string2, string3));
        }
        return new XXEDetailsDTM(string, list, arrayList);
    }

    private void scanXml(d d2, Pattern pattern) {
        String string = d2.b();
        if (string != null) {
            Matcher matcher = pattern.matcher(StringEscapeUtils.unescapeHtml4(string));
            MatchIterator matchIterator = matcher.findAll();
            while (matchIterator.hasMore()) {
                MatchResult matchResult = matchIterator.nextMatch();
                int n2 = matchResult.start(2);
                int n3 = matchResult.end(2);
                d2.a(new XMLMatchDTM(n2, n3));
            }
        }
        if (pattern.equals(EXTERNAL_ENTITY)) {
            d2.f();
        }
    }

    private String buildSpoofedEntity(String string, Object object) {
        Reflect reflect = Reflect.reflect(object, logger);
        String string2 = reflect.field("fSystemId").asNullableString();
        if (reflect.hasError()) {
            logger.debug("Problem inspecting XML input source during external entity resolution: {}", (Object)reflect.error(), (Object)reflect.caughtException());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("...[<!ENTITY ");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(" SYSTEM ");
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(" ... ");
        }
        stringBuilder.append(">]...");
        return stringBuilder.toString();
    }

    private b wrap(Reader reader) {
        return new b(reader);
    }

    private a wrap(InputStream inputStream) {
        return new a(inputStream);
    }

    public void onXercesXIncludeGetReaderCallResolved(ContrastContext contrastContext, Object object) {
        try {
            this._onXercesXIncludeGetReaderCallResolved(contrastContext, object);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem handling XInclude getReader call resolved", throwable2);
        }
    }

    private void _onXercesXIncludeGetReaderCallResolved(ContrastContext contrastContext, Object object) {
        c c2;
        String string;
        ProtectContext protectContext = contrastContext.protect();
        g g2 = (g)protectContext.get(XERCES_KEY);
        if (g2 == null) {
            g2 = new g();
            protectContext.put(XERCES_KEY, g2);
        }
        if (this.isExternalEntityId(string = (c2 = new c(object)).a()) && !g2.h()) {
            g2.a(c2);
            g2.g();
            g2.k();
            this.scanXml(g2, XINCLUDE);
            this.sendReport(contrastContext, g2);
        }
    }
}

