/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.maps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public class TraceMap
extends ConcurrentReferenceHashMap<Object, Trace> {
    @HeapUsage.Deep
    protected final AtomicBoolean loggedMaximumSourceEvents;
    @HeapUsage.Deep
    private final Set<Object> tracked;
    private final int maxSourceEvents;
    private final int maxPropagationEvents;
    private volatile int numSourceEvents;
    private volatile int numPropagationEvents;
    private static final Logger logger = LoggerFactory.getLogger(TraceMap.class);

    public TraceMap(int n2, float f2, int n3, int n4) {
        super(n2, f2, 32, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.range(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS, ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
        this.maxSourceEvents = n3;
        this.maxPropagationEvents = n4;
        this.loggedMaximumSourceEvents = new AtomicBoolean(false);
        this.tracked = Collections.newSetFromMap(new ConcurrentReferenceHashMap());
    }

    public int sourceEvents() {
        return this.numSourceEvents;
    }

    public void incrementSourceEventCount() {
        ++this.numSourceEvents;
    }

    public boolean hasReachedMaximumSourceEvents() {
        return this.numSourceEvents >= this.maxSourceEvents;
    }

    public int propagationEvents() {
        return this.numPropagationEvents;
    }

    public void incrementPropagationEventCount() {
        ++this.numPropagationEvents;
    }

    public boolean hasReachedMaximumPropagationEvents() {
        return this.numPropagationEvents >= this.maxPropagationEvents;
    }

    public void logMaximumSourceEvents(String string) {
        if (!this.loggedMaximumSourceEvents.getAndSet(true)) {
            logger.warn("Maximum source events reached for this context. Ignoring source event {}, consider increasing maximum events via the `assess.max_context_source_events` property. Further events will be logged at the `DEBUG` level", (Object)string);
            return;
        }
        logger.debug("Maximum source events reached for this context. Ignoring source event {}", (Object)string);
    }

    public boolean track(Object object) {
        return this.tracked.add(object);
    }

    public boolean isTracked(Object object) {
        return this.tracked.contains(object);
    }

    @Override
    public void clear() {
        super.clear();
        this.tracked.clear();
    }
}

