/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.model;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.e;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventPropertyDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.finding.trace.OperationDTM;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.d;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oobjw.asm.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public final class SourceEvent
extends CodeEvent {
    @HeapUsage.Deep
    private final String fieldName;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final SourceNode source;
    @HeapUsage.Deep
    private Set<EventSourceDTM> eventSources;
    private final int identityHash;
    @HeapUsage.Deep
    private final String queue;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private u overriddenSourceType;

    SourceEvent(a a2) {
        super(a2);
        this.fieldName = a2.a();
        this.source = a2.b();
        this.eventSources = a2.r();
        this.identityHash = a2.s();
        this.queue = a2.t();
    }

    public SourceNode getSource() {
        return this.source;
    }

    public String getQueue() {
        return this.queue;
    }

    @Override
    protected EventDTM.Builder getCommonDtmBuilder() {
        OperationDTM operationDTM;
        EventDTM.Builder builder = super.getCommonDtmBuilder();
        builder.target(StringUtils.isNotEmpty(this.targetType) ? SourceEvent.calculateEventTargetType(this.source, this.method) : "R");
        if (this.source != null && (operationDTM = this.source.getOperation()) != null) {
            EventPropertyDTM eventPropertyDTM = new EventPropertyDTM(PropertyKey.OPERATION, operationDTM.getLabel());
            builder.properties(Collections.singletonList(eventPropertyDTM));
        }
        if (!StringUtils.isEmpty(this.fieldName)) {
            builder.fieldName(com.contrastsecurity.agent.http.e.a(this.fieldName));
        }
        if (this.eventSources != null && !this.eventSources.isEmpty()) {
            builder.eventSources(this.eventActionDTM, this.eventSources);
        }
        return builder;
    }

    @o
    static String calculateEventTargetType(SourceNode sourceNode, MethodDescription methodDescription) {
        if (sourceNode == null) {
            return Location.R.getDescriptor();
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        if (sourceNode.flowsToObject()) {
            stringJoiner.add(Location.O.getDescriptor());
        }
        if (sourceNode.flowsToReturn()) {
            stringJoiner.add(Location.R.getDescriptor());
        }
        String[] stringArray = methodDescription.getParameterTypeNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            Type type = Type.getObjectType(string.replace('.', '/'));
            if (!sourceNode.flowsToParameter(i2, type, Collections.emptySet())) continue;
            Location location = Location.pForArgIndex(i2);
            stringJoiner.add(location == null ? "P" + (i2 + 1) : location.getDescriptor());
        }
        return stringJoiner.toString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Set<EventSourceDTM> getEventSources() {
        return this.eventSources;
    }

    @Override
    public void prepareForReporting(List<CodeEvent> list, int n2) {
        if (this.source == null) {
            return;
        }
        Set<u> set = this.overriddenSourceType == null ? this.source.getSourceTypes() : Collections.singleton(this.overriddenSourceType);
        Set<u> set2 = this.getChildTypes(this.id, list, n2);
        if (set2 == null || set2.isEmpty()) {
            this.eventSources = d.a(this.fieldName, set);
            return;
        }
        HashSet<u> hashSet = new HashSet<u>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        this.eventSources = d.a(this.fieldName, hashSet);
    }

    @o
    Set<u> getChildTypes(long l2, List<CodeEvent> list, int n2) {
        if (list == null) {
            return Collections.emptySet();
        }
        int n3 = n2 + 1;
        if (n3 < 0 || n3 >= list.size()) {
            return Collections.emptySet();
        }
        CodeEvent codeEvent = list.get(n3);
        if (!(codeEvent instanceof PropagationEvent)) {
            return Collections.emptySet();
        }
        Set<Long> set = codeEvent.getParentIds();
        if (set == null || !set.contains(l2)) {
            return Collections.emptySet();
        }
        PropagationEvent propagationEvent = (PropagationEvent)codeEvent;
        Propagator propagator = propagationEvent.getPropagator();
        return propagator == null ? Collections.emptySet() : propagator.getSourceTypes();
    }

    @o
    public u getOverriddenSourceType() {
        return this.overriddenSourceType;
    }

    public int getIdentityHash() {
        return this.identityHash;
    }

    @Override
    @e
    public StringBuilder toShortString(StringBuilder stringBuilder) {
        super.toShortString(stringBuilder);
        return this.source != null && this.source.getId() != null ? stringBuilder.append("\n\t\t\t\t\t\t\t").append("POLICY: ").append(this.source.getId()) : stringBuilder;
    }

    public void overrideSourceType(u u2) {
        this.overriddenSourceType = u2;
    }

    static interface a
    extends CodeEvent.a {
        public String a();

        public SourceNode b();

        public Set<EventSourceDTM> r();

        public int s();

        public String t();
    }
}

