/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.pattern;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.controller.EventHelper;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.model.TagEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.model.k;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.scope.Scoping;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DontObfuscate
@m
public final class ContrastPatternDispatcherImpl
implements ContrastPatternDispatcher {
    private final TraceController traceController;
    private final c codeEventFactory;
    private final i stackCaptureFactory;
    private final a methodDescriptionCache;
    private final ContrastPolicyManager policyManager;
    private static final Logger logger = LoggerFactory.getLogger(ContrastPatternDispatcherImpl.class);

    public ContrastPatternDispatcherImpl(TraceController traceController, c c2, i i2, a a2, ContrastPolicyManager contrastPolicyManager) {
        this.codeEventFactory = c2;
        this.traceController = traceController;
        this.stackCaptureFactory = i2;
        this.methodDescriptionCache = a2;
        this.policyManager = contrastPolicyManager;
    }

    public void onJavaPatternUsed(Object object, Object object2, Object object3, Matcher matcher) {
        if (object2 == null) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Scoping scoping = contrastContext.scope();
        if (!scoping.inScope(ScopeType.ASSESS_VALIDATOR)) {
            return;
        }
        AssessmentContext assessmentContext = contrastContext.assessment();
        Trace trace = this.traceController.getTrace(assessmentContext, object2);
        if (trace == null) {
            return;
        }
        Pattern pattern = (Pattern)object3;
        String string = pattern.pattern();
        String string2 = this.getValidatorTag(string);
        if (string2 == null) {
            return;
        }
        k k2 = this.createTagEventBuilder(trace, "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", pattern, new Object[]{object2}, matcher);
        this.addTaggingEvent(assessmentContext, trace, k2, string2, object2);
    }

    private void addTaggingEvent(AssessmentContext assessmentContext, Trace trace, k k2, String string, Object object) throws InvalidTagRangeException {
        k2.d(trace.getLastEvent());
        k2.b(K.a(string, EventHelper.getLength(assessmentContext, object)));
        TagEvent tagEvent = k2.g();
        if (assessmentContext != null && assessmentContext.isIdentityTaggingEnabled()) {
            int n2 = object.hashCode();
            int n3 = trace.getIdentitySourceHash();
            int n4 = AssessmentContext.calculateIdentity(n2, n3);
            assessmentContext.applyTags(n4, string, EventHelper.getLength(assessmentContext, object));
        }
        trace.addEvent(assessmentContext, tagEvent);
        if (logger.isDebugEnabled()) {
            logger.debug("TRACE {}", (Object)tagEvent);
        }
    }

    @o
    public String getValidatorTag(String string) {
        Set<String> set;
        ContrastPolicy contrastPolicy = this.policyManager.currentPolicy();
        Map<String, Set<String>> map = contrastPolicy.getAcceptedRegex();
        for (String string2 : map.keySet()) {
            set = map.get(string2);
            for (String string3 : set) {
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        map = contrastPolicy.getRejectedRegex();
        for (String string2 : map.keySet()) {
            set = map.get(string2);
            for (String string3 : set) {
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    private k createTagEventBuilder(Trace trace, String string, String string2, Object object, Object[] objectArray, Object object2) {
        MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, object.getClass().getName(), string, string2, 0);
        return (k)((k)((k)((k)((k)((k)((k)this.codeEventFactory.a(null).a(methodDescription)).a(objectArray)).d("P0")).a(object)).b(object2)).c(trace.getLastEvent())).a(this.stackCaptureFactory.a(i.a.c));
    }

    public void onPerl5PatternUsed(Object object, Object object2, Object object3, Object object4, boolean bl2) {
        if (object3 == null || object4 == null) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Scoping scoping = contrastContext.scope();
        if (!scoping.inScope(ScopeType.ASSESS_VALIDATOR)) {
            return;
        }
        AssessmentContext assessmentContext = contrastContext.assessment();
        Trace trace = this.traceController.getTrace(assessmentContext, object3);
        if (trace == null) {
            return;
        }
        String string = Reflect.reflect(object4, logger).invoke("getPattern").asNullableString();
        if (string == null) {
            return;
        }
        String string2 = this.getValidatorTag(string);
        if (string2 == null) {
            return;
        }
        k k2 = this.createTagEventBuilder(trace, "matches", "(Ljava/lang/String;Lorg/apache/oro/text/regex/Perl5Matcher;)Z", object2, new Object[]{object3, object4}, bl2);
        this.addTaggingEvent(assessmentContext, trace, k2, string2, object3);
    }
}

