/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf;

import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.contrastapi_v1_0.StandardRequestMethod;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.j;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.b;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.d;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.e;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.SimplePattern;
import com.contrastsecurity.agent.util.p;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.http.HeaderElement;
import com.contrastsecurity.thirdparty.oa4j.http.ParseException;
import com.contrastsecurity.thirdparty.oa4j.http.message.BasicHeaderValueParser;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

@HeapUsage.SupportsHeapProfiling
public class f
implements HttpWatcher {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final e.a a;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final List<SimplePattern> b;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final ProviderUtil c;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final j.e d;
    private static final Collection<RequestMethod> e = Sets.of(StandardRequestMethod.GET, StandardRequestMethod.POST);
    private static final Set<String> f = Sets.of("text/plain", "multipart/form-data", "application/x-www-form-urlencoded");
    private static final int g = 8;
    private static final int h = 24;
    private static final Logger i = LoggerFactory.getLogger(f.class);

    public f(d d2, ProviderUtil providerUtil, j j2) {
        this.a = d2.a();
        this.b = d2.b();
        this.c = providerUtil;
        this.d = j2.g();
    }

    @Override
    public void onResponseEnd(ContrastContext contrastContext) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        HttpResponse httpResponse = contrastContext.http().getResponse();
        if (httpRequest == null || httpResponse == null) {
            return;
        }
        int n2 = httpResponse.getStatus();
        if (this.a(n2)) {
            return;
        }
        if (!com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.b.a(httpRequest)) {
            return;
        }
        if (!com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.e.c(httpRequest) && com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.e.a(httpRequest)) {
            return;
        }
        if (this.b(httpRequest)) {
            return;
        }
        EnumMap<PropertyKey, String> enumMap = new EnumMap<PropertyKey, String>(PropertyKey.class);
        enumMap.put(PropertyKey.ACTIONS, com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.b.c(httpRequest));
        long l2 = this.d.a("csrf", httpRequest);
        this.c.reportFinding(contrastContext, "csrf", enumMap, l2);
    }

    @Override
    public long getRuleRequestHash(HttpRequest httpRequest, CRC32 cRC32) {
        return this.d.a(cRC32, "csrf", httpRequest);
    }

    boolean a(HttpRequest httpRequest) {
        return StandardRequestMethod.GET == httpRequest.getMethod() && StringUtils.isEmpty(httpRequest.getQueryString());
    }

    boolean b(HttpRequest httpRequest) {
        if (this.a(httpRequest.getHeaders())) {
            return true;
        }
        if (this.a(httpRequest.getParameters())) {
            return true;
        }
        return this.a(httpRequest.getMultipartItems());
    }

    boolean a(Set<MultipartItem> set) {
        if (set == null) {
            return false;
        }
        for (MultipartItem multipartItem : set) {
            String string;
            String string2 = multipartItem.getFieldName();
            if (H.c(string2, "csrf")) {
                i.debug("Not considering CSRF because possible token value observed {}", (Object)string2);
                return true;
            }
            if (!H.c(string2, "token") || !this.a(string = multipartItem.getValue())) continue;
            i.debug("Not considering CSRF because possible token value observed {}={}", (Object)string2, (Object)string);
            return true;
        }
        return false;
    }

    boolean a(Map<String, String[]> map) {
        if (map == null) {
            return false;
        }
        for (String string : map.keySet()) {
            String[] stringArray;
            if (H.c(string, "csrf")) {
                i.debug("Not considering CSRF because possible token value observed {}", (Object)string);
                return true;
            }
            if (!H.c(string, "token") || !this.a(stringArray = map.get(string))) continue;
            i.debug("Not considering CSRF because possible token value observed {}={}", (Object)string, (Object)stringArray[0]);
            return true;
        }
        return false;
    }

    boolean a(String[] stringArray) {
        if (stringArray != null && stringArray.length == 1) {
            return this.a(stringArray[0]);
        }
        return false;
    }

    boolean a(String string) {
        if (string != null && string.length() >= 8 && string.length() <= 24) {
            return H.c(string);
        }
        return false;
    }

    boolean a(int n2) {
        return n2 >= 400;
    }

    @Override
    public boolean supports(HttpRequest httpRequest) {
        HeaderElement[] headerElementArray;
        String string = httpRequest.getHeader("X-Requested-With");
        if (!StringUtils.isEmpty(string)) {
            i.debug("Ignoring CSRFRule for {} because X-Requested-With={}", (Object)httpRequest.getUri(), (Object)string);
            return false;
        }
        String string2 = httpRequest.getHeader("User-Agent");
        if (StringUtils.isEmpty(string2)) {
            i.debug("Ignoring CSRFRule for {} because no User-Agent was supplied -- not a browser interaction", (Object)httpRequest.getUri());
            return false;
        }
        String string3 = httpRequest.getHeader("Authorization");
        if (!StringUtils.isEmpty(string3) && !StringUtils.containsIgnoreCase(string3, "basic")) {
            i.debug("Ignoring CSRFRule for {} because Authorization header is present with non-Basic auth", (Object)httpRequest.getUri());
            return false;
        }
        String string4 = httpRequest.getCookie();
        if (StringUtils.isEmpty(string3) && StringUtils.isEmpty(string4)) {
            i.debug("Ignoring CSRFRule for {} because no Authorization header and no Cookies present -- nothing to forge", (Object)httpRequest.getUri());
            return false;
        }
        if (p.b(httpRequest)) {
            i.debug("Ignoring CSRFRule for {} because it looks like its a static resource", (Object)httpRequest.getUri());
            return false;
        }
        String string5 = httpRequest.getHeader("Content-Type");
        if (string5 != null) {
            try {
                headerElementArray = BasicHeaderValueParser.parseElements(string5, BasicHeaderValueParser.INSTANCE);
            }
            catch (ParseException parseException) {
                i.debug("Ignoring CSRFRule for {} because its content-type header is malformed value {}", httpRequest.getUri(), string5, parseException);
                return false;
            }
            if (headerElementArray.length == 0) {
                i.debug("Ignoring CSRFRule for {} because its content-type header is malformed value {}", (Object)httpRequest.getUri(), (Object)string5);
                return false;
            }
            HeaderElement headerElement = headerElementArray[0];
            String string6 = headerElement.getName();
            if (!this.c(string6)) {
                i.debug("Ignoring CSRFRule for {} because Content-Type was {}", (Object)httpRequest.getUri(), (Object)string5);
                return false;
            }
        }
        if (!this.a((RequestMethod)(headerElementArray = httpRequest.getMethod()))) {
            i.debug("Ignoring CSRFRule for {} because method was {}", (Object)httpRequest.getUri(), (Object)headerElementArray);
            return false;
        }
        if (this.a(httpRequest)) {
            i.debug("Ignoring CSRFRule for {} because method was GET and no querystring", (Object)httpRequest.getUri());
            return false;
        }
        if (e.a.a.equals((Object)this.a) && this.b(httpRequest.getNormalizedUri())) {
            i.debug("Ignoring CSRFRule for {} because URL was known idempotent", (Object)httpRequest.getNormalizedUri());
            return false;
        }
        if (e.a.b.equals((Object)this.a) && !this.b(httpRequest.getNormalizedUri())) {
            i.debug("Ignoring CSRFRule for {} because URL was not on the need-to-protect list", (Object)httpRequest.getNormalizedUri());
            return false;
        }
        return true;
    }

    boolean b(String string) {
        for (SimplePattern simplePattern : this.b) {
            if (!simplePattern.matches(string)) continue;
            return true;
        }
        return false;
    }

    private boolean a(RequestMethod requestMethod) {
        return e.contains(requestMethod);
    }

    private boolean c(String string) {
        return f.contains(string);
    }
}

