/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.pool;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.a.b;
import com.contrastsecurity.agent.pool.ObjectPool;

@DontObfuscate
public final class Poolable<T>
implements b {
    private final ObjectPool<T> pool;
    private final T object;
    private final boolean disposable;
    private long lastAccessNS;

    private Poolable(ObjectPool<T> objectPool, T t2) {
        this.pool = objectPool;
        this.object = t2;
        this.disposable = false;
    }

    private Poolable(ObjectPool<T> objectPool, T t2, boolean bl2) {
        this.pool = objectPool;
        this.object = t2;
        this.disposable = bl2;
    }

    static <T> Poolable<T> create(ObjectPool<T> objectPool, T t2) {
        return new Poolable<T>(objectPool, t2);
    }

    static <T> Poolable<T> createDisposable(ObjectPool<T> objectPool, T t2) {
        return new Poolable<T>(objectPool, t2, true);
    }

    public T get() {
        return this.object;
    }

    public ObjectPool<T> getPool() {
        return this.pool;
    }

    public long getLastAccessNS() {
        return this.lastAccessNS;
    }

    public void updateLastAccess(Clock clock) {
        this.lastAccessNS = clock.nanoTime();
    }

    public boolean hasExpired(Clock clock) {
        return clock.nanoTime() - this.lastAccessNS > this.pool.getMaximumTTLinNS();
    }

    boolean isDisposable() {
        return this.disposable;
    }

    @Override
    public void close() throws InterruptedException {
        this.pool.returnObject(this);
    }
}

