/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.scope;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.scope.DequeScope;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.scope.a;
import java.util.Arrays;

@DontObfuscate
public class Scoping {
    private final int[] scopes;
    private final a[] autoScopes;
    private final DequeScope<?>[] dequeScopes;

    public Scoping() {
        int n2 = ScopeType.VALUES.length;
        this.scopes = new int[n2];
        this.autoScopes = new a[n2];
        this.dequeScopes = new DequeScope[DequeScope.Type.VALUES.length];
    }

    public a enterAutoScope(ScopeType scopeType) {
        int n2 = scopeType.ordinal();
        a a2 = this.autoScopes[n2];
        if (this.autoScopes[n2] == null) {
            this.autoScopes[n2] = a2 = new a(this, scopeType);
        }
        return a2.a();
    }

    public boolean inScope(ScopeType scopeType) {
        return this.scopes[scopeType.ordinal()] != 0;
    }

    public boolean isUnscoped(ScopeType scopeType) {
        return this.scopes[scopeType.ordinal()] == 0;
    }

    public boolean inOutermostScope(ScopeType scopeType) {
        return this.scopes[scopeType.ordinal()] == 1;
    }

    public boolean inNestedScope(ScopeType scopeType) {
        return this.scopes[scopeType.ordinal()] > 1;
    }

    public int value(ScopeType scopeType) {
        return this.scopes[scopeType.ordinal()];
    }

    public void enterScope(ScopeType scopeType) {
        int n2 = scopeType.ordinal();
        this.scopes[n2] = this.scopes[n2] + 1;
    }

    public void leaveScope(ScopeType scopeType) {
        int n2 = scopeType.ordinal();
        int n3 = this.scopes[n2];
        Assert.assertTrue(n3 > 0, "Decrementing the general scope to negative value is not allowed");
        this.scopes[n2] = Math.max(n3 - 1, 0);
    }

    public void set(ScopeType scopeType, int n2) {
        this.scopes[scopeType.ordinal()] = Math.max(n2, 0);
    }

    public <T> DequeScope<T> deque(DequeScope.Type type) {
        int n2 = type.ordinal();
        DequeScope<Object> dequeScope = this.dequeScopes[n2];
        if (dequeScope == null) {
            this.dequeScopes[n2] = dequeScope = new DequeScope();
        }
        return dequeScope;
    }

    public boolean inTriggerRuleScope(String string) {
        if (this.inScope(ScopeType.ASSESS_SAMPLING)) {
            return true;
        }
        DequeScope<String> dequeScope = this.deque(DequeScope.Type.ASSESS_DEADZONE);
        if (dequeScope.inScope(string)) {
            return true;
        }
        DequeScope<String> dequeScope2 = this.deque(DequeScope.Type.ASSESS_TRIGGER);
        return dequeScope2.exceeds(string, 1);
    }

    @o
    public void reset() {
        Arrays.fill(this.scopes, 0);
        Arrays.fill(this.autoScopes, null);
        Arrays.fill(this.dequeScopes, null);
    }

    @o
    a[] getAutoScopes() {
        return this.autoScopes;
    }

    public String toString(ScopeType scopeType) {
        return Integer.toString(this.scopes[scopeType.ordinal()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i2 = 0; i2 < this.scopes.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(ScopeType.VALUES[i2].name());
            stringBuilder.append('=');
            stringBuilder.append(this.scopes[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

