/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.trace.a;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;

@DontObfuscate
public class MethodDescription {
    private final String objectType;
    private final String name;
    private final String description;
    private final String returnType;
    private final String[] parameterTypes;
    private final int flags;
    private String signature;

    public MethodDescription(String string, String string2, String string3, int n2) {
        this(string, string2, string3, n2, com.contrastsecurity.agent.util.a.c(string3), com.contrastsecurity.agent.util.a.b(string3).a(), null);
    }

    public MethodDescription(String string, String string2, String string3, int n2, String string4, String[] stringArray, String string5) {
        this.objectType = string;
        this.name = string2;
        this.description = string3;
        this.returnType = string4;
        this.parameterTypes = stringArray;
        this.flags = n2;
        this.signature = string5;
    }

    public static MethodDescription getMethod(a a2, String string, String string2, String string3, int n2) {
        if (!a2.a()) {
            return new MethodDescription(string, string2, string3, n2);
        }
        int n4 = string.hashCode();
        n4 = 31 * n4 + string2.hashCode();
        n4 = 31 * n4 + string3.hashCode();
        n4 = 31 * n4 + n2;
        return a2.a(n4, n3 -> new MethodDescription(string, string2, string3, n2));
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringClassType() {
        return this.objectType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReturnTypeName() {
        return this.returnType;
    }

    public String[] getParameterTypeNames() {
        return this.parameterTypes;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public int getModifiers() {
        return this.flags;
    }

    public String getSignature() {
        return this.signature == null ? (this.signature = this.createSignature()) : this.signature;
    }

    private String createSignature() {
        String[] stringArray = this.getParameterTypeNames();
        StringBuilder stringBuilder = new StringBuilder(120 + stringArray.length * 25);
        stringBuilder.append(this.getReturnTypeName()).append(" ");
        stringBuilder.append(this.getDeclaringClassType());
        stringBuilder.append(".");
        stringBuilder.append(this.getName());
        stringBuilder.append("(");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]);
            if (i2 >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getSignature();
    }

    public int hashCode() {
        int n2 = this.objectType.hashCode();
        n2 = 31 * n2 + this.name.hashCode();
        n2 = 31 * n2 + this.description.hashCode();
        n2 = 31 * n2 + this.flags;
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MethodDescription)) {
            return false;
        }
        MethodDescription methodDescription = (MethodDescription)object;
        if (this == methodDescription) {
            return true;
        }
        return Objects.equals(this.objectType, methodDescription.getDeclaringClassType()) && Objects.equals(this.name, methodDescription.getName()) && Arrays.equals(this.parameterTypes, methodDescription.getParameterTypeNames());
    }
}

