/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.messages.finding.trace.EventPropertyDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.model.TagEvent;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.model.i;
import com.contrastsecurity.agent.plugins.security.model.j;
import com.contrastsecurity.agent.services.ngreporting.ConfidenceLevel;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.util.A;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public class Trace {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final c codeEventFactory;
    private final int summarizationLeadingEventsCount;
    private final int summarizationMinTrailingEventsCount;
    private final int updateSummaryThreshold;
    private final int traceSummarizationThreshold;
    private final int freezeThreshold;
    @HeapUsage.Deep
    private List<CodeEvent> events;
    @HeapUsage.Deep
    private final Object eventsMutex;
    private final long id;
    private long parentId;
    @HeapUsage.Deep
    private String evidence;
    @HeapUsage.Deep
    private final List<EventPropertyDTM> properties;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    public ConfidenceLevel level;
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    private int eventsAddedSinceSummaryUpdate;
    private int summaryEventSize;
    private boolean summarized;
    private int identitySourceHash;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private String ruleId;
    private static final Logger logger = LoggerFactory.getLogger(Trace.class);

    @o
    public Trace(c c2, int n2, int n3, int n4, int n5, int n6) {
        this.codeEventFactory = c2;
        this.summarizationLeadingEventsCount = n2;
        this.summarizationMinTrailingEventsCount = n3;
        this.updateSummaryThreshold = n4;
        this.traceSummarizationThreshold = n5;
        this.freezeThreshold = n6;
        this.id = NEXT_ID.getAndIncrement();
        this.summarized = false;
        this.summaryEventSize = 0;
        this.events = new CopyOnWriteArrayList<CodeEvent>();
        this.eventsMutex = new Object();
        this.properties = new CopyOnWriteArrayList<EventPropertyDTM>();
    }

    Trace(AssessmentContext assessmentContext, Trace trace) {
        this.codeEventFactory = trace.codeEventFactory;
        this.summarizationLeadingEventsCount = trace.summarizationLeadingEventsCount;
        this.summarizationMinTrailingEventsCount = trace.summarizationMinTrailingEventsCount;
        this.updateSummaryThreshold = trace.updateSummaryThreshold;
        this.traceSummarizationThreshold = trace.traceSummarizationThreshold;
        this.freezeThreshold = trace.freezeThreshold;
        this.id = NEXT_ID.getAndIncrement();
        this.events = new CopyOnWriteArrayList<CodeEvent>();
        this.eventsMutex = new Object();
        this.copyEvents(assessmentContext, trace);
        this.properties = new CopyOnWriteArrayList<EventPropertyDTM>();
        this.copyProperties(trace);
        this.evidence = trace.getEvidence();
        this.identitySourceHash = trace.getIdentitySourceHash();
        this.parentId = trace.getParentId();
        this.ruleId = trace.getRuleId();
        this.summarized = trace.summarized;
        this.summaryEventSize = trace.summaryEventSize;
    }

    private boolean shouldAddEvent(CodeEvent codeEvent) {
        if (codeEvent instanceof TriggerEvent) {
            return true;
        }
        if (this.isFrozen()) {
            return false;
        }
        if (codeEvent == null) {
            return false;
        }
        return !this.events.contains(codeEvent);
    }

    private void summarizeTrace(AssessmentContext assessmentContext) {
        int n2;
        long l2 = this.events.get(this.summarizationLeadingEventsCount - 1).getId();
        int n3 = this.events.size() - (this.summarizationMinTrailingEventsCount + 1);
        int n4 = this.summarizationLeadingEventsCount + 1;
        int n5 = n3;
        for (int i2 = n3; i2 >= n4; --i2) {
            CodeEvent codeEvent = this.events.get(i2);
            if (codeEvent instanceof TagEvent || codeEvent.getId() == l2) continue;
            n5 = i2;
            break;
        }
        CopyOnWriteArrayList<CodeEvent> copyOnWriteArrayList = new CopyOnWriteArrayList<CodeEvent>();
        for (n2 = 0; n2 < this.summarizationLeadingEventsCount; ++n2) {
            copyOnWriteArrayList.add(this.events.get(n2));
        }
        n2 = 0;
        j j2 = this.codeEventFactory.c(assessmentContext);
        for (int i3 = this.summarizationLeadingEventsCount; i3 <= n5; ++i3) {
            CodeEvent codeEvent = this.events.get(i3);
            n2 = codeEvent instanceof i ? (n2 += ((i)codeEvent).b().size()) : ++n2;
            if (n2 > this.freezeThreshold) {
                logger.debug("Summary event freeze threshold of {} was reached. Summarizing will be stopped and the resulting Trace may be inaccurate.", (Object)this.freezeThreshold);
                break;
            }
            j2.e(codeEvent);
        }
        j2.a(this.events.get(n5));
        j2.d(l2);
        i i4 = j2.g();
        copyOnWriteArrayList.add(i4);
        for (int i5 = n5 + 1; i5 < this.events.size(); ++i5) {
            copyOnWriteArrayList.add(this.events.get(i5));
        }
        this.events = copyOnWriteArrayList;
        this.summaryEventSize = i4.b().size();
        this.eventsAddedSinceSummaryUpdate = 0;
        this.summarized = true;
    }

    private boolean isFrozen() {
        return this.summarized && this.summaryEventSize >= this.freezeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(AssessmentContext assessmentContext, CodeEvent codeEvent) {
        long l2 = System.currentTimeMillis();
        Object object = this.eventsMutex;
        synchronized (object) {
            if (this.shouldAddEvent(codeEvent)) {
                A.a("Trace.addEvent()", l2, System.currentTimeMillis());
                this.events.add(codeEvent);
                ++this.eventsAddedSinceSummaryUpdate;
            }
            if (this.shouldSummarizeTrace()) {
                this.summarizeTrace(assessmentContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEvents(AssessmentContext assessmentContext, Trace trace) {
        if (trace == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source is null");
            }
            return;
        }
        if (trace.getEvents() == null || trace.getEvents().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source does not have any events");
            }
            return;
        }
        if (this.isFrozen()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        Object object = this.eventsMutex;
        synchronized (object) {
            A.a("Trace.copyEvents()", l2, System.currentTimeMillis());
            List<CodeEvent> list = trace.getEvents();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                CodeEvent codeEvent = list.get(i2);
                if (!this.shouldAddEvent(codeEvent)) continue;
                if (codeEvent instanceof i) {
                    this.eventsAddedSinceSummaryUpdate += trace.eventsAddedSinceSummaryUpdate;
                }
                this.events.add(codeEvent);
                ++this.eventsAddedSinceSummaryUpdate;
            }
            if (this.shouldSummarizeTrace()) {
                this.summarizeTrace(assessmentContext);
            }
        }
    }

    private void copyProperties(Trace trace) {
        if (trace == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source is null");
            }
            return;
        }
        if (trace.getProperties() == null || trace.getProperties().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source does not have any properties");
            }
            return;
        }
        this.properties.addAll(trace.getProperties());
    }

    private boolean shouldSummarizeTrace() {
        boolean bl2 = !this.summarized && this.events.size() >= this.traceSummarizationThreshold;
        boolean bl3 = this.summarized && this.eventsAddedSinceSummaryUpdate >= this.updateSummaryThreshold;
        return !this.isFrozen() && (bl2 || bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodeEvent> getEvents() {
        Object object = this.eventsMutex;
        synchronized (object) {
            return Collections.unmodifiableList(this.events);
        }
    }

    public List<EventPropertyDTM> getProperties() {
        return Lists.copy(this.properties);
    }

    public Iterable<EventPropertyDTM> getPropertiesIterable() {
        return this.properties;
    }

    public void addProperty(EventPropertyDTM eventPropertyDTM) {
        this.properties.add(eventPropertyDTM);
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TRACE " + this.getId() + " (" + this.getParentId() + ")\n");
        long l2 = System.currentTimeMillis();
        if (!StringUtils.isEmpty(this.evidence)) {
            stringBuilder.append(H.a((CharSequence)this.evidence, 20));
        } else {
            Object object = this.eventsMutex;
            synchronized (object) {
                A.a("Trace.toString()", l2, System.currentTimeMillis());
                for (CodeEvent codeEvent : this.events) {
                    stringBuilder.append("   : ").append(codeEvent).append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long l2) {
        this.parentId = l2;
    }

    public void setEvidence(String string) {
        this.evidence = string;
    }

    public String getEvidence() {
        return this.evidence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastTrigger() {
        Object object = this.eventsMutex;
        synchronized (object) {
            for (int i2 = this.events.size() - 1; i2 >= 0; --i2) {
                CodeEvent codeEvent = this.events.get(i2);
                if (!(codeEvent instanceof TriggerEvent)) continue;
                return i2;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeEvent getFirstEvent() {
        Object object = this.eventsMutex;
        synchronized (object) {
            if (this.events.isEmpty()) {
                return null;
            }
            return this.events.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeEvent getLastEvent() {
        Object object = this.eventsMutex;
        synchronized (object) {
            if (this.events.isEmpty()) {
                return null;
            }
            return this.events.get(this.events.size() - 1);
        }
    }

    public Set<Tag> getTags() {
        CodeEvent codeEvent = this.getLastEvent();
        return codeEvent == null ? Collections.emptySet() : codeEvent.getTags();
    }

    public TagRanges getTagRanges() {
        CodeEvent codeEvent = this.getLastEvent();
        if (codeEvent == null) {
            return new TagRanges();
        }
        return codeEvent.getTagRanges();
    }

    public boolean hasTag(Tag tag) {
        Set<Tag> set = this.getTags();
        return set != null && set.contains((Object)tag);
    }

    public void setRuleId(String string) {
        this.ruleId = string;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public int getIdentitySourceHash() {
        return this.identitySourceHash;
    }

    public void setIdentitySourceHash(int n2) {
        this.identitySourceHash = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropagationEvent getLastPropagationEvent() {
        Object object = this.eventsMutex;
        synchronized (object) {
            for (int i2 = this.events.size() - 1; i2 >= 0; --i2) {
                CodeEvent codeEvent = this.events.get(i2);
                if (!(codeEvent instanceof PropagationEvent)) continue;
                return (PropagationEvent)codeEvent;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceEvent getFirstSourceEvent() {
        Object object = this.eventsMutex;
        synchronized (object) {
            for (CodeEvent codeEvent : this.events) {
                if (!(codeEvent instanceof SourceEvent)) continue;
                return (SourceEvent)codeEvent;
            }
            return null;
        }
    }

    public ConfidenceLevel getConfidenceLevel() {
        return this.level;
    }

    public void setConfidenceLevel(ConfidenceLevel confidenceLevel) {
        if (confidenceLevel == null) {
            return;
        }
        if (this.level != null && confidenceLevel.ordinal() >= this.level.ordinal()) {
            return;
        }
        this.level = confidenceLevel;
    }
}

