/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import java.util.regex.Pattern;

@DontObfuscate
public class SimplePattern {
    Pattern realPattern;
    String originalPattern;

    public SimplePattern(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Pattern must be non-null");
        }
        this.originalPattern = string;
        this.realPattern = this.normalize(string);
    }

    public String getSimplePattern() {
        return this.originalPattern;
    }

    public boolean matches(String string) {
        return this.realPattern.matcher(string).matches();
    }

    private Pattern normalize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '*') {
                stringBuilder.append(".*");
                continue;
            }
            if (this.isRegexpCharacter(c2)) {
                stringBuilder.append("\\").append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return Pattern.compile(stringBuilder.toString());
    }

    private boolean isRegexpCharacter(char c2) {
        char[] cArray;
        for (char c3 : cArray = new char[]{'$', '^', '.', '+', '?', '[', ']', '(', ')', '\\', '-'}) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.originalPattern;
    }
}

