/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cesyb.document;

import com.contrastsecurity.thirdparty.cesyb.Version;
import com.contrastsecurity.thirdparty.cesyb.YamlException;
import com.contrastsecurity.thirdparty.cesyb.document.YamlAlias;
import com.contrastsecurity.thirdparty.cesyb.document.YamlDocument;
import com.contrastsecurity.thirdparty.cesyb.document.YamlElement;
import com.contrastsecurity.thirdparty.cesyb.document.YamlEntry;
import com.contrastsecurity.thirdparty.cesyb.document.YamlMapping;
import com.contrastsecurity.thirdparty.cesyb.document.YamlScalar;
import com.contrastsecurity.thirdparty.cesyb.document.YamlSequence;
import com.contrastsecurity.thirdparty.cesyb.parser.AliasEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.Event;
import com.contrastsecurity.thirdparty.cesyb.parser.EventType;
import com.contrastsecurity.thirdparty.cesyb.parser.MappingStartEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.Parser;
import com.contrastsecurity.thirdparty.cesyb.parser.ScalarEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.SequenceStartEvent;
import com.contrastsecurity.thirdparty.cesyb.tokenizer.Tokenizer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDocumentReader {
    Parser parser;

    public YamlDocumentReader(String string) {
        this(new StringReader(string));
    }

    public YamlDocumentReader(String string, Version version) {
        this(new StringReader(string), version);
    }

    public YamlDocumentReader(Reader reader) {
        this(reader, null);
    }

    public YamlDocumentReader(Reader reader, Version version) {
        if (version == null) {
            version = Version.DEFAULT_VERSION;
        }
        this.parser = new Parser(reader, version);
    }

    public YamlDocument read() throws YamlException {
        return this.read(YamlDocument.class);
    }

    public <T> T read(Class<T> clazz) throws YamlException {
        try {
            block8: while (true) {
                Event event;
                if ((event = this.parser.peekNextEvent()) == null) {
                    return null;
                }
                switch (event.type) {
                    case STREAM_START: {
                        this.parser.getNextEvent();
                        continue block8;
                    }
                    case STREAM_END: {
                        this.parser.getNextEvent();
                        return null;
                    }
                    case DOCUMENT_START: {
                        this.parser.getNextEvent();
                        return (T)this.readDocument();
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Parser.ParserException parserException) {
            throw new YamlException("Error parsing YAML.", parserException);
        }
        catch (Tokenizer.TokenizerException tokenizerException) {
            throw new YamlException("Error tokenizing YAML.", tokenizerException);
        }
    }

    public <T> Iterator<T> readAll(final Class<T> clazz) {
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                Event event = YamlDocumentReader.this.parser.peekNextEvent();
                return event != null && event.type != EventType.STREAM_END;
            }

            @Override
            public T next() {
                try {
                    return YamlDocumentReader.this.read(clazz);
                }
                catch (YamlException yamlException) {
                    throw new RuntimeException("Iterative reading documents exception", yamlException);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    private YamlElement readDocument() {
        YamlElement yamlElement = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case SCALAR: {
                yamlElement = this.readScalar();
                break;
            }
            case ALIAS: {
                yamlElement = this.readAlias();
                break;
            }
            case MAPPING_START: {
                yamlElement = this.readMapping();
                break;
            }
            case SEQUENCE_START: {
                yamlElement = this.readSequence();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.parser.getNextEvent();
        return yamlElement;
    }

    private YamlMapping readMapping() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.MAPPING_START) {
            throw new IllegalStateException();
        }
        YamlMapping yamlMapping = new YamlMapping();
        MappingStartEvent mappingStartEvent = (MappingStartEvent)event;
        yamlMapping.setTag(mappingStartEvent.tag);
        yamlMapping.setAnchor(mappingStartEvent.anchor);
        this.readMappingElements(yamlMapping);
        return yamlMapping;
    }

    private void readMappingElements(YamlMapping yamlMapping) {
        while (true) {
            Event event = this.parser.peekNextEvent();
            if (event.type == EventType.MAPPING_END) {
                this.parser.getNextEvent();
                return;
            }
            YamlEntry yamlEntry = this.readEntry();
            yamlMapping.addEntry(yamlEntry);
        }
    }

    private YamlEntry readEntry() {
        YamlScalar yamlScalar = this.readScalar();
        YamlElement yamlElement = this.readValue();
        return new YamlEntry(yamlScalar, yamlElement);
    }

    private YamlElement readValue() {
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case SCALAR: {
                return this.readScalar();
            }
            case ALIAS: {
                return this.readAlias();
            }
            case MAPPING_START: {
                return this.readMapping();
            }
            case SEQUENCE_START: {
                return this.readSequence();
            }
        }
        throw new IllegalStateException();
    }

    private YamlAlias readAlias() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.ALIAS) {
            throw new IllegalStateException();
        }
        YamlAlias yamlAlias = new YamlAlias();
        AliasEvent aliasEvent = (AliasEvent)event;
        yamlAlias.setAnchor(aliasEvent.anchor);
        return yamlAlias;
    }

    private YamlSequence readSequence() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.SEQUENCE_START) {
            throw new IllegalStateException();
        }
        YamlSequence yamlSequence = new YamlSequence();
        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)event;
        yamlSequence.setTag(sequenceStartEvent.tag);
        yamlSequence.setAnchor(sequenceStartEvent.anchor);
        this.readSequenceElements(yamlSequence);
        return yamlSequence;
    }

    private void readSequenceElements(YamlSequence yamlSequence) {
        while (true) {
            Event event = this.parser.peekNextEvent();
            if (event.type == EventType.SEQUENCE_END) {
                this.parser.getNextEvent();
                return;
            }
            YamlElement yamlElement = this.readValue();
            yamlSequence.addElement(yamlElement);
        }
    }

    private YamlScalar readScalar() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.SCALAR) {
            throw new IllegalStateException();
        }
        ScalarEvent scalarEvent = (ScalarEvent)event;
        YamlScalar yamlScalar = new YamlScalar();
        yamlScalar.setTag(scalarEvent.tag);
        yamlScalar.setAnchor(scalarEvent.anchor);
        yamlScalar.setValue(scalarEvent.value);
        return yamlScalar;
    }
}

