/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.gson;

import com.contrastsecurity.thirdparty.cggl.gson.JsonElement;
import com.contrastsecurity.thirdparty.cggl.gson.JsonIOException;
import com.contrastsecurity.thirdparty.cggl.gson.JsonParseException;
import com.contrastsecurity.thirdparty.cggl.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.cggl.gson.internal.Streams;
import com.contrastsecurity.thirdparty.cggl.gson.stream.JsonReader;
import com.contrastsecurity.thirdparty.cggl.gson.stream.JsonToken;
import com.contrastsecurity.thirdparty.cggl.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String string) {
        this(new StringReader(string));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source to Json", stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source to Json", outOfMemoryError);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException(malformedJsonException);
            }
            catch (IOException iOException) {
                throw new JsonIOException(iOException);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

