/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.BooleanArrayList;
import com.contrastsecurity.thirdparty.cggl.protobuf.ByteString;
import com.contrastsecurity.thirdparty.cggl.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.cggl.protobuf.DoubleArrayList;
import com.contrastsecurity.thirdparty.cggl.protobuf.ExtensionRegistryLite;
import com.contrastsecurity.thirdparty.cggl.protobuf.FloatArrayList;
import com.contrastsecurity.thirdparty.cggl.protobuf.IntArrayList;
import com.contrastsecurity.thirdparty.cggl.protobuf.Internal;
import com.contrastsecurity.thirdparty.cggl.protobuf.InvalidProtocolBufferException;
import com.contrastsecurity.thirdparty.cggl.protobuf.LazyStringList;
import com.contrastsecurity.thirdparty.cggl.protobuf.LongArrayList;
import com.contrastsecurity.thirdparty.cggl.protobuf.MapEntryLite;
import com.contrastsecurity.thirdparty.cggl.protobuf.Protobuf;
import com.contrastsecurity.thirdparty.cggl.protobuf.Reader;
import com.contrastsecurity.thirdparty.cggl.protobuf.Schema;
import com.contrastsecurity.thirdparty.cggl.protobuf.Utf8;
import com.contrastsecurity.thirdparty.cggl.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

abstract class BinaryReader
implements Reader {
    private static final int FIXED32_MULTIPLE_MASK = 3;
    private static final int FIXED64_MULTIPLE_MASK = 7;

    public static BinaryReader newInstance(ByteBuffer byteBuffer, boolean bl2) {
        if (byteBuffer.hasArray()) {
            return new SafeHeapReader(byteBuffer, bl2);
        }
        throw new IllegalArgumentException("Direct buffers not yet supported");
    }

    private BinaryReader() {
    }

    public abstract int getTotalBytesRead();

    @Override
    public boolean shouldDiscardUnknownFields() {
        return false;
    }

    private static final class SafeHeapReader
    extends BinaryReader {
        private final boolean bufferIsImmutable;
        private final byte[] buffer;
        private int pos;
        private final int initialPos;
        private int limit;
        private int tag;
        private int endGroupTag;

        public SafeHeapReader(ByteBuffer byteBuffer, boolean bl2) {
            this.bufferIsImmutable = bl2;
            this.buffer = byteBuffer.array();
            this.initialPos = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
            this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
        }

        private boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        public int getTotalBytesRead() {
            return this.pos - this.initialPos;
        }

        @Override
        public int getFieldNumber() throws IOException {
            if (this.isAtEnd()) {
                return Integer.MAX_VALUE;
            }
            this.tag = this.readVarint32();
            if (this.tag == this.endGroupTag) {
                return Integer.MAX_VALUE;
            }
            return WireFormat.getTagFieldNumber(this.tag);
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public boolean skipField() throws IOException {
            if (this.isAtEnd() || this.tag == this.endGroupTag) {
                return false;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    this.skipVarint();
                    return true;
                }
                case 1: {
                    this.skipBytes(8);
                    return true;
                }
                case 2: {
                    this.skipBytes(this.readVarint32());
                    return true;
                }
                case 5: {
                    this.skipBytes(4);
                    return true;
                }
                case 3: {
                    this.skipGroup();
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public double readDouble() throws IOException {
            this.requireWireType(1);
            return Double.longBitsToDouble(this.readLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            this.requireWireType(5);
            return Float.intBitsToFloat(this.readLittleEndian32());
        }

        @Override
        public long readUInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public long readInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public int readInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public int readFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public boolean readBool() throws IOException {
            this.requireWireType(0);
            return this.readVarint32() != 0;
        }

        @Override
        public String readString() throws IOException {
            return this.readStringInternal(false);
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            return this.readStringInternal(true);
        }

        public String readStringInternal(boolean bl2) throws IOException {
            this.requireWireType(2);
            int n2 = this.readVarint32();
            if (n2 == 0) {
                return "";
            }
            this.requireBytes(n2);
            if (bl2 && !Utf8.isValidUtf8(this.buffer, this.pos, this.pos + n2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
            this.pos += n2;
            return string;
        }

        @Override
        public <T> T readMessage(Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(2);
            return (T)this.readMessage(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
        }

        @Override
        public <T> T readMessageBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(2);
            return this.readMessage(schema, extensionRegistryLite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T readMessage(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n2;
            int n3 = this.readVarint32();
            this.requireBytes(n3);
            int n4 = this.limit;
            this.limit = n2 = this.pos + n3;
            try {
                T t2 = schema.newInstance();
                schema.mergeFrom(t2, this, extensionRegistryLite);
                schema.makeImmutable(t2);
                if (this.pos != n2) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                T t3 = t2;
                return t3;
            }
            finally {
                this.limit = n4;
            }
        }

        @Override
        public <T> T readGroup(Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(3);
            return (T)this.readGroup(Protobuf.getInstance().schemaFor(clazz), extensionRegistryLite);
        }

        @Override
        public <T> T readGroupBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.requireWireType(3);
            return this.readGroup(schema, extensionRegistryLite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T readGroup(Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n2 = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            try {
                T t2 = schema.newInstance();
                schema.mergeFrom(t2, this, extensionRegistryLite);
                schema.makeImmutable(t2);
                if (this.tag != this.endGroupTag) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                T t3 = t2;
                return t3;
            }
            finally {
                this.endGroupTag = n2;
            }
        }

        @Override
        public ByteString readBytes() throws IOException {
            this.requireWireType(2);
            int n2 = this.readVarint32();
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            this.requireBytes(n2);
            ByteString byteString = this.bufferIsImmutable ? ByteString.wrap(this.buffer, this.pos, n2) : ByteString.copyFrom(this.buffer, this.pos, n2);
            this.pos += n2;
            return byteString;
        }

        @Override
        public int readUInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public int readEnum() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public int readSFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public long readSFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public int readSInt32() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag32(this.readVarint32());
        }

        @Override
        public long readSInt64() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag64(this.readVarint64());
        }

        @Override
        public void readDoubleList(List<Double> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof DoubleArrayList)) break block14;
                    DoubleArrayList doubleArrayList = (DoubleArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            this.verifyPackedFixed64Length(n2);
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                doubleArrayList.addDouble(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                            }
                            break block15;
                        }
                        case 1: {
                            int n4;
                            int n5;
                            do {
                                doubleArrayList.addDouble(this.readDouble());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        this.verifyPackedFixed64Length(n6);
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                        }
                        break;
                    }
                    case 1: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readDouble());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readFloatList(List<Float> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof FloatArrayList)) break block14;
                    FloatArrayList floatArrayList = (FloatArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            this.verifyPackedFixed32Length(n2);
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                floatArrayList.addFloat(Float.intBitsToFloat(this.readLittleEndian32_NoCheck()));
                            }
                            break block15;
                        }
                        case 5: {
                            int n4;
                            int n5;
                            do {
                                floatArrayList.addFloat(this.readFloat());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        this.verifyPackedFixed32Length(n6);
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(Float.valueOf(Float.intBitsToFloat(this.readLittleEndian32_NoCheck())));
                        }
                        break;
                    }
                    case 5: {
                        int n8;
                        int n9;
                        do {
                            list.add(Float.valueOf(this.readFloat()));
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readUInt64List(List<Long> list) throws IOException {
            if (list instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            longArrayList.addLong(this.readVarint64());
                        }
                        this.requirePosition(n3);
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            longArrayList.addLong(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readVarint64());
                        }
                        this.requirePosition(n7);
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readInt64List(List<Long> list) throws IOException {
            if (list instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            longArrayList.addLong(this.readVarint64());
                        }
                        this.requirePosition(n3);
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            longArrayList.addLong(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readVarint64());
                        }
                        this.requirePosition(n7);
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readInt32List(List<Integer> list) throws IOException {
            if (list instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            intArrayList.addInt(this.readVarint32());
                        }
                        this.requirePosition(n3);
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            intArrayList.addInt(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readVarint32());
                        }
                        this.requirePosition(n7);
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readFixed64List(List<Long> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            this.verifyPackedFixed64Length(n2);
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                longArrayList.addLong(this.readLittleEndian64_NoCheck());
                            }
                            break block15;
                        }
                        case 1: {
                            int n4;
                            int n5;
                            do {
                                longArrayList.addLong(this.readFixed64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        this.verifyPackedFixed64Length(n6);
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readFixed32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            this.verifyPackedFixed32Length(n2);
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                intArrayList.addInt(this.readLittleEndian32_NoCheck());
                            }
                            break block15;
                        }
                        case 5: {
                            int n4;
                            int n5;
                            do {
                                intArrayList.addInt(this.readFixed32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        this.verifyPackedFixed32Length(n6);
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readBoolList(List<Boolean> list) throws IOException {
            if (list instanceof BooleanArrayList) {
                BooleanArrayList booleanArrayList = (BooleanArrayList)list;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            booleanArrayList.addBoolean(this.readVarint32() != 0);
                        }
                        this.requirePosition(n3);
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            booleanArrayList.addBoolean(this.readBool());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            } else {
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readVarint32() != 0);
                        }
                        this.requirePosition(n7);
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readBool());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readStringList(List<String> list) throws IOException {
            this.readStringListInternal(list, false);
        }

        @Override
        public void readStringListRequireUtf8(List<String> list) throws IOException {
            this.readStringListInternal(list, true);
        }

        public void readStringListInternal(List<String> list, boolean bl2) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            if (list instanceof LazyStringList && !bl2) {
                int n4;
                int n5;
                LazyStringList lazyStringList = (LazyStringList)list;
                do {
                    lazyStringList.add(this.readBytes());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n4 = this.pos;
                } while ((n5 = this.readVarint32()) == this.tag);
                this.pos = n4;
                return;
            }
            do {
                list.add(this.readStringInternal(bl2));
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == this.tag);
            this.pos = n2;
        }

        @Override
        public <T> void readMessageList(List<T> list, Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(clazz);
            this.readMessageList(list, schema, extensionRegistryLite);
        }

        @Override
        public <T> void readMessageList(List<T> list, Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n4 = this.tag;
            do {
                list.add(this.readMessage(schema, extensionRegistryLite));
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == n4);
            this.pos = n2;
        }

        @Override
        public <T> void readGroupList(List<T> list, Class<T> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(clazz);
            this.readGroupList(list, schema, extensionRegistryLite);
        }

        @Override
        public <T> void readGroupList(List<T> list, Schema<T> schema, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 3) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n4 = this.tag;
            do {
                list.add(this.readGroup(schema, extensionRegistryLite));
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == n4);
            this.pos = n2;
        }

        @Override
        public void readBytesList(List<ByteString> list) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            do {
                list.add(this.readBytes());
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == this.tag);
            this.pos = n2;
        }

        @Override
        public void readUInt32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                intArrayList.addInt(this.readVarint32());
                            }
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                intArrayList.addInt(this.readUInt32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readUInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readEnumList(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                intArrayList.addInt(this.readVarint32());
                            }
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                intArrayList.addInt(this.readEnum());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readEnum());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSFixed32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            this.verifyPackedFixed32Length(n2);
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                intArrayList.addInt(this.readLittleEndian32_NoCheck());
                            }
                            break block15;
                        }
                        case 5: {
                            int n4;
                            int n5;
                            do {
                                intArrayList.addInt(this.readSFixed32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        this.verifyPackedFixed32Length(n6);
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readSFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSFixed64List(List<Long> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            this.verifyPackedFixed64Length(n2);
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                longArrayList.addLong(this.readLittleEndian64_NoCheck());
                            }
                            break block15;
                        }
                        case 1: {
                            int n4;
                            int n5;
                            do {
                                longArrayList.addLong(this.readSFixed64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        this.verifyPackedFixed64Length(n6);
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readSFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSInt32List(List<Integer> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                intArrayList.addInt(CodedInputStream.decodeZigZag32(this.readVarint32()));
                            }
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                intArrayList.addInt(this.readSInt32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(CodedInputStream.decodeZigZag32(this.readVarint32()));
                        }
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readSInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        @Override
        public void readSInt64List(List<Long> list) throws IOException {
            block15: {
                block14: {
                    if (!(list instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)list;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                longArrayList.addLong(CodedInputStream.decodeZigZag64(this.readVarint64()));
                            }
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                longArrayList.addLong(this.readSInt64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            list.add(CodedInputStream.decodeZigZag64(this.readVarint64()));
                        }
                        break;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            list.add(this.readSInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> void readMap(Map<K, V> map, MapEntryLite.Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n2;
            this.requireWireType(2);
            int n3 = this.readVarint32();
            this.requireBytes(n3);
            int n4 = this.limit;
            this.limit = n2 = this.pos + n3;
            try {
                int n5;
                Object object = metadata.defaultKey;
                Object object2 = metadata.defaultValue;
                block9: while ((n5 = this.getFieldNumber()) != Integer.MAX_VALUE) {
                    try {
                        switch (n5) {
                            case 1: {
                                object = this.readField(metadata.keyType, null, null);
                                break;
                            }
                            case 2: {
                                object2 = this.readField(metadata.valueType, metadata.defaultValue.getClass(), extensionRegistryLite);
                                break;
                            }
                            default: {
                                if (this.skipField()) continue block9;
                                throw new InvalidProtocolBufferException("Unable to parse map entry.");
                            }
                        }
                    }
                    catch (InvalidProtocolBufferException.InvalidWireTypeException invalidWireTypeException) {
                        if (this.skipField()) continue;
                        throw new InvalidProtocolBufferException("Unable to parse map entry.");
                    }
                }
                map.put(object, object2);
            }
            finally {
                this.limit = n4;
            }
        }

        private Object readField(WireFormat.FieldType fieldType, Class<?> clazz, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            switch (fieldType) {
                case BOOL: {
                    return this.readBool();
                }
                case BYTES: {
                    return this.readBytes();
                }
                case DOUBLE: {
                    return this.readDouble();
                }
                case ENUM: {
                    return this.readEnum();
                }
                case FIXED32: {
                    return this.readFixed32();
                }
                case FIXED64: {
                    return this.readFixed64();
                }
                case FLOAT: {
                    return Float.valueOf(this.readFloat());
                }
                case INT32: {
                    return this.readInt32();
                }
                case INT64: {
                    return this.readInt64();
                }
                case MESSAGE: {
                    return this.readMessage(clazz, extensionRegistryLite);
                }
                case SFIXED32: {
                    return this.readSFixed32();
                }
                case SFIXED64: {
                    return this.readSFixed64();
                }
                case SINT32: {
                    return this.readSInt32();
                }
                case SINT64: {
                    return this.readSInt64();
                }
                case STRING: {
                    return this.readStringRequireUtf8();
                }
                case UINT32: {
                    return this.readUInt32();
                }
                case UINT64: {
                    return this.readUInt64();
                }
            }
            throw new RuntimeException("unsupported field type.");
        }

        private int readVarint32() throws IOException {
            int n2;
            int n3 = this.pos;
            if (this.limit == this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 = this.buffer[n3++]) >= 0) {
                this.pos = n3;
                return n2;
            }
            if (this.limit - n3 < 9) {
                return (int)this.readVarint64SlowPath();
            }
            if ((n2 ^= this.buffer[n3++] << 7) < 0) {
                n2 ^= 0xFFFFFF80;
            } else if ((n2 ^= this.buffer[n3++] << 14) >= 0) {
                n2 ^= 0x3F80;
            } else if ((n2 ^= this.buffer[n3++] << 21) < 0) {
                n2 ^= 0xFFE03F80;
            } else {
                byte by = this.buffer[n3++];
                n2 ^= by << 28;
                n2 ^= 0xFE03F80;
                if (by < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = n3;
            return n2;
        }

        public long readVarint64() throws IOException {
            long l2;
            int n2;
            int n3 = this.pos;
            if (this.limit == n3) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            if ((n2 = byArray[n3++]) >= 0) {
                this.pos = n3;
                return n2;
            }
            if (this.limit - n3 < 9) {
                return this.readVarint64SlowPath();
            }
            if ((n2 ^= byArray[n3++] << 7) < 0) {
                l2 = n2 ^ 0xFFFFFF80;
            } else if ((n2 ^= byArray[n3++] << 14) >= 0) {
                l2 = n2 ^ 0x3F80;
            } else if ((n2 ^= byArray[n3++] << 21) < 0) {
                l2 = n2 ^ 0xFFE03F80;
            } else if ((l2 = (long)n2 ^ (long)byArray[n3++] << 28) >= 0L) {
                l2 ^= 0xFE03F80L;
            } else if ((l2 ^= (long)byArray[n3++] << 35) < 0L) {
                l2 ^= 0xFFFFFFF80FE03F80L;
            } else if ((l2 ^= (long)byArray[n3++] << 42) >= 0L) {
                l2 ^= 0x3F80FE03F80L;
            } else if ((l2 ^= (long)byArray[n3++] << 49) < 0L) {
                l2 ^= 0xFFFE03F80FE03F80L;
            } else {
                l2 ^= (long)byArray[n3++] << 56;
                if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n3++] < 0L) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = n3;
            return l2;
        }

        private long readVarint64SlowPath() throws IOException {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by = this.readByte();
                l2 |= (long)(by & 0x7F) << i2;
                if ((by & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private byte readByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        private int readLittleEndian32() throws IOException {
            this.requireBytes(4);
            return this.readLittleEndian32_NoCheck();
        }

        private long readLittleEndian64() throws IOException {
            this.requireBytes(8);
            return this.readLittleEndian64_NoCheck();
        }

        private int readLittleEndian32_NoCheck() {
            int n2 = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n2 + 4;
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }

        private long readLittleEndian64_NoCheck() {
            int n2 = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n2 + 8;
            return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
        }

        private void skipVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                byte[] byArray = this.buffer;
                int n2 = this.pos;
                for (int i2 = 0; i2 < 10; ++i2) {
                    if (byArray[n2++] < 0) continue;
                    this.pos = n2;
                    return;
                }
            }
            this.skipVarintSlowPath();
        }

        private void skipVarintSlowPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipBytes(int n2) throws IOException {
            this.requireBytes(n2);
            this.pos += n2;
        }

        private void skipGroup() throws IOException {
            int n2 = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            while (this.getFieldNumber() != Integer.MAX_VALUE && this.skipField()) {
            }
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.endGroupTag = n2;
        }

        private void requireBytes(int n2) throws IOException {
            if (n2 < 0 || n2 > this.limit - this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private void requireWireType(int n2) throws IOException {
            if (WireFormat.getTagWireType(this.tag) != n2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        private void verifyPackedFixed64Length(int n2) throws IOException {
            this.requireBytes(n2);
            if ((n2 & 7) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void verifyPackedFixed32Length(int n2) throws IOException {
            this.requireBytes(n2);
            if ((n2 & 3) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void requirePosition(int n2) throws IOException {
            if (this.pos != n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }
    }
}

