/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.AbstractProtobufList;
import com.contrastsecurity.thirdparty.cggl.protobuf.Internal;
import com.contrastsecurity.thirdparty.cggl.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class FloatArrayList
extends AbstractProtobufList<Float>
implements Internal.FloatList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final FloatArrayList EMPTY_LIST = new FloatArrayList(new float[0], 0);
    private float[] array;
    private int size;

    public static FloatArrayList emptyList() {
        return EMPTY_LIST;
    }

    FloatArrayList() {
        this(new float[10], 0);
    }

    private FloatArrayList(float[] fArray, int n2) {
        this.array = fArray;
        this.size = n2;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        this.ensureIsMutable();
        if (n3 < n2) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n3, this.array, n2, this.size - n3);
        this.size -= n3 - n2;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatArrayList)) {
            return super.equals(object);
        }
        FloatArrayList floatArrayList = (FloatArrayList)object;
        if (this.size != floatArrayList.size) {
            return false;
        }
        float[] fArray = floatArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (Float.floatToIntBits(this.array[i2]) == Float.floatToIntBits(fArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = 31 * n2 + Float.floatToIntBits(this.array[i2]);
        }
        return n2;
    }

    @Override
    public Internal.FloatList mutableCopyWithCapacity(int n2) {
        if (n2 < this.size) {
            throw new IllegalArgumentException();
        }
        return new FloatArrayList(Arrays.copyOf(this.array, n2), this.size);
    }

    @Override
    public Float get(int n2) {
        return Float.valueOf(this.getFloat(n2));
    }

    @Override
    public float getFloat(int n2) {
        this.ensureIndexInRange(n2);
        return this.array[n2];
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Float)) {
            return -1;
        }
        float f2 = ((Float)object).floatValue();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.array[i2] != f2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float set(int n2, Float f2) {
        return Float.valueOf(this.setFloat(n2, f2.floatValue()));
    }

    @Override
    public float setFloat(int n2, float f2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        float f3 = this.array[n2];
        this.array[n2] = f2;
        return f3;
    }

    @Override
    public boolean add(Float f2) {
        this.addFloat(f2.floatValue());
        return true;
    }

    @Override
    public void add(int n2, Float f2) {
        this.addFloat(n2, f2.floatValue());
    }

    @Override
    public void addFloat(float f2) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            float[] fArray = new float[n2];
            System.arraycopy(this.array, 0, fArray, 0, this.size);
            this.array = fArray;
        }
        this.array[this.size++] = f2;
    }

    private void addFloat(int n2, float f2) {
        this.ensureIsMutable();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        } else {
            int n3 = this.size * 3 / 2 + 1;
            float[] fArray = new float[n3];
            System.arraycopy(this.array, 0, fArray, 0, n2);
            System.arraycopy(this.array, n2, fArray, n2 + 1, this.size - n2);
            this.array = fArray;
        }
        this.array[n2] = f2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof FloatArrayList)) {
            return super.addAll(collection);
        }
        FloatArrayList floatArrayList = (FloatArrayList)collection;
        if (floatArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < floatArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + floatArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(floatArrayList.array, 0, this.array, this.size, floatArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public Float remove(int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        float f2 = this.array[n2];
        if (n2 < this.size - 1) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.size - n2 - 1);
        }
        --this.size;
        ++this.modCount;
        return Float.valueOf(f2);
    }

    private void ensureIndexInRange(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n2) {
        return "Index:" + n2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

