/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.AbstractProtobufList;
import com.contrastsecurity.thirdparty.cggl.protobuf.Internal;
import com.contrastsecurity.thirdparty.cggl.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class IntArrayList
extends AbstractProtobufList<Integer>
implements Internal.IntList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final IntArrayList EMPTY_LIST = new IntArrayList(new int[0], 0);
    private int[] array;
    private int size;

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    IntArrayList() {
        this(new int[10], 0);
    }

    private IntArrayList(int[] nArray, int n2) {
        this.array = nArray;
        this.size = n2;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        this.ensureIsMutable();
        if (n3 < n2) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n3, this.array, n2, this.size - n3);
        this.size -= n3 - n2;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntArrayList)) {
            return super.equals(object);
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (this.size != intArrayList.size) {
            return false;
        }
        int[] nArray = intArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == nArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = 31 * n2 + this.array[i2];
        }
        return n2;
    }

    @Override
    public Internal.IntList mutableCopyWithCapacity(int n2) {
        if (n2 < this.size) {
            throw new IllegalArgumentException();
        }
        return new IntArrayList(Arrays.copyOf(this.array, n2), this.size);
    }

    @Override
    public Integer get(int n2) {
        return this.getInt(n2);
    }

    @Override
    public int getInt(int n2) {
        this.ensureIndexInRange(n2);
        return this.array[n2];
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n2 = (Integer)object;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.array[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Integer set(int n2, Integer n3) {
        return this.setInt(n2, n3);
    }

    @Override
    public int setInt(int n2, int n3) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        int n4 = this.array[n2];
        this.array[n2] = n3;
        return n4;
    }

    @Override
    public boolean add(Integer n2) {
        this.addInt(n2);
        return true;
    }

    @Override
    public void add(int n2, Integer n3) {
        this.addInt(n2, n3);
    }

    @Override
    public void addInt(int n2) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n3 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n3];
            System.arraycopy(this.array, 0, nArray, 0, this.size);
            this.array = nArray;
        }
        this.array[this.size++] = n2;
    }

    private void addInt(int n2, int n3) {
        this.ensureIsMutable();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        } else {
            int n4 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n4];
            System.arraycopy(this.array, 0, nArray, 0, n2);
            System.arraycopy(this.array, n2, nArray, n2 + 1, this.size - n2);
            this.array = nArray;
        }
        this.array[n2] = n3;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof IntArrayList)) {
            return super.addAll(collection);
        }
        IntArrayList intArrayList = (IntArrayList)collection;
        if (intArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < intArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + intArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(intArrayList.array, 0, this.array, this.size, intArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public Integer remove(int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        int n3 = this.array[n2];
        if (n2 < this.size - 1) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.size - n2 - 1);
        }
        --this.size;
        ++this.modCount;
        return n3;
    }

    private void ensureIndexInRange(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n2) {
        return "Index:" + n2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

