/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.cggl.protobuf.Descriptors;
import com.contrastsecurity.thirdparty.cggl.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeRegistry {
    private static final e logger = e.a(TypeRegistry.class.getName());
    private final Map<String, Descriptors.Descriptor> types;

    public static TypeRegistry getEmptyTypeRegistry() {
        return EmptyTypeRegistryHolder.EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Descriptors.Descriptor find(String string) {
        return this.types.get(string);
    }

    public final Descriptors.Descriptor getDescriptorForTypeUrl(String string) throws InvalidProtocolBufferException {
        return this.find(TypeRegistry.getTypeName(string));
    }

    TypeRegistry(Map<String, Descriptors.Descriptor> map) {
        this.types = map;
    }

    private static String getTypeName(String string) throws InvalidProtocolBufferException {
        String[] stringArray = string.split("/");
        if (stringArray.length == 1) {
            throw new InvalidProtocolBufferException("Invalid type url found: " + string);
        }
        return stringArray[stringArray.length - 1];
    }

    public static final class Builder {
        private final Set<String> files = new HashSet<String>();
        private Map<String, Descriptors.Descriptor> types = new HashMap<String, Descriptors.Descriptor>();

        private Builder() {
        }

        public Builder add(Descriptors.Descriptor descriptor) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            this.addFile(descriptor.getFile());
            return this;
        }

        public Builder add(Iterable<Descriptors.Descriptor> iterable) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            for (Descriptors.Descriptor descriptor : iterable) {
                this.addFile(descriptor.getFile());
            }
            return this;
        }

        public TypeRegistry build() {
            TypeRegistry typeRegistry = new TypeRegistry(this.types);
            this.types = null;
            return typeRegistry;
        }

        private void addFile(Descriptors.FileDescriptor fileDescriptor) {
            if (!this.files.add(fileDescriptor.getFullName())) {
                return;
            }
            for (Descriptors.FileDescriptor genericDescriptor : fileDescriptor.getDependencies()) {
                this.addFile(genericDescriptor);
            }
            for (Descriptors.Descriptor descriptor : fileDescriptor.getMessageTypes()) {
                this.addMessage(descriptor);
            }
        }

        private void addMessage(Descriptors.Descriptor descriptor) {
            for (Descriptors.Descriptor descriptor2 : descriptor.getNestedTypes()) {
                this.addMessage(descriptor2);
            }
            if (this.types.containsKey(descriptor.getFullName())) {
                logger.c("Type " + descriptor.getFullName() + " is added multiple times.");
                return;
            }
            this.types.put(descriptor.getFullName(), descriptor);
        }
    }

    private static class EmptyTypeRegistryHolder {
        private static final TypeRegistry EMPTY = new TypeRegistry(Collections.emptyMap());

        private EmptyTypeRegistryHolder() {
        }
    }
}

