/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client;

import com.contrastsecurity.thirdparty.crmq.client.SocketConfigurator;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public abstract class SocketConfigurators {
    public static final AbstractSocketConfigurator DISABLE_NAGLE_ALGORITHM;
    public static final AbstractSocketConfigurator DEFAULT;
    public static final AbstractSocketConfigurator ENABLE_HOSTNAME_VERIFICATION;

    static final SSLParameters enableHostnameVerification(SSLParameters sSLParameters) {
        if (sSLParameters == null) {
            sSLParameters = new SSLParameters();
        }
        sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sSLParameters;
    }

    public static AbstractSocketConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static AbstractSocketConfigurator disableNagleAlgorithm() {
        return DISABLE_NAGLE_ALGORITHM;
    }

    public static AbstractSocketConfigurator enableHostnameVerification() {
        return ENABLE_HOSTNAME_VERIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT = DISABLE_NAGLE_ALGORITHM = new AbstractSocketConfigurator(){

            @Override
            public void configure(Socket socket) throws IOException {
                socket.setTcpNoDelay(true);
            }
        };
        ENABLE_HOSTNAME_VERIFICATION = new AbstractSocketConfigurator(){

            @Override
            public void configure(Socket socket) {
                if (socket instanceof SSLSocket) {
                    SSLSocket sSLSocket = (SSLSocket)socket;
                    SSLParameters sSLParameters = SocketConfigurators.enableHostnameVerification(sSLSocket.getSSLParameters());
                    sSLSocket.setSSLParameters(sSLParameters);
                }
            }
        };
    }

    public static class Builder {
        private AbstractSocketConfigurator configurator = new AbstractSocketConfigurator(){

            @Override
            public void configure(Socket socket) {
            }
        };

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder disableNagleAlgorithm() {
            this.configurator = this.configurator.andThen(DISABLE_NAGLE_ALGORITHM);
            return this;
        }

        public Builder enableHostnameVerification() {
            this.configurator = this.configurator.andThen(ENABLE_HOSTNAME_VERIFICATION);
            return this;
        }

        public Builder add(SocketConfigurator socketConfigurator) {
            this.configurator = this.configurator.andThen(socketConfigurator);
            return this;
        }

        public SocketConfigurator build() {
            return this.configurator;
        }
    }

    public static abstract class AbstractSocketConfigurator
    implements SocketConfigurator {
        public AbstractSocketConfigurator andThen(final SocketConfigurator socketConfigurator) {
            if (socketConfigurator == null) {
                throw new NullPointerException();
            }
            return new AbstractSocketConfigurator(){

                @Override
                public void configure(Socket socket) throws IOException {
                    AbstractSocketConfigurator.this.configure(socket);
                    socketConfigurator.configure(socket);
                }
            };
        }
    }
}

