/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl.recovery;

import com.contrastsecurity.thirdparty.crmq.client.Address;
import com.contrastsecurity.thirdparty.crmq.client.AddressResolver;
import com.contrastsecurity.thirdparty.crmq.client.ListAddressResolver;
import com.contrastsecurity.thirdparty.crmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.crmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.crmq.client.impl.ConnectionParams;
import com.contrastsecurity.thirdparty.crmq.client.impl.FrameHandler;
import com.contrastsecurity.thirdparty.crmq.client.impl.FrameHandlerFactory;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RecoveryAwareAMQConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class RecoveryAwareAMQConnectionFactory {
    private final ConnectionParams params;
    private final FrameHandlerFactory factory;
    private final AddressResolver addressResolver;
    private final MetricsCollector metricsCollector;

    public RecoveryAwareAMQConnectionFactory(ConnectionParams connectionParams, FrameHandlerFactory frameHandlerFactory, List<Address> list) {
        this(connectionParams, frameHandlerFactory, new ListAddressResolver(list), new NoOpMetricsCollector());
    }

    public RecoveryAwareAMQConnectionFactory(ConnectionParams connectionParams, FrameHandlerFactory frameHandlerFactory, AddressResolver addressResolver) {
        this(connectionParams, frameHandlerFactory, addressResolver, new NoOpMetricsCollector());
    }

    public RecoveryAwareAMQConnectionFactory(ConnectionParams connectionParams, FrameHandlerFactory frameHandlerFactory, AddressResolver addressResolver, MetricsCollector metricsCollector) {
        this.params = connectionParams;
        this.factory = frameHandlerFactory;
        this.addressResolver = addressResolver;
        this.metricsCollector = metricsCollector;
    }

    public RecoveryAwareAMQConnection newConnection() throws IOException, TimeoutException {
        Exception exception = null;
        List<Address> list = RecoveryAwareAMQConnectionFactory.shuffle(this.addressResolver.getAddresses());
        for (Address address : list) {
            try {
                FrameHandler frameHandler = this.factory.create(address);
                RecoveryAwareAMQConnection recoveryAwareAMQConnection = this.createConnection(this.params, frameHandler, this.metricsCollector);
                recoveryAwareAMQConnection.start();
                this.metricsCollector.newConnection(recoveryAwareAMQConnection);
                return recoveryAwareAMQConnection;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (TimeoutException timeoutException) {
                exception = timeoutException;
            }
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof TimeoutException) {
                throw (TimeoutException)exception;
            }
        }
        throw new IOException("failed to connect");
    }

    private static List<Address> shuffle(List<Address> list) {
        ArrayList<Address> arrayList = new ArrayList<Address>(list);
        Collections.shuffle(arrayList);
        return arrayList;
    }

    protected RecoveryAwareAMQConnection createConnection(ConnectionParams connectionParams, FrameHandler frameHandler, MetricsCollector metricsCollector) {
        return new RecoveryAwareAMQConnection(connectionParams, frameHandler, metricsCollector);
    }
}

