/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl.recovery;

import com.contrastsecurity.thirdparty.crmq.client.AMQP;
import com.contrastsecurity.thirdparty.crmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.AutorecoveringConnection;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.DefaultRetryHandler;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RecordedBinding;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RecordedConsumer;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RecordedEntity;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RecordedQueue;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RecordedQueueBinding;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.RetryContext;
import com.contrastsecurity.thirdparty.crmq.client.impl.recovery.TopologyRecoveryRetryHandlerBuilder;
import com.contrastsecurity.thirdparty.crmq.utility.Utility;

public abstract class TopologyRecoveryRetryLogic {
    public static final DefaultRetryHandler.RetryCondition<RecordedEntity> CHANNEL_CLOSED_NOT_FOUND = new DefaultRetryHandler.RetryCondition<RecordedEntity>(){

        @Override
        public boolean test(RecordedEntity recordedEntity, Exception exception) {
            ShutdownSignalException shutdownSignalException;
            if (exception.getCause() instanceof ShutdownSignalException && (shutdownSignalException = (ShutdownSignalException)exception.getCause()).getReason() instanceof AMQP.Channel.Close) {
                return ((AMQP.Channel.Close)shutdownSignalException.getReason()).getReplyCode() == 404;
            }
            return false;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CHANNEL = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext retryContext) throws Exception {
            if (!retryContext.entity().getChannel().isOpen()) {
                retryContext.connection().recoverChannel(retryContext.entity().getChannel());
            }
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING_QUEUE = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext retryContext) {
            if (retryContext.entity() instanceof RecordedQueueBinding) {
                RecordedBinding recordedBinding = retryContext.binding();
                AutorecoveringConnection autorecoveringConnection = retryContext.connection();
                RecordedQueue recordedQueue = autorecoveringConnection.getRecordedQueues().get(recordedBinding.getDestination());
                if (recordedQueue != null) {
                    autorecoveringConnection.recoverQueue(recordedQueue.getName(), recordedQueue, false);
                }
            }
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext retryContext) throws Exception {
            retryContext.binding().recover();
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext retryContext) {
            if (retryContext.entity() instanceof RecordedConsumer) {
                RecordedConsumer recordedConsumer = retryContext.consumer();
                AutorecoveringConnection autorecoveringConnection = retryContext.connection();
                RecordedQueue recordedQueue = autorecoveringConnection.getRecordedQueues().get(recordedConsumer.getQueue());
                if (recordedQueue != null) {
                    autorecoveringConnection.recoverQueue(recordedQueue.getName(), recordedQueue, false);
                }
            }
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<String> RECOVER_CONSUMER = new DefaultRetryHandler.RetryOperation<String>(){

        @Override
        public String call(RetryContext retryContext) throws Exception {
            return retryContext.consumer().recover();
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE_BINDINGS = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext retryContext) throws Exception {
            if (retryContext.entity() instanceof RecordedConsumer) {
                String string = retryContext.consumer().getQueue();
                for (RecordedBinding recordedBinding : Utility.copy(retryContext.connection().getRecordedBindings())) {
                    if (!(recordedBinding instanceof RecordedQueueBinding) || !string.equals(recordedBinding.getDestination())) continue;
                    recordedBinding.recover();
                }
            }
            return null;
        }
    };
    public static final TopologyRecoveryRetryHandlerBuilder RETRY_ON_QUEUE_NOT_FOUND_RETRY_HANDLER = TopologyRecoveryRetryHandlerBuilder.builder().bindingRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).consumerRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).bindingRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_BINDING_QUEUE).andThen(RECOVER_BINDING)).consumerRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_CONSUMER_QUEUE.andThen(RECOVER_CONSUMER).andThen(RECOVER_CONSUMER_QUEUE_BINDINGS)));
}

