/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.tools.json;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.crmq.tools.json.JSONSerializable;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter {
    private boolean indentMode = false;
    private int indentLevel = 0;
    private final StringBuilder buf = new StringBuilder();
    static final char[] hex = "0123456789ABCDEF".toCharArray();

    public JSONWriter() {
    }

    public JSONWriter(boolean bl2) {
        this.indentMode = bl2;
    }

    public boolean getIndentMode() {
        return this.indentMode;
    }

    public void setIndentMode(boolean bl2) {
        this.indentMode = bl2;
    }

    private void newline() {
        if (this.indentMode) {
            this.add('\n');
            for (int i2 = 0; i2 < this.indentLevel; ++i2) {
                this.add(' ');
            }
        }
    }

    public String write(Object object) {
        this.buf.setLength(0);
        this.value(object);
        return this.buf.toString();
    }

    public String write(long l2) {
        return this.write((Object)l2);
    }

    public Object write(double d2) {
        return this.write((Object)d2);
    }

    public String write(char c2) {
        return this.write(Character.valueOf(c2));
    }

    public String write(boolean bl2) {
        return this.write((Object)bl2);
    }

    private void value(Object object) {
        if (object == null) {
            this.add("null");
        } else if (object instanceof JSONSerializable) {
            ((JSONSerializable)object).jsonSerialize(this);
        } else if (object instanceof Class) {
            this.string(object);
        } else if (object instanceof Boolean) {
            this.bool((Boolean)object);
        } else if (object instanceof Number) {
            this.add(object);
        } else if (object instanceof String) {
            this.string(object);
        } else if (object instanceof Character) {
            this.string(object);
        } else if (object instanceof Map) {
            this.map((Map)object);
        } else if (object.getClass().isArray()) {
            this.array(object);
        } else if (object instanceof Collection) {
            this.array(((Collection)object).iterator());
        } else {
            this.bean(object);
        }
    }

    private void bean(Object object) {
        this.writeLimited(object.getClass(), object, null);
    }

    public void writeLimited(Class<?> clazz, Object object, String[] stringArray) {
        Object object2;
        Object object3;
        Object object4;
        BeanInfo beanInfo;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (String string : stringArray) {
                hashSet.add(string);
            }
        }
        this.add('{');
        this.indentLevel += 2;
        this.newline();
        boolean bl2 = false;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            beanInfo = null;
        }
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                object4 = propertyDescriptorArray[i2];
                String string = ((FeatureDescriptor)object4).getName();
                if (hashSet == null && string.equals("class") || hashSet != null && !hashSet.contains(string) || (object3 = ((PropertyDescriptor)object4).getReadMethod()) == null || Modifier.isStatic(((Method)object3).getModifiers())) continue;
                try {
                    object2 = ((Method)object3).invoke(object, (Object[])null);
                    if (bl2) {
                        this.add(',');
                        this.newline();
                    }
                    bl2 = true;
                    this.add(string, object2);
                    continue;
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    object2 = exception;
                }
            }
        }
        Field[] fieldArray = object.getClass().getDeclaredFields();
        for (int i3 = 0; i3 < fieldArray.length; ++i3) {
            object4 = fieldArray[i3];
            int n2 = ((Field)object4).getModifiers();
            object3 = ((Field)object4).getName();
            if (hashSet != null && !hashSet.contains(object3) || Modifier.isStatic(n2)) continue;
            try {
                object2 = ((Field)object4).get(object);
                if (bl2) {
                    this.add(',');
                    this.newline();
                }
                bl2 = true;
                this.add((String)object3, object2);
                continue;
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                object2 = exception;
            }
        }
        this.indentLevel -= 2;
        this.newline();
        this.add('}');
    }

    private void add(String string, Object object) {
        this.add('\"');
        this.add(string);
        this.add("\":");
        this.value(object);
    }

    private void map(Map<String, Object> map) {
        this.add('{');
        this.indentLevel += 2;
        this.newline();
        Iterator<String> iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            this.mapEntry(iterator.next(), map);
        }
        while (iterator.hasNext()) {
            this.add(',');
            this.newline();
            String string = iterator.next();
            this.value(string);
            this.add(':');
            this.value(map.get(string));
        }
        this.indentLevel -= 2;
        this.newline();
        this.add('}');
    }

    private void mapEntry(Object object, Map<String, Object> map) {
        this.value(object);
        this.add(':');
        this.value(map.get(object));
    }

    private void array(Iterator<?> iterator) {
        this.add('[');
        if (iterator.hasNext()) {
            this.value(iterator.next());
        }
        while (iterator.hasNext()) {
            this.add(',');
            this.value(iterator.next());
        }
        this.add(']');
    }

    private void array(Object object) {
        this.add('[');
        int n2 = Array.getLength(object);
        if (n2 > 0) {
            this.value(Array.get(object, 0));
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            this.add(',');
            this.value(Array.get(object, i2));
        }
        this.add(']');
    }

    private void bool(boolean bl2) {
        this.add(bl2 ? "true" : "false");
    }

    private void string(Object object) {
        this.add('\"');
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(object.toString());
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (c2 == '\"') {
                this.add("\\\"");
            } else if (c2 == '\\') {
                this.add("\\\\");
            } else if (c2 == '/') {
                this.add("\\/");
            } else if (c2 == '\b') {
                this.add("\\b");
            } else if (c2 == '\f') {
                this.add("\\f");
            } else if (c2 == '\n') {
                this.add("\\n");
            } else if (c2 == '\r') {
                this.add("\\r");
            } else if (c2 == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c2)) {
                this.unicode(c2);
            } else {
                this.add(c2);
            }
            c2 = stringCharacterIterator.next();
        }
        this.add('\"');
    }

    private void add(Object object) {
        this.buf.append(object);
    }

    private void add(char c2) {
        this.buf.append(c2);
    }

    private void unicode(char n2) {
        this.add("\\u");
        int n3 = n2;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = (n3 & 0xF000) >> 12;
            this.add(hex[n4]);
            n3 <<= 4;
        }
    }
}

