/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs;

import com.contrastsecurity.thirdparty.dfs.CircuitBreakerBuilder;
import com.contrastsecurity.thirdparty.dfs.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dfs.CircuitBreakerOpenException;
import com.contrastsecurity.thirdparty.dfs.Policy;
import java.time.Duration;

public interface CircuitBreaker<R>
extends Policy<R> {
    public static <R> CircuitBreakerBuilder<R> builder() {
        return new CircuitBreakerBuilder();
    }

    public static <R> CircuitBreakerBuilder<R> builder(CircuitBreakerConfig<R> circuitBreakerConfig) {
        return new CircuitBreakerBuilder<R>(circuitBreakerConfig);
    }

    public static <R> CircuitBreaker<R> ofDefaults() {
        return CircuitBreaker.builder().build();
    }

    @Override
    public CircuitBreakerConfig<R> getConfig();

    default public void acquirePermit() {
        if (!this.tryAcquirePermit()) {
            throw new CircuitBreakerOpenException(this);
        }
    }

    public boolean tryAcquirePermit();

    public void open();

    public void close();

    public void halfOpen();

    public State getState();

    public int getExecutionCount();

    public Duration getRemainingDelay();

    public long getFailureCount();

    public int getFailureRate();

    public int getSuccessCount();

    public int getSuccessRate();

    public boolean isClosed();

    public boolean isHalfOpen();

    public boolean isOpen();

    public void recordFailure();

    public void recordException(Throwable var1);

    @Deprecated
    public void recordFailure(Throwable var1);

    public void recordResult(R var1);

    public void recordSuccess();

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

