/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs;

import com.contrastsecurity.thirdparty.dfs.DelayablePolicyConfig;
import com.contrastsecurity.thirdparty.dfs.FailurePolicyBuilder;
import com.contrastsecurity.thirdparty.dfs.function.ContextualSupplier;
import com.contrastsecurity.thirdparty.dfs.internal.util.Assert;
import java.time.Duration;

public abstract class DelayablePolicyBuilder<S, C extends DelayablePolicyConfig<R>, R>
extends FailurePolicyBuilder<S, C, R> {
    protected DelayablePolicyBuilder(C c2) {
        super(c2);
    }

    public S withDelay(Duration duration) {
        Assert.notNull(duration, "delay");
        Assert.isTrue(duration.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        ((DelayablePolicyConfig)this.config).delay = duration;
        return (S)this;
    }

    public S withDelayFn(ContextualSupplier<R, Duration> contextualSupplier) {
        Assert.notNull(contextualSupplier, "delayFunction");
        ((DelayablePolicyConfig)this.config).delayFn = contextualSupplier;
        return (S)this;
    }

    public <F extends Throwable> S withDelayFnOn(ContextualSupplier<R, Duration> contextualSupplier, Class<F> clazz) {
        this.withDelayFn(contextualSupplier);
        Assert.notNull(clazz, "exception");
        ((DelayablePolicyConfig)this.config).delayException = clazz;
        return (S)this;
    }

    public S withDelayFnWhen(ContextualSupplier<R, Duration> contextualSupplier, R r2) {
        this.withDelayFn(contextualSupplier);
        Assert.notNull(r2, "result");
        ((DelayablePolicyConfig)this.config).delayResult = r2;
        return (S)this;
    }
}

