/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs;

import com.contrastsecurity.thirdparty.dfs.Policy;
import com.contrastsecurity.thirdparty.dfs.RateLimitExceededException;
import com.contrastsecurity.thirdparty.dfs.RateLimiterBuilder;
import com.contrastsecurity.thirdparty.dfs.RateLimiterConfig;
import java.time.Duration;

public interface RateLimiter<R>
extends Policy<R> {
    public static <R> RateLimiterBuilder<R> smoothBuilder(long l2, Duration duration) {
        return new RateLimiterBuilder(duration.dividedBy(l2));
    }

    public static <R> RateLimiterBuilder<R> smoothBuilder(Duration duration) {
        return new RateLimiterBuilder(duration);
    }

    public static <R> RateLimiterBuilder<R> burstyBuilder(long l2, Duration duration) {
        return new RateLimiterBuilder(l2, duration);
    }

    public static <R> RateLimiterBuilder<R> builder(RateLimiterConfig<R> rateLimiterConfig) {
        return new RateLimiterBuilder<R>(rateLimiterConfig);
    }

    @Override
    public RateLimiterConfig<R> getConfig();

    default public void acquirePermit() throws InterruptedException {
        this.acquirePermits(1);
    }

    public void acquirePermits(int var1) throws InterruptedException;

    default public void acquirePermit(Duration duration) throws InterruptedException {
        this.acquirePermits(1, duration);
    }

    default public void acquirePermits(int n2, Duration duration) throws InterruptedException {
        if (!this.tryAcquirePermits(n2, duration)) {
            throw new RateLimitExceededException(this);
        }
    }

    default public boolean isSmooth() {
        return ((RateLimiterConfig)this.getConfig()).getMaxRate() != null;
    }

    default public boolean isBursty() {
        return ((RateLimiterConfig)this.getConfig()).getPeriod() != null;
    }

    default public Duration reservePermit() {
        return this.reservePermits(1);
    }

    public Duration reservePermits(int var1);

    default public Duration tryReservePermit(Duration duration) {
        return this.tryReservePermits(1, duration);
    }

    public Duration tryReservePermits(int var1, Duration var2);

    default public boolean tryAcquirePermit() {
        return this.tryAcquirePermits(1);
    }

    public boolean tryAcquirePermits(int var1);

    default public boolean tryAcquirePermit(Duration duration) throws InterruptedException {
        return this.tryAcquirePermits(1, duration);
    }

    public boolean tryAcquirePermits(int var1, Duration var2) throws InterruptedException;
}

