/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs;

import com.contrastsecurity.thirdparty.dfs.DelayablePolicyBuilder;
import com.contrastsecurity.thirdparty.dfs.PolicyListeners;
import com.contrastsecurity.thirdparty.dfs.RetryPolicy;
import com.contrastsecurity.thirdparty.dfs.RetryPolicyConfig;
import com.contrastsecurity.thirdparty.dfs.event.EventListener;
import com.contrastsecurity.thirdparty.dfs.event.ExecutionAttemptedEvent;
import com.contrastsecurity.thirdparty.dfs.event.ExecutionCompletedEvent;
import com.contrastsecurity.thirdparty.dfs.event.ExecutionScheduledEvent;
import com.contrastsecurity.thirdparty.dfs.function.CheckedBiPredicate;
import com.contrastsecurity.thirdparty.dfs.function.CheckedPredicate;
import com.contrastsecurity.thirdparty.dfs.internal.RetryPolicyImpl;
import com.contrastsecurity.thirdparty.dfs.internal.util.Assert;
import com.contrastsecurity.thirdparty.dfs.internal.util.Durations;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RetryPolicyBuilder<R>
extends DelayablePolicyBuilder<RetryPolicyBuilder<R>, RetryPolicyConfig<R>, R>
implements PolicyListeners<RetryPolicyBuilder<R>, R> {
    private static final int DEFAULT_MAX_RETRIES = 2;

    RetryPolicyBuilder() {
        super(new RetryPolicyConfig());
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxRetries = 2;
        ((RetryPolicyConfig)this.config).abortConditions = new ArrayList();
    }

    RetryPolicyBuilder(RetryPolicyConfig<R> retryPolicyConfig) {
        super(new RetryPolicyConfig<R>(retryPolicyConfig));
    }

    public RetryPolicy<R> build() {
        return new RetryPolicyImpl(new RetryPolicyConfig((RetryPolicyConfig)this.config));
    }

    public RetryPolicyBuilder<R> abortIf(CheckedBiPredicate<R, ? extends Throwable> checkedBiPredicate) {
        Assert.notNull(checkedBiPredicate, "completionPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(checkedBiPredicate);
        return this;
    }

    public RetryPolicyBuilder<R> abortIf(CheckedPredicate<R> checkedPredicate) {
        Assert.notNull(checkedPredicate, "resultPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(checkedPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> clazz) {
        Assert.notNull(clazz, "exception");
        return this.abortOn(Arrays.asList(clazz));
    }

    @SafeVarargs
    public final RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> ... classArray) {
        Assert.notNull(classArray, "exceptions");
        Assert.isTrue(classArray.length > 0, "exceptions cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(classArray));
    }

    public RetryPolicyBuilder<R> abortOn(List<Class<? extends Throwable>> list) {
        Assert.notNull(list, "exceptions");
        Assert.isTrue(!list.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(list));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(CheckedPredicate<? extends Throwable> checkedPredicate) {
        Assert.notNull(checkedPredicate, "abortPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(checkedPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortWhen(R r2) {
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(r2));
        return this;
    }

    public RetryPolicyBuilder<R> onAbort(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).abortListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).failedAttemptListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetriesExceeded(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).retriesExceededListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetry(EventListener<ExecutionAttemptedEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).retryListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetryScheduled(EventListener<ExecutionScheduledEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).retryScheduledListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> withBackoff(Duration duration, Duration duration2) {
        return this.withBackoff(duration, duration2, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long l2, long l3, ChronoUnit chronoUnit) {
        return this.withBackoff(l2, l3, chronoUnit, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long l2, long l3, ChronoUnit chronoUnit, double d2) {
        return this.withBackoff(Duration.of(l2, chronoUnit), Duration.of(l3, chronoUnit), d2);
    }

    public RetryPolicyBuilder<R> withBackoff(Duration duration, Duration duration2, double d2) {
        Assert.notNull(duration, "delay");
        Assert.notNull(duration2, "maxDelay");
        duration = Durations.ofSafeNanos(duration);
        duration2 = Durations.ofSafeNanos(duration2);
        Assert.isTrue(!duration.isNegative() && !duration.isZero(), "The delay must be > 0", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || duration.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || duration.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        Assert.isTrue(duration.toNanos() < duration2.toNanos(), "delay must be < the maxDelay", new Object[0]);
        Assert.isTrue(d2 > 1.0, "delayFactor must be > 1", new Object[0]);
        ((RetryPolicyConfig)this.config).delay = duration;
        ((RetryPolicyConfig)this.config).maxDelay = duration2;
        ((RetryPolicyConfig)this.config).delayFactor = d2;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    @Override
    public RetryPolicyBuilder<R> withDelay(Duration duration) {
        Assert.notNull(duration, "delay");
        duration = Durations.ofSafeNanos(duration);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || duration.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || duration.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        super.withDelay(duration);
        ((RetryPolicyConfig)this.config).maxDelay = null;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    public RetryPolicyBuilder<R> withDelay(long l2, long l3, ChronoUnit chronoUnit) {
        return this.withDelay(Duration.of(l2, chronoUnit), Duration.of(l3, chronoUnit));
    }

    public RetryPolicyBuilder<R> withDelay(Duration duration, Duration duration2) {
        Assert.notNull(duration, "delayMin");
        Assert.notNull(duration2, "delayMax");
        duration = Durations.ofSafeNanos(duration);
        duration2 = Durations.ofSafeNanos(duration2);
        Assert.isTrue(!duration.isNegative() && !duration.isZero(), "delayMin must be > 0", new Object[0]);
        Assert.isTrue(!duration2.isNegative() && !duration2.isZero(), "delayMax must be > 0", new Object[0]);
        Assert.isTrue(duration.toNanos() < duration2.toNanos(), "delayMin must be < delayMax", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || duration2.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delayMax must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || duration.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delayMin must be >= the jitter duration", new Object[0]);
        ((RetryPolicyConfig)this.config).delayMin = duration;
        ((RetryPolicyConfig)this.config).delayMax = duration2;
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxDelay = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(double d2) {
        Assert.isTrue(d2 >= 0.0 && d2 <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        ((RetryPolicyConfig)this.config).jitterFactor = d2;
        ((RetryPolicyConfig)this.config).jitter = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(Duration duration) {
        Assert.notNull(duration, "jitter");
        duration = Durations.ofSafeNanos(duration);
        Assert.isTrue(duration.toNanos() > 0L, "jitter must be > 0", new Object[0]);
        boolean bl2 = ((RetryPolicyConfig)this.config).delayMin != null ? duration.toNanos() <= ((RetryPolicyConfig)this.config).delayMin.toNanos() : ((RetryPolicyConfig)this.config).delay == Duration.ZERO || duration.toNanos() < ((RetryPolicyConfig)this.config).delay.toNanos();
        Assert.state(bl2, "jitter must be < the minimum configured delay", new Object[0]);
        ((RetryPolicyConfig)this.config).jitter = duration;
        ((RetryPolicyConfig)this.config).jitterFactor = 0.0;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxAttempts(int n2) {
        Assert.isTrue(n2 != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(n2 >= -1, "maxAttempts must be >= -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = n2 == -1 ? -1 : n2 - 1;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxDuration(Duration duration) {
        Assert.notNull(duration, "maxDuration");
        duration = Durations.ofSafeNanos(duration);
        Assert.state(duration.toNanos() > ((RetryPolicyConfig)this.config).delay.toNanos(), "maxDuration must be > the delay", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMax == null || duration.toNanos() > ((RetryPolicyConfig)this.config).delayMax.toNanos(), "maxDuration must be > the max random delay", new Object[0]);
        ((RetryPolicyConfig)this.config).maxDuration = duration;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxRetries(int n2) {
        Assert.isTrue(n2 >= -1, "maxRetries must be >= to -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = n2;
        return this;
    }
}

